/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.AccountsReceivableRetryConfig;
import com.ultracart.admin.v2.models.AccountsReceivableRetryConfigResponse;
import com.ultracart.admin.v2.models.AccountsReceivableRetryStatsResponse;
import com.ultracart.admin.v2.models.BaseResponse;
import com.ultracart.admin.v2.models.Order;
import com.ultracart.admin.v2.models.OrderByTokenQuery;
import com.ultracart.admin.v2.models.OrderFormat;
import com.ultracart.admin.v2.models.OrderFormatResponse;
import com.ultracart.admin.v2.models.OrderPackingSlipResponse;
import com.ultracart.admin.v2.models.OrderProcessPaymentRequest;
import com.ultracart.admin.v2.models.OrderProcessPaymentResponse;
import com.ultracart.admin.v2.models.OrderQuery;
import com.ultracart.admin.v2.models.OrderQueryBatch;
import com.ultracart.admin.v2.models.OrderReplacement;
import com.ultracart.admin.v2.models.OrderReplacementResponse;
import com.ultracart.admin.v2.models.OrderResponse;
import com.ultracart.admin.v2.models.OrderTokenResponse;
import com.ultracart.admin.v2.models.OrdersResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class OrderApi {
    private ApiClient apiClient;

    public OrderApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrderApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OrderApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public OrderApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call adjustOrderTotalCall(String orderId, String desiredTotal, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/orders/{order_id}/adjust_order_total/{desired_total}".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString())).replaceAll("\\{desired_total\\}", this.apiClient.escapeString(desiredTotal.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call adjustOrderTotalValidateBeforeCall(String orderId, String desiredTotal, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling adjustOrderTotal(Async)");
        }
        if (desiredTotal == null) {
            throw new ApiException("Missing the required parameter 'desiredTotal' when calling adjustOrderTotal(Async)");
        }
        Call call = this.adjustOrderTotalCall(orderId, desiredTotal, progressListener, progressRequestListener);
        return call;
    }

    public BaseResponse adjustOrderTotal(String orderId, String desiredTotal) throws ApiException {
        ApiResponse<BaseResponse> resp = this.adjustOrderTotalWithHttpInfo(orderId, desiredTotal);
        return resp.getData();
    }

    public ApiResponse<BaseResponse> adjustOrderTotalWithHttpInfo(String orderId, String desiredTotal) throws ApiException {
        Call call = this.adjustOrderTotalValidateBeforeCall(orderId, desiredTotal, null, null);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call adjustOrderTotalAsync(String orderId, String desiredTotal, final ApiCallback<BaseResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.adjustOrderTotalValidateBeforeCall(orderId, desiredTotal, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call cancelOrderCall(String orderId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/orders/{order_id}/cancel".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call cancelOrderValidateBeforeCall(String orderId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelOrder(Async)");
        }
        Call call = this.cancelOrderCall(orderId, progressListener, progressRequestListener);
        return call;
    }

    public BaseResponse cancelOrder(String orderId) throws ApiException {
        ApiResponse<BaseResponse> resp = this.cancelOrderWithHttpInfo(orderId);
        return resp.getData();
    }

    public ApiResponse<BaseResponse> cancelOrderWithHttpInfo(String orderId) throws ApiException {
        Call call = this.cancelOrderValidateBeforeCall(orderId, null, null);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call cancelOrderAsync(String orderId, final ApiCallback<BaseResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.cancelOrderValidateBeforeCall(orderId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteOrderCall(String orderId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/orders/{order_id}".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteOrderValidateBeforeCall(String orderId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling deleteOrder(Async)");
        }
        Call call = this.deleteOrderCall(orderId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteOrder(String orderId) throws ApiException {
        this.deleteOrderWithHttpInfo(orderId);
    }

    public ApiResponse<Void> deleteOrderWithHttpInfo(String orderId) throws ApiException {
        Call call = this.deleteOrderValidateBeforeCall(orderId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteOrderAsync(String orderId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteOrderValidateBeforeCall(orderId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call duplicateOrderCall(String orderId, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/orders/{order_id}/duplicate".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call duplicateOrderValidateBeforeCall(String orderId, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling duplicateOrder(Async)");
        }
        Call call = this.duplicateOrderCall(orderId, expand, progressListener, progressRequestListener);
        return call;
    }

    public OrderResponse duplicateOrder(String orderId, String expand) throws ApiException {
        ApiResponse<OrderResponse> resp = this.duplicateOrderWithHttpInfo(orderId, expand);
        return resp.getData();
    }

    public ApiResponse<OrderResponse> duplicateOrderWithHttpInfo(String orderId, String expand) throws ApiException {
        Call call = this.duplicateOrderValidateBeforeCall(orderId, expand, null, null);
        Type localVarReturnType = new TypeToken<OrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call duplicateOrderAsync(String orderId, String expand, final ApiCallback<OrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.duplicateOrderValidateBeforeCall(orderId, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call formatCall(String orderId, OrderFormat formatOptions, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OrderFormat localVarPostBody = formatOptions;
        String localVarPath = "/order/orders/{order_id}/format".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call formatValidateBeforeCall(String orderId, OrderFormat formatOptions, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling format(Async)");
        }
        if (formatOptions == null) {
            throw new ApiException("Missing the required parameter 'formatOptions' when calling format(Async)");
        }
        Call call = this.formatCall(orderId, formatOptions, progressListener, progressRequestListener);
        return call;
    }

    public OrderFormatResponse format(String orderId, OrderFormat formatOptions) throws ApiException {
        ApiResponse<OrderFormatResponse> resp = this.formatWithHttpInfo(orderId, formatOptions);
        return resp.getData();
    }

    public ApiResponse<OrderFormatResponse> formatWithHttpInfo(String orderId, OrderFormat formatOptions) throws ApiException {
        Call call = this.formatValidateBeforeCall(orderId, formatOptions, null, null);
        Type localVarReturnType = new TypeToken<OrderFormatResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call formatAsync(String orderId, OrderFormat formatOptions, final ApiCallback<OrderFormatResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.formatValidateBeforeCall(orderId, formatOptions, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderFormatResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generateOrderTokenCall(String orderId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/orders/token/{order_id}".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateOrderTokenValidateBeforeCall(String orderId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling generateOrderToken(Async)");
        }
        Call call = this.generateOrderTokenCall(orderId, progressListener, progressRequestListener);
        return call;
    }

    public OrderTokenResponse generateOrderToken(String orderId) throws ApiException {
        ApiResponse<OrderTokenResponse> resp = this.generateOrderTokenWithHttpInfo(orderId);
        return resp.getData();
    }

    public ApiResponse<OrderTokenResponse> generateOrderTokenWithHttpInfo(String orderId) throws ApiException {
        Call call = this.generateOrderTokenValidateBeforeCall(orderId, null, null);
        Type localVarReturnType = new TypeToken<OrderTokenResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generateOrderTokenAsync(String orderId, final ApiCallback<OrderTokenResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generateOrderTokenValidateBeforeCall(orderId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderTokenResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generatePackingSlipAllDCCall(String orderId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/orders/{order_id}/packing_slip".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generatePackingSlipAllDCValidateBeforeCall(String orderId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling generatePackingSlipAllDC(Async)");
        }
        Call call = this.generatePackingSlipAllDCCall(orderId, progressListener, progressRequestListener);
        return call;
    }

    public OrderPackingSlipResponse generatePackingSlipAllDC(String orderId) throws ApiException {
        ApiResponse<OrderPackingSlipResponse> resp = this.generatePackingSlipAllDCWithHttpInfo(orderId);
        return resp.getData();
    }

    public ApiResponse<OrderPackingSlipResponse> generatePackingSlipAllDCWithHttpInfo(String orderId) throws ApiException {
        Call call = this.generatePackingSlipAllDCValidateBeforeCall(orderId, null, null);
        Type localVarReturnType = new TypeToken<OrderPackingSlipResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generatePackingSlipAllDCAsync(String orderId, final ApiCallback<OrderPackingSlipResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generatePackingSlipAllDCValidateBeforeCall(orderId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderPackingSlipResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generatePackingSlipSpecificDCCall(String distributionCenterCode, String orderId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/orders/{order_id}/packing_slip/{distribution_center_code}".replaceAll("\\{distribution_center_code\\}", this.apiClient.escapeString(distributionCenterCode.toString())).replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generatePackingSlipSpecificDCValidateBeforeCall(String distributionCenterCode, String orderId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (distributionCenterCode == null) {
            throw new ApiException("Missing the required parameter 'distributionCenterCode' when calling generatePackingSlipSpecificDC(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling generatePackingSlipSpecificDC(Async)");
        }
        Call call = this.generatePackingSlipSpecificDCCall(distributionCenterCode, orderId, progressListener, progressRequestListener);
        return call;
    }

    public OrderPackingSlipResponse generatePackingSlipSpecificDC(String distributionCenterCode, String orderId) throws ApiException {
        ApiResponse<OrderPackingSlipResponse> resp = this.generatePackingSlipSpecificDCWithHttpInfo(distributionCenterCode, orderId);
        return resp.getData();
    }

    public ApiResponse<OrderPackingSlipResponse> generatePackingSlipSpecificDCWithHttpInfo(String distributionCenterCode, String orderId) throws ApiException {
        Call call = this.generatePackingSlipSpecificDCValidateBeforeCall(distributionCenterCode, orderId, null, null);
        Type localVarReturnType = new TypeToken<OrderPackingSlipResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generatePackingSlipSpecificDCAsync(String distributionCenterCode, String orderId, final ApiCallback<OrderPackingSlipResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generatePackingSlipSpecificDCValidateBeforeCall(distributionCenterCode, orderId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderPackingSlipResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAccountsReceivableRetryConfigCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/accountsReceivableRetryConfig";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAccountsReceivableRetryConfigValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAccountsReceivableRetryConfigCall(progressListener, progressRequestListener);
        return call;
    }

    public AccountsReceivableRetryConfigResponse getAccountsReceivableRetryConfig() throws ApiException {
        ApiResponse<AccountsReceivableRetryConfigResponse> resp = this.getAccountsReceivableRetryConfigWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<AccountsReceivableRetryConfigResponse> getAccountsReceivableRetryConfigWithHttpInfo() throws ApiException {
        Call call = this.getAccountsReceivableRetryConfigValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<AccountsReceivableRetryConfigResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAccountsReceivableRetryConfigAsync(final ApiCallback<AccountsReceivableRetryConfigResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAccountsReceivableRetryConfigValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccountsReceivableRetryConfigResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAccountsReceivableRetryStatsCall(String from, String to, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/accountsReceivableRetryConfig/stats";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (from != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAccountsReceivableRetryStatsValidateBeforeCall(String from, String to, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAccountsReceivableRetryStatsCall(from, to, progressListener, progressRequestListener);
        return call;
    }

    public AccountsReceivableRetryStatsResponse getAccountsReceivableRetryStats(String from, String to) throws ApiException {
        ApiResponse<AccountsReceivableRetryStatsResponse> resp = this.getAccountsReceivableRetryStatsWithHttpInfo(from, to);
        return resp.getData();
    }

    public ApiResponse<AccountsReceivableRetryStatsResponse> getAccountsReceivableRetryStatsWithHttpInfo(String from, String to) throws ApiException {
        Call call = this.getAccountsReceivableRetryStatsValidateBeforeCall(from, to, null, null);
        Type localVarReturnType = new TypeToken<AccountsReceivableRetryStatsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAccountsReceivableRetryStatsAsync(String from, String to, final ApiCallback<AccountsReceivableRetryStatsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAccountsReceivableRetryStatsValidateBeforeCall(from, to, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccountsReceivableRetryStatsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getOrderCall(String orderId, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/orders/{order_id}".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOrderValidateBeforeCall(String orderId, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrder(Async)");
        }
        Call call = this.getOrderCall(orderId, expand, progressListener, progressRequestListener);
        return call;
    }

    public OrderResponse getOrder(String orderId, String expand) throws ApiException {
        ApiResponse<OrderResponse> resp = this.getOrderWithHttpInfo(orderId, expand);
        return resp.getData();
    }

    public ApiResponse<OrderResponse> getOrderWithHttpInfo(String orderId, String expand) throws ApiException {
        Call call = this.getOrderValidateBeforeCall(orderId, expand, null, null);
        Type localVarReturnType = new TypeToken<OrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOrderAsync(String orderId, String expand, final ApiCallback<OrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOrderValidateBeforeCall(orderId, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getOrderByTokenCall(OrderByTokenQuery orderByTokenQuery, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OrderByTokenQuery localVarPostBody = orderByTokenQuery;
        String localVarPath = "/order/orders/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOrderByTokenValidateBeforeCall(OrderByTokenQuery orderByTokenQuery, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderByTokenQuery == null) {
            throw new ApiException("Missing the required parameter 'orderByTokenQuery' when calling getOrderByToken(Async)");
        }
        Call call = this.getOrderByTokenCall(orderByTokenQuery, expand, progressListener, progressRequestListener);
        return call;
    }

    public OrderResponse getOrderByToken(OrderByTokenQuery orderByTokenQuery, String expand) throws ApiException {
        ApiResponse<OrderResponse> resp = this.getOrderByTokenWithHttpInfo(orderByTokenQuery, expand);
        return resp.getData();
    }

    public ApiResponse<OrderResponse> getOrderByTokenWithHttpInfo(OrderByTokenQuery orderByTokenQuery, String expand) throws ApiException {
        Call call = this.getOrderByTokenValidateBeforeCall(orderByTokenQuery, expand, null, null);
        Type localVarReturnType = new TypeToken<OrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOrderByTokenAsync(OrderByTokenQuery orderByTokenQuery, String expand, final ApiCallback<OrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOrderByTokenValidateBeforeCall(orderByTokenQuery, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getOrdersCall(String orderId, String paymentMethod, String company, String firstName, String lastName, String city, String stateRegion, String postalCode, String countryCode, String phone, String email, String ccEmail, BigDecimal total, String screenBrandingThemeCode, String storefrontHostName, String creationDateBegin, String creationDateEnd, String paymentDateBegin, String paymentDateEnd, String shipmentDateBegin, String shipmentDateEnd, String rma, String purchaseOrderNumber, String itemId, String currentStage, String channelPartnerCode, String channelPartnerOrderId, Integer customerProfileOid, String refundDateBegin, String refundDateEnd, String customField1, String customField2, String customField3, String customField4, String customField5, String customField6, String customField7, String shipOnDateBegin, String shipOnDateEnd, Integer limit, Integer offset, String sort, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (orderId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order_id", orderId));
        }
        if (paymentMethod != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("payment_method", paymentMethod));
        }
        if (company != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("company", company));
        }
        if (firstName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("first_name", firstName));
        }
        if (lastName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("last_name", lastName));
        }
        if (city != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("city", city));
        }
        if (stateRegion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("state_region", stateRegion));
        }
        if (postalCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("postal_code", postalCode));
        }
        if (countryCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("country_code", countryCode));
        }
        if (phone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("phone", phone));
        }
        if (email != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", email));
        }
        if (ccEmail != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cc_email", ccEmail));
        }
        if (total != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("total", total));
        }
        if (screenBrandingThemeCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("screen_branding_theme_code", screenBrandingThemeCode));
        }
        if (storefrontHostName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("storefront_host_name", storefrontHostName));
        }
        if (creationDateBegin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("creation_date_begin", creationDateBegin));
        }
        if (creationDateEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("creation_date_end", creationDateEnd));
        }
        if (paymentDateBegin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("payment_date_begin", paymentDateBegin));
        }
        if (paymentDateEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("payment_date_end", paymentDateEnd));
        }
        if (shipmentDateBegin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipment_date_begin", shipmentDateBegin));
        }
        if (shipmentDateEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipment_date_end", shipmentDateEnd));
        }
        if (rma != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("rma", rma));
        }
        if (purchaseOrderNumber != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("purchase_order_number", purchaseOrderNumber));
        }
        if (itemId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("item_id", itemId));
        }
        if (currentStage != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("current_stage", currentStage));
        }
        if (channelPartnerCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("channel_partner_code", channelPartnerCode));
        }
        if (channelPartnerOrderId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("channel_partner_order_id", channelPartnerOrderId));
        }
        if (customerProfileOid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("customer_profile_oid", customerProfileOid));
        }
        if (refundDateBegin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("Refund Date Begin", refundDateBegin));
        }
        if (refundDateEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("Refund Date End", refundDateEnd));
        }
        if (customField1 != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("Custom Field 1", customField1));
        }
        if (customField2 != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("Custom Field 2", customField2));
        }
        if (customField3 != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("Custom Field 3", customField3));
        }
        if (customField4 != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("Custom Field 4", customField4));
        }
        if (customField5 != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("Custom Field 5", customField5));
        }
        if (customField6 != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("Custom Field 6", customField6));
        }
        if (customField7 != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("Custom Field 7", customField7));
        }
        if (shipOnDateBegin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ship_on_date_begin", shipOnDateBegin));
        }
        if (shipOnDateEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ship_on_date_end", shipOnDateEnd));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOrdersValidateBeforeCall(String orderId, String paymentMethod, String company, String firstName, String lastName, String city, String stateRegion, String postalCode, String countryCode, String phone, String email, String ccEmail, BigDecimal total, String screenBrandingThemeCode, String storefrontHostName, String creationDateBegin, String creationDateEnd, String paymentDateBegin, String paymentDateEnd, String shipmentDateBegin, String shipmentDateEnd, String rma, String purchaseOrderNumber, String itemId, String currentStage, String channelPartnerCode, String channelPartnerOrderId, Integer customerProfileOid, String refundDateBegin, String refundDateEnd, String customField1, String customField2, String customField3, String customField4, String customField5, String customField6, String customField7, String shipOnDateBegin, String shipOnDateEnd, Integer limit, Integer offset, String sort, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getOrdersCall(orderId, paymentMethod, company, firstName, lastName, city, stateRegion, postalCode, countryCode, phone, email, ccEmail, total, screenBrandingThemeCode, storefrontHostName, creationDateBegin, creationDateEnd, paymentDateBegin, paymentDateEnd, shipmentDateBegin, shipmentDateEnd, rma, purchaseOrderNumber, itemId, currentStage, channelPartnerCode, channelPartnerOrderId, customerProfileOid, refundDateBegin, refundDateEnd, customField1, customField2, customField3, customField4, customField5, customField6, customField7, shipOnDateBegin, shipOnDateEnd, limit, offset, sort, expand, progressListener, progressRequestListener);
        return call;
    }

    public OrdersResponse getOrders(String orderId, String paymentMethod, String company, String firstName, String lastName, String city, String stateRegion, String postalCode, String countryCode, String phone, String email, String ccEmail, BigDecimal total, String screenBrandingThemeCode, String storefrontHostName, String creationDateBegin, String creationDateEnd, String paymentDateBegin, String paymentDateEnd, String shipmentDateBegin, String shipmentDateEnd, String rma, String purchaseOrderNumber, String itemId, String currentStage, String channelPartnerCode, String channelPartnerOrderId, Integer customerProfileOid, String refundDateBegin, String refundDateEnd, String customField1, String customField2, String customField3, String customField4, String customField5, String customField6, String customField7, String shipOnDateBegin, String shipOnDateEnd, Integer limit, Integer offset, String sort, String expand) throws ApiException {
        ApiResponse<OrdersResponse> resp = this.getOrdersWithHttpInfo(orderId, paymentMethod, company, firstName, lastName, city, stateRegion, postalCode, countryCode, phone, email, ccEmail, total, screenBrandingThemeCode, storefrontHostName, creationDateBegin, creationDateEnd, paymentDateBegin, paymentDateEnd, shipmentDateBegin, shipmentDateEnd, rma, purchaseOrderNumber, itemId, currentStage, channelPartnerCode, channelPartnerOrderId, customerProfileOid, refundDateBegin, refundDateEnd, customField1, customField2, customField3, customField4, customField5, customField6, customField7, shipOnDateBegin, shipOnDateEnd, limit, offset, sort, expand);
        return resp.getData();
    }

    public ApiResponse<OrdersResponse> getOrdersWithHttpInfo(String orderId, String paymentMethod, String company, String firstName, String lastName, String city, String stateRegion, String postalCode, String countryCode, String phone, String email, String ccEmail, BigDecimal total, String screenBrandingThemeCode, String storefrontHostName, String creationDateBegin, String creationDateEnd, String paymentDateBegin, String paymentDateEnd, String shipmentDateBegin, String shipmentDateEnd, String rma, String purchaseOrderNumber, String itemId, String currentStage, String channelPartnerCode, String channelPartnerOrderId, Integer customerProfileOid, String refundDateBegin, String refundDateEnd, String customField1, String customField2, String customField3, String customField4, String customField5, String customField6, String customField7, String shipOnDateBegin, String shipOnDateEnd, Integer limit, Integer offset, String sort, String expand) throws ApiException {
        Call call = this.getOrdersValidateBeforeCall(orderId, paymentMethod, company, firstName, lastName, city, stateRegion, postalCode, countryCode, phone, email, ccEmail, total, screenBrandingThemeCode, storefrontHostName, creationDateBegin, creationDateEnd, paymentDateBegin, paymentDateEnd, shipmentDateBegin, shipmentDateEnd, rma, purchaseOrderNumber, itemId, currentStage, channelPartnerCode, channelPartnerOrderId, customerProfileOid, refundDateBegin, refundDateEnd, customField1, customField2, customField3, customField4, customField5, customField6, customField7, shipOnDateBegin, shipOnDateEnd, limit, offset, sort, expand, null, null);
        Type localVarReturnType = new TypeToken<OrdersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOrdersAsync(String orderId, String paymentMethod, String company, String firstName, String lastName, String city, String stateRegion, String postalCode, String countryCode, String phone, String email, String ccEmail, BigDecimal total, String screenBrandingThemeCode, String storefrontHostName, String creationDateBegin, String creationDateEnd, String paymentDateBegin, String paymentDateEnd, String shipmentDateBegin, String shipmentDateEnd, String rma, String purchaseOrderNumber, String itemId, String currentStage, String channelPartnerCode, String channelPartnerOrderId, Integer customerProfileOid, String refundDateBegin, String refundDateEnd, String customField1, String customField2, String customField3, String customField4, String customField5, String customField6, String customField7, String shipOnDateBegin, String shipOnDateEnd, Integer limit, Integer offset, String sort, String expand, final ApiCallback<OrdersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOrdersValidateBeforeCall(orderId, paymentMethod, company, firstName, lastName, city, stateRegion, postalCode, countryCode, phone, email, ccEmail, total, screenBrandingThemeCode, storefrontHostName, creationDateBegin, creationDateEnd, paymentDateBegin, paymentDateEnd, shipmentDateBegin, shipmentDateEnd, rma, purchaseOrderNumber, itemId, currentStage, channelPartnerCode, channelPartnerOrderId, customerProfileOid, refundDateBegin, refundDateEnd, customField1, customField2, customField3, customField4, customField5, customField6, customField7, shipOnDateBegin, shipOnDateEnd, limit, offset, sort, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrdersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getOrdersBatchCall(OrderQueryBatch orderBatch, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OrderQueryBatch localVarPostBody = orderBatch;
        String localVarPath = "/order/orders/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOrdersBatchValidateBeforeCall(OrderQueryBatch orderBatch, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderBatch == null) {
            throw new ApiException("Missing the required parameter 'orderBatch' when calling getOrdersBatch(Async)");
        }
        Call call = this.getOrdersBatchCall(orderBatch, expand, progressListener, progressRequestListener);
        return call;
    }

    public OrdersResponse getOrdersBatch(OrderQueryBatch orderBatch, String expand) throws ApiException {
        ApiResponse<OrdersResponse> resp = this.getOrdersBatchWithHttpInfo(orderBatch, expand);
        return resp.getData();
    }

    public ApiResponse<OrdersResponse> getOrdersBatchWithHttpInfo(OrderQueryBatch orderBatch, String expand) throws ApiException {
        Call call = this.getOrdersBatchValidateBeforeCall(orderBatch, expand, null, null);
        Type localVarReturnType = new TypeToken<OrdersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOrdersBatchAsync(OrderQueryBatch orderBatch, String expand, final ApiCallback<OrdersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOrdersBatchValidateBeforeCall(orderBatch, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrdersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getOrdersByQueryCall(OrderQuery orderQuery, Integer limit, Integer offset, String sort, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OrderQuery localVarPostBody = orderQuery;
        String localVarPath = "/order/orders/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOrdersByQueryValidateBeforeCall(OrderQuery orderQuery, Integer limit, Integer offset, String sort, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderQuery == null) {
            throw new ApiException("Missing the required parameter 'orderQuery' when calling getOrdersByQuery(Async)");
        }
        Call call = this.getOrdersByQueryCall(orderQuery, limit, offset, sort, expand, progressListener, progressRequestListener);
        return call;
    }

    public OrdersResponse getOrdersByQuery(OrderQuery orderQuery, Integer limit, Integer offset, String sort, String expand) throws ApiException {
        ApiResponse<OrdersResponse> resp = this.getOrdersByQueryWithHttpInfo(orderQuery, limit, offset, sort, expand);
        return resp.getData();
    }

    public ApiResponse<OrdersResponse> getOrdersByQueryWithHttpInfo(OrderQuery orderQuery, Integer limit, Integer offset, String sort, String expand) throws ApiException {
        Call call = this.getOrdersByQueryValidateBeforeCall(orderQuery, limit, offset, sort, expand, null, null);
        Type localVarReturnType = new TypeToken<OrdersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOrdersByQueryAsync(OrderQuery orderQuery, Integer limit, Integer offset, String sort, String expand, final ApiCallback<OrdersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOrdersByQueryValidateBeforeCall(orderQuery, limit, offset, sort, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrdersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call insertOrderCall(Order order, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Order localVarPostBody = order;
        String localVarPath = "/order/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call insertOrderValidateBeforeCall(Order order, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (order == null) {
            throw new ApiException("Missing the required parameter 'order' when calling insertOrder(Async)");
        }
        Call call = this.insertOrderCall(order, expand, progressListener, progressRequestListener);
        return call;
    }

    public OrderResponse insertOrder(Order order, String expand) throws ApiException {
        ApiResponse<OrderResponse> resp = this.insertOrderWithHttpInfo(order, expand);
        return resp.getData();
    }

    public ApiResponse<OrderResponse> insertOrderWithHttpInfo(Order order, String expand) throws ApiException {
        Call call = this.insertOrderValidateBeforeCall(order, expand, null, null);
        Type localVarReturnType = new TypeToken<OrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call insertOrderAsync(Order order, String expand, final ApiCallback<OrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.insertOrderValidateBeforeCall(order, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call processPaymentCall(String orderId, OrderProcessPaymentRequest processPaymentRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OrderProcessPaymentRequest localVarPostBody = processPaymentRequest;
        String localVarPath = "/order/orders/{order_id}/process_payment".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call processPaymentValidateBeforeCall(String orderId, OrderProcessPaymentRequest processPaymentRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling processPayment(Async)");
        }
        if (processPaymentRequest == null) {
            throw new ApiException("Missing the required parameter 'processPaymentRequest' when calling processPayment(Async)");
        }
        Call call = this.processPaymentCall(orderId, processPaymentRequest, progressListener, progressRequestListener);
        return call;
    }

    public OrderProcessPaymentResponse processPayment(String orderId, OrderProcessPaymentRequest processPaymentRequest) throws ApiException {
        ApiResponse<OrderProcessPaymentResponse> resp = this.processPaymentWithHttpInfo(orderId, processPaymentRequest);
        return resp.getData();
    }

    public ApiResponse<OrderProcessPaymentResponse> processPaymentWithHttpInfo(String orderId, OrderProcessPaymentRequest processPaymentRequest) throws ApiException {
        Call call = this.processPaymentValidateBeforeCall(orderId, processPaymentRequest, null, null);
        Type localVarReturnType = new TypeToken<OrderProcessPaymentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call processPaymentAsync(String orderId, OrderProcessPaymentRequest processPaymentRequest, final ApiCallback<OrderProcessPaymentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.processPaymentValidateBeforeCall(orderId, processPaymentRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderProcessPaymentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call refundOrderCall(Order order, String orderId, Boolean rejectAfterRefund, Boolean skipCustomerNotification, Boolean autoOrderCancel, Boolean manualRefund, Boolean reverseAffiliateTransactions, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Order localVarPostBody = order;
        String localVarPath = "/order/orders/{order_id}/refund".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (rejectAfterRefund != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reject_after_refund", rejectAfterRefund));
        }
        if (skipCustomerNotification != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skip_customer_notification", skipCustomerNotification));
        }
        if (autoOrderCancel != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("auto_order_cancel", autoOrderCancel));
        }
        if (manualRefund != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("manual_refund", manualRefund));
        }
        if (reverseAffiliateTransactions != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reverse_affiliate_transactions", reverseAffiliateTransactions));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call refundOrderValidateBeforeCall(Order order, String orderId, Boolean rejectAfterRefund, Boolean skipCustomerNotification, Boolean autoOrderCancel, Boolean manualRefund, Boolean reverseAffiliateTransactions, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (order == null) {
            throw new ApiException("Missing the required parameter 'order' when calling refundOrder(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling refundOrder(Async)");
        }
        Call call = this.refundOrderCall(order, orderId, rejectAfterRefund, skipCustomerNotification, autoOrderCancel, manualRefund, reverseAffiliateTransactions, expand, progressListener, progressRequestListener);
        return call;
    }

    public OrderResponse refundOrder(Order order, String orderId, Boolean rejectAfterRefund, Boolean skipCustomerNotification, Boolean autoOrderCancel, Boolean manualRefund, Boolean reverseAffiliateTransactions, String expand) throws ApiException {
        ApiResponse<OrderResponse> resp = this.refundOrderWithHttpInfo(order, orderId, rejectAfterRefund, skipCustomerNotification, autoOrderCancel, manualRefund, reverseAffiliateTransactions, expand);
        return resp.getData();
    }

    public ApiResponse<OrderResponse> refundOrderWithHttpInfo(Order order, String orderId, Boolean rejectAfterRefund, Boolean skipCustomerNotification, Boolean autoOrderCancel, Boolean manualRefund, Boolean reverseAffiliateTransactions, String expand) throws ApiException {
        Call call = this.refundOrderValidateBeforeCall(order, orderId, rejectAfterRefund, skipCustomerNotification, autoOrderCancel, manualRefund, reverseAffiliateTransactions, expand, null, null);
        Type localVarReturnType = new TypeToken<OrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call refundOrderAsync(Order order, String orderId, Boolean rejectAfterRefund, Boolean skipCustomerNotification, Boolean autoOrderCancel, Boolean manualRefund, Boolean reverseAffiliateTransactions, String expand, final ApiCallback<OrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.refundOrderValidateBeforeCall(order, orderId, rejectAfterRefund, skipCustomerNotification, autoOrderCancel, manualRefund, reverseAffiliateTransactions, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replacementCall(String orderId, OrderReplacement replacement, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OrderReplacement localVarPostBody = replacement;
        String localVarPath = "/order/orders/{order_id}/replacement".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replacementValidateBeforeCall(String orderId, OrderReplacement replacement, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling replacement(Async)");
        }
        if (replacement == null) {
            throw new ApiException("Missing the required parameter 'replacement' when calling replacement(Async)");
        }
        Call call = this.replacementCall(orderId, replacement, progressListener, progressRequestListener);
        return call;
    }

    public OrderReplacementResponse replacement(String orderId, OrderReplacement replacement) throws ApiException {
        ApiResponse<OrderReplacementResponse> resp = this.replacementWithHttpInfo(orderId, replacement);
        return resp.getData();
    }

    public ApiResponse<OrderReplacementResponse> replacementWithHttpInfo(String orderId, OrderReplacement replacement) throws ApiException {
        Call call = this.replacementValidateBeforeCall(orderId, replacement, null, null);
        Type localVarReturnType = new TypeToken<OrderReplacementResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call replacementAsync(String orderId, OrderReplacement replacement, final ApiCallback<OrderReplacementResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replacementValidateBeforeCall(orderId, replacement, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderReplacementResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call resendReceiptCall(String orderId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/orders/{order_id}/resend_receipt".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call resendReceiptValidateBeforeCall(String orderId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling resendReceipt(Async)");
        }
        Call call = this.resendReceiptCall(orderId, progressListener, progressRequestListener);
        return call;
    }

    public BaseResponse resendReceipt(String orderId) throws ApiException {
        ApiResponse<BaseResponse> resp = this.resendReceiptWithHttpInfo(orderId);
        return resp.getData();
    }

    public ApiResponse<BaseResponse> resendReceiptWithHttpInfo(String orderId) throws ApiException {
        Call call = this.resendReceiptValidateBeforeCall(orderId, null, null);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call resendReceiptAsync(String orderId, final ApiCallback<BaseResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.resendReceiptValidateBeforeCall(orderId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call resendShipmentConfirmationCall(String orderId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/order/orders/{order_id}/resend_shipment_confirmation".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call resendShipmentConfirmationValidateBeforeCall(String orderId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling resendShipmentConfirmation(Async)");
        }
        Call call = this.resendShipmentConfirmationCall(orderId, progressListener, progressRequestListener);
        return call;
    }

    public BaseResponse resendShipmentConfirmation(String orderId) throws ApiException {
        ApiResponse<BaseResponse> resp = this.resendShipmentConfirmationWithHttpInfo(orderId);
        return resp.getData();
    }

    public ApiResponse<BaseResponse> resendShipmentConfirmationWithHttpInfo(String orderId) throws ApiException {
        Call call = this.resendShipmentConfirmationValidateBeforeCall(orderId, null, null);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call resendShipmentConfirmationAsync(String orderId, final ApiCallback<BaseResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.resendShipmentConfirmationValidateBeforeCall(orderId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateAccountsReceivableRetryConfigCall(AccountsReceivableRetryConfig retryConfig, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AccountsReceivableRetryConfig localVarPostBody = retryConfig;
        String localVarPath = "/order/accountsReceivableRetryConfig";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateAccountsReceivableRetryConfigValidateBeforeCall(AccountsReceivableRetryConfig retryConfig, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (retryConfig == null) {
            throw new ApiException("Missing the required parameter 'retryConfig' when calling updateAccountsReceivableRetryConfig(Async)");
        }
        Call call = this.updateAccountsReceivableRetryConfigCall(retryConfig, progressListener, progressRequestListener);
        return call;
    }

    public BaseResponse updateAccountsReceivableRetryConfig(AccountsReceivableRetryConfig retryConfig) throws ApiException {
        ApiResponse<BaseResponse> resp = this.updateAccountsReceivableRetryConfigWithHttpInfo(retryConfig);
        return resp.getData();
    }

    public ApiResponse<BaseResponse> updateAccountsReceivableRetryConfigWithHttpInfo(AccountsReceivableRetryConfig retryConfig) throws ApiException {
        Call call = this.updateAccountsReceivableRetryConfigValidateBeforeCall(retryConfig, null, null);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAccountsReceivableRetryConfigAsync(AccountsReceivableRetryConfig retryConfig, final ApiCallback<BaseResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateAccountsReceivableRetryConfigValidateBeforeCall(retryConfig, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateOrderCall(Order order, String orderId, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Order localVarPostBody = order;
        String localVarPath = "/order/orders/{order_id}".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateOrderValidateBeforeCall(Order order, String orderId, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (order == null) {
            throw new ApiException("Missing the required parameter 'order' when calling updateOrder(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling updateOrder(Async)");
        }
        Call call = this.updateOrderCall(order, orderId, expand, progressListener, progressRequestListener);
        return call;
    }

    public OrderResponse updateOrder(Order order, String orderId, String expand) throws ApiException {
        ApiResponse<OrderResponse> resp = this.updateOrderWithHttpInfo(order, orderId, expand);
        return resp.getData();
    }

    public ApiResponse<OrderResponse> updateOrderWithHttpInfo(Order order, String orderId, String expand) throws ApiException {
        Call call = this.updateOrderValidateBeforeCall(order, orderId, expand, null, null);
        Type localVarReturnType = new TypeToken<OrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateOrderAsync(Order order, String orderId, String expand, final ApiCallback<OrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateOrderValidateBeforeCall(order, orderId, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

