/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.Item;
import com.ultracart.admin.v2.models.ItemResponse;
import com.ultracart.admin.v2.models.ItemsRequest;
import com.ultracart.admin.v2.models.ItemsResponse;
import com.ultracart.admin.v2.models.PricingTiersResponse;
import com.ultracart.admin.v2.models.TempMultimediaResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ItemApi {
    private ApiClient apiClient;

    public ItemApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ItemApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ItemApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public ItemApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteItemCall(Integer merchantItemOid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/item/items/{merchant_item_oid}".replaceAll("\\{merchant_item_oid\\}", this.apiClient.escapeString(merchantItemOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteItemValidateBeforeCall(Integer merchantItemOid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (merchantItemOid == null) {
            throw new ApiException("Missing the required parameter 'merchantItemOid' when calling deleteItem(Async)");
        }
        Call call = this.deleteItemCall(merchantItemOid, progressListener, progressRequestListener);
        return call;
    }

    public void deleteItem(Integer merchantItemOid) throws ApiException {
        this.deleteItemWithHttpInfo(merchantItemOid);
    }

    public ApiResponse<Void> deleteItemWithHttpInfo(Integer merchantItemOid) throws ApiException {
        Call call = this.deleteItemValidateBeforeCall(merchantItemOid, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteItemAsync(Integer merchantItemOid, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteItemValidateBeforeCall(merchantItemOid, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getItemCall(Integer merchantItemOid, String expand, Boolean placeholders, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/item/items/{merchant_item_oid}".replaceAll("\\{merchant_item_oid\\}", this.apiClient.escapeString(merchantItemOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        if (placeholders != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_placeholders", placeholders));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getItemValidateBeforeCall(Integer merchantItemOid, String expand, Boolean placeholders, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (merchantItemOid == null) {
            throw new ApiException("Missing the required parameter 'merchantItemOid' when calling getItem(Async)");
        }
        Call call = this.getItemCall(merchantItemOid, expand, placeholders, progressListener, progressRequestListener);
        return call;
    }

    public ItemResponse getItem(Integer merchantItemOid, String expand, Boolean placeholders) throws ApiException {
        ApiResponse<ItemResponse> resp = this.getItemWithHttpInfo(merchantItemOid, expand, placeholders);
        return resp.getData();
    }

    public ApiResponse<ItemResponse> getItemWithHttpInfo(Integer merchantItemOid, String expand, Boolean placeholders) throws ApiException {
        Call call = this.getItemValidateBeforeCall(merchantItemOid, expand, placeholders, null, null);
        Type localVarReturnType = new TypeToken<ItemResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getItemAsync(Integer merchantItemOid, String expand, Boolean placeholders, final ApiCallback<ItemResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getItemValidateBeforeCall(merchantItemOid, expand, placeholders, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ItemResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getItemByMerchantItemIdCall(String merchantItemId, String expand, Boolean placeholders, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/item/items/merchant_item_id/{merchant_item_id}".replaceAll("\\{merchant_item_id\\}", this.apiClient.escapeString(merchantItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        if (placeholders != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_placeholders", placeholders));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getItemByMerchantItemIdValidateBeforeCall(String merchantItemId, String expand, Boolean placeholders, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (merchantItemId == null) {
            throw new ApiException("Missing the required parameter 'merchantItemId' when calling getItemByMerchantItemId(Async)");
        }
        Call call = this.getItemByMerchantItemIdCall(merchantItemId, expand, placeholders, progressListener, progressRequestListener);
        return call;
    }

    public ItemResponse getItemByMerchantItemId(String merchantItemId, String expand, Boolean placeholders) throws ApiException {
        ApiResponse<ItemResponse> resp = this.getItemByMerchantItemIdWithHttpInfo(merchantItemId, expand, placeholders);
        return resp.getData();
    }

    public ApiResponse<ItemResponse> getItemByMerchantItemIdWithHttpInfo(String merchantItemId, String expand, Boolean placeholders) throws ApiException {
        Call call = this.getItemByMerchantItemIdValidateBeforeCall(merchantItemId, expand, placeholders, null, null);
        Type localVarReturnType = new TypeToken<ItemResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getItemByMerchantItemIdAsync(String merchantItemId, String expand, Boolean placeholders, final ApiCallback<ItemResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getItemByMerchantItemIdValidateBeforeCall(merchantItemId, expand, placeholders, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ItemResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getItemsCall(Integer parentCategoryId, String parentCategoryPath, Integer limit, Integer offset, String since, String sort, String expand, Boolean placeholders, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/item/items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (parentCategoryId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("parent_category_id", parentCategoryId));
        }
        if (parentCategoryPath != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("parent_category_path", parentCategoryPath));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_since", since));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        if (placeholders != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_placeholders", placeholders));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getItemsValidateBeforeCall(Integer parentCategoryId, String parentCategoryPath, Integer limit, Integer offset, String since, String sort, String expand, Boolean placeholders, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getItemsCall(parentCategoryId, parentCategoryPath, limit, offset, since, sort, expand, placeholders, progressListener, progressRequestListener);
        return call;
    }

    public ItemsResponse getItems(Integer parentCategoryId, String parentCategoryPath, Integer limit, Integer offset, String since, String sort, String expand, Boolean placeholders) throws ApiException {
        ApiResponse<ItemsResponse> resp = this.getItemsWithHttpInfo(parentCategoryId, parentCategoryPath, limit, offset, since, sort, expand, placeholders);
        return resp.getData();
    }

    public ApiResponse<ItemsResponse> getItemsWithHttpInfo(Integer parentCategoryId, String parentCategoryPath, Integer limit, Integer offset, String since, String sort, String expand, Boolean placeholders) throws ApiException {
        Call call = this.getItemsValidateBeforeCall(parentCategoryId, parentCategoryPath, limit, offset, since, sort, expand, placeholders, null, null);
        Type localVarReturnType = new TypeToken<ItemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getItemsAsync(Integer parentCategoryId, String parentCategoryPath, Integer limit, Integer offset, String since, String sort, String expand, Boolean placeholders, final ApiCallback<ItemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getItemsValidateBeforeCall(parentCategoryId, parentCategoryPath, limit, offset, since, sort, expand, placeholders, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ItemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getPricingTiersCall(String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/item/pricing_tiers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPricingTiersValidateBeforeCall(String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getPricingTiersCall(expand, progressListener, progressRequestListener);
        return call;
    }

    public PricingTiersResponse getPricingTiers(String expand) throws ApiException {
        ApiResponse<PricingTiersResponse> resp = this.getPricingTiersWithHttpInfo(expand);
        return resp.getData();
    }

    public ApiResponse<PricingTiersResponse> getPricingTiersWithHttpInfo(String expand) throws ApiException {
        Call call = this.getPricingTiersValidateBeforeCall(expand, null, null);
        Type localVarReturnType = new TypeToken<PricingTiersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPricingTiersAsync(String expand, final ApiCallback<PricingTiersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPricingTiersValidateBeforeCall(expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PricingTiersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call insertItemCall(Item item, String expand, Boolean placeholders, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Item localVarPostBody = item;
        String localVarPath = "/item/items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        if (placeholders != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_placeholders", placeholders));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call insertItemValidateBeforeCall(Item item, String expand, Boolean placeholders, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (item == null) {
            throw new ApiException("Missing the required parameter 'item' when calling insertItem(Async)");
        }
        Call call = this.insertItemCall(item, expand, placeholders, progressListener, progressRequestListener);
        return call;
    }

    public ItemResponse insertItem(Item item, String expand, Boolean placeholders) throws ApiException {
        ApiResponse<ItemResponse> resp = this.insertItemWithHttpInfo(item, expand, placeholders);
        return resp.getData();
    }

    public ApiResponse<ItemResponse> insertItemWithHttpInfo(Item item, String expand, Boolean placeholders) throws ApiException {
        Call call = this.insertItemValidateBeforeCall(item, expand, placeholders, null, null);
        Type localVarReturnType = new TypeToken<ItemResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call insertItemAsync(Item item, String expand, Boolean placeholders, final ApiCallback<ItemResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.insertItemValidateBeforeCall(item, expand, placeholders, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ItemResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateItemCall(Item item, Integer merchantItemOid, String expand, Boolean placeholders, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Item localVarPostBody = item;
        String localVarPath = "/item/items/{merchant_item_oid}".replaceAll("\\{merchant_item_oid\\}", this.apiClient.escapeString(merchantItemOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        if (placeholders != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_placeholders", placeholders));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateItemValidateBeforeCall(Item item, Integer merchantItemOid, String expand, Boolean placeholders, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (item == null) {
            throw new ApiException("Missing the required parameter 'item' when calling updateItem(Async)");
        }
        if (merchantItemOid == null) {
            throw new ApiException("Missing the required parameter 'merchantItemOid' when calling updateItem(Async)");
        }
        Call call = this.updateItemCall(item, merchantItemOid, expand, placeholders, progressListener, progressRequestListener);
        return call;
    }

    public ItemResponse updateItem(Item item, Integer merchantItemOid, String expand, Boolean placeholders) throws ApiException {
        ApiResponse<ItemResponse> resp = this.updateItemWithHttpInfo(item, merchantItemOid, expand, placeholders);
        return resp.getData();
    }

    public ApiResponse<ItemResponse> updateItemWithHttpInfo(Item item, Integer merchantItemOid, String expand, Boolean placeholders) throws ApiException {
        Call call = this.updateItemValidateBeforeCall(item, merchantItemOid, expand, placeholders, null, null);
        Type localVarReturnType = new TypeToken<ItemResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateItemAsync(Item item, Integer merchantItemOid, String expand, Boolean placeholders, final ApiCallback<ItemResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateItemValidateBeforeCall(item, merchantItemOid, expand, placeholders, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ItemResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateItemsCall(ItemsRequest itemsRequest, String expand, Boolean placeholders, Boolean async, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ItemsRequest localVarPostBody = itemsRequest;
        String localVarPath = "/item/items/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        if (placeholders != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_placeholders", placeholders));
        }
        if (async != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_async", async));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateItemsValidateBeforeCall(ItemsRequest itemsRequest, String expand, Boolean placeholders, Boolean async, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (itemsRequest == null) {
            throw new ApiException("Missing the required parameter 'itemsRequest' when calling updateItems(Async)");
        }
        Call call = this.updateItemsCall(itemsRequest, expand, placeholders, async, progressListener, progressRequestListener);
        return call;
    }

    public ItemsResponse updateItems(ItemsRequest itemsRequest, String expand, Boolean placeholders, Boolean async) throws ApiException {
        ApiResponse<ItemsResponse> resp = this.updateItemsWithHttpInfo(itemsRequest, expand, placeholders, async);
        return resp.getData();
    }

    public ApiResponse<ItemsResponse> updateItemsWithHttpInfo(ItemsRequest itemsRequest, String expand, Boolean placeholders, Boolean async) throws ApiException {
        Call call = this.updateItemsValidateBeforeCall(itemsRequest, expand, placeholders, async, null, null);
        Type localVarReturnType = new TypeToken<ItemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateItemsAsync(ItemsRequest itemsRequest, String expand, Boolean placeholders, Boolean async, final ApiCallback<ItemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateItemsValidateBeforeCall(itemsRequest, expand, placeholders, async, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ItemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call uploadTemporaryMultimediaCall(File file, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/item/temp_multimedia";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uploadTemporaryMultimediaValidateBeforeCall(File file, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadTemporaryMultimedia(Async)");
        }
        Call call = this.uploadTemporaryMultimediaCall(file, progressListener, progressRequestListener);
        return call;
    }

    public TempMultimediaResponse uploadTemporaryMultimedia(File file) throws ApiException {
        ApiResponse<TempMultimediaResponse> resp = this.uploadTemporaryMultimediaWithHttpInfo(file);
        return resp.getData();
    }

    public ApiResponse<TempMultimediaResponse> uploadTemporaryMultimediaWithHttpInfo(File file) throws ApiException {
        Call call = this.uploadTemporaryMultimediaValidateBeforeCall(file, null, null);
        Type localVarReturnType = new TypeToken<TempMultimediaResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call uploadTemporaryMultimediaAsync(File file, final ApiCallback<TempMultimediaResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uploadTemporaryMultimediaValidateBeforeCall(file, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TempMultimediaResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

