/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.IntegrationLogQueryRequest;
import com.ultracart.admin.v2.models.IntegrationLogQueryResponse;
import com.ultracart.admin.v2.models.IntegrationLogResponse;
import com.ultracart.admin.v2.models.IntegrationLogSummaryQueryRequest;
import com.ultracart.admin.v2.models.IntegrationLogSummaryQueryResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class IntegrationLogApi {
    private ApiClient apiClient;

    public IntegrationLogApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IntegrationLogApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IntegrationLogApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public IntegrationLogApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getIntegrationLogCall(String pk, String sk, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/integration_log/query/{pk}/{sk}".replaceAll("\\{pk\\}", this.apiClient.escapeString(pk.toString())).replaceAll("\\{sk\\}", this.apiClient.escapeString(sk.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getIntegrationLogValidateBeforeCall(String pk, String sk, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (pk == null) {
            throw new ApiException("Missing the required parameter 'pk' when calling getIntegrationLog(Async)");
        }
        if (sk == null) {
            throw new ApiException("Missing the required parameter 'sk' when calling getIntegrationLog(Async)");
        }
        Call call = this.getIntegrationLogCall(pk, sk, progressListener, progressRequestListener);
        return call;
    }

    public IntegrationLogResponse getIntegrationLog(String pk, String sk) throws ApiException {
        ApiResponse<IntegrationLogResponse> resp = this.getIntegrationLogWithHttpInfo(pk, sk);
        return resp.getData();
    }

    public ApiResponse<IntegrationLogResponse> getIntegrationLogWithHttpInfo(String pk, String sk) throws ApiException {
        Call call = this.getIntegrationLogValidateBeforeCall(pk, sk, null, null);
        Type localVarReturnType = new TypeToken<IntegrationLogResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getIntegrationLogAsync(String pk, String sk, final ApiCallback<IntegrationLogResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getIntegrationLogValidateBeforeCall(pk, sk, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IntegrationLogResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getIntegrationLogFileCall(String pk, String sk, String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/integration_log/query/{pk}/{sk}/{uuid}".replaceAll("\\{pk\\}", this.apiClient.escapeString(pk.toString())).replaceAll("\\{sk\\}", this.apiClient.escapeString(sk.toString())).replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getIntegrationLogFileValidateBeforeCall(String pk, String sk, String uuid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (pk == null) {
            throw new ApiException("Missing the required parameter 'pk' when calling getIntegrationLogFile(Async)");
        }
        if (sk == null) {
            throw new ApiException("Missing the required parameter 'sk' when calling getIntegrationLogFile(Async)");
        }
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getIntegrationLogFile(Async)");
        }
        Call call = this.getIntegrationLogFileCall(pk, sk, uuid, progressListener, progressRequestListener);
        return call;
    }

    public File getIntegrationLogFile(String pk, String sk, String uuid) throws ApiException {
        ApiResponse<File> resp = this.getIntegrationLogFileWithHttpInfo(pk, sk, uuid);
        return resp.getData();
    }

    public ApiResponse<File> getIntegrationLogFileWithHttpInfo(String pk, String sk, String uuid) throws ApiException {
        Call call = this.getIntegrationLogFileValidateBeforeCall(pk, sk, uuid, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getIntegrationLogFileAsync(String pk, String sk, String uuid, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getIntegrationLogFileValidateBeforeCall(pk, sk, uuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getIntegrationLogFilePdfCall(String pk, String sk, String uuid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/integration_log/query/{pk}/{sk}/{uuid}/pdf".replaceAll("\\{pk\\}", this.apiClient.escapeString(pk.toString())).replaceAll("\\{sk\\}", this.apiClient.escapeString(sk.toString())).replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getIntegrationLogFilePdfValidateBeforeCall(String pk, String sk, String uuid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (pk == null) {
            throw new ApiException("Missing the required parameter 'pk' when calling getIntegrationLogFilePdf(Async)");
        }
        if (sk == null) {
            throw new ApiException("Missing the required parameter 'sk' when calling getIntegrationLogFilePdf(Async)");
        }
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getIntegrationLogFilePdf(Async)");
        }
        Call call = this.getIntegrationLogFilePdfCall(pk, sk, uuid, progressListener, progressRequestListener);
        return call;
    }

    public File getIntegrationLogFilePdf(String pk, String sk, String uuid) throws ApiException {
        ApiResponse<File> resp = this.getIntegrationLogFilePdfWithHttpInfo(pk, sk, uuid);
        return resp.getData();
    }

    public ApiResponse<File> getIntegrationLogFilePdfWithHttpInfo(String pk, String sk, String uuid) throws ApiException {
        Call call = this.getIntegrationLogFilePdfValidateBeforeCall(pk, sk, uuid, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getIntegrationLogFilePdfAsync(String pk, String sk, String uuid, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getIntegrationLogFilePdfValidateBeforeCall(pk, sk, uuid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getIntegrationLogSummariesQueryCall(IntegrationLogSummaryQueryRequest integrationLogSummariesQuery, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        IntegrationLogSummaryQueryRequest localVarPostBody = integrationLogSummariesQuery;
        String localVarPath = "/integration_log/summary/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getIntegrationLogSummariesQueryValidateBeforeCall(IntegrationLogSummaryQueryRequest integrationLogSummariesQuery, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (integrationLogSummariesQuery == null) {
            throw new ApiException("Missing the required parameter 'integrationLogSummariesQuery' when calling getIntegrationLogSummariesQuery(Async)");
        }
        Call call = this.getIntegrationLogSummariesQueryCall(integrationLogSummariesQuery, progressListener, progressRequestListener);
        return call;
    }

    public IntegrationLogSummaryQueryResponse getIntegrationLogSummariesQuery(IntegrationLogSummaryQueryRequest integrationLogSummariesQuery) throws ApiException {
        ApiResponse<IntegrationLogSummaryQueryResponse> resp = this.getIntegrationLogSummariesQueryWithHttpInfo(integrationLogSummariesQuery);
        return resp.getData();
    }

    public ApiResponse<IntegrationLogSummaryQueryResponse> getIntegrationLogSummariesQueryWithHttpInfo(IntegrationLogSummaryQueryRequest integrationLogSummariesQuery) throws ApiException {
        Call call = this.getIntegrationLogSummariesQueryValidateBeforeCall(integrationLogSummariesQuery, null, null);
        Type localVarReturnType = new TypeToken<IntegrationLogSummaryQueryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getIntegrationLogSummariesQueryAsync(IntegrationLogSummaryQueryRequest integrationLogSummariesQuery, final ApiCallback<IntegrationLogSummaryQueryResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getIntegrationLogSummariesQueryValidateBeforeCall(integrationLogSummariesQuery, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IntegrationLogSummaryQueryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getIntegrationLogsQueryCall(IntegrationLogQueryRequest integrationLogQuery, Integer limit, Integer offset, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        IntegrationLogQueryRequest localVarPostBody = integrationLogQuery;
        String localVarPath = "/integration_log/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getIntegrationLogsQueryValidateBeforeCall(IntegrationLogQueryRequest integrationLogQuery, Integer limit, Integer offset, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (integrationLogQuery == null) {
            throw new ApiException("Missing the required parameter 'integrationLogQuery' when calling getIntegrationLogsQuery(Async)");
        }
        Call call = this.getIntegrationLogsQueryCall(integrationLogQuery, limit, offset, sort, progressListener, progressRequestListener);
        return call;
    }

    public IntegrationLogQueryResponse getIntegrationLogsQuery(IntegrationLogQueryRequest integrationLogQuery, Integer limit, Integer offset, String sort) throws ApiException {
        ApiResponse<IntegrationLogQueryResponse> resp = this.getIntegrationLogsQueryWithHttpInfo(integrationLogQuery, limit, offset, sort);
        return resp.getData();
    }

    public ApiResponse<IntegrationLogQueryResponse> getIntegrationLogsQueryWithHttpInfo(IntegrationLogQueryRequest integrationLogQuery, Integer limit, Integer offset, String sort) throws ApiException {
        Call call = this.getIntegrationLogsQueryValidateBeforeCall(integrationLogQuery, limit, offset, sort, null, null);
        Type localVarReturnType = new TypeToken<IntegrationLogQueryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getIntegrationLogsQueryAsync(IntegrationLogQueryRequest integrationLogQuery, Integer limit, Integer offset, String sort, final ApiCallback<IntegrationLogQueryResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getIntegrationLogsQueryValidateBeforeCall(integrationLogQuery, limit, offset, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IntegrationLogQueryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

