/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.GiftCertificate;
import com.ultracart.admin.v2.models.GiftCertificateCreateRequest;
import com.ultracart.admin.v2.models.GiftCertificateLedgerEntry;
import com.ultracart.admin.v2.models.GiftCertificateQuery;
import com.ultracart.admin.v2.models.GiftCertificateResponse;
import com.ultracart.admin.v2.models.GiftCertificatesResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class GiftCertificateApi {
    private ApiClient apiClient;

    public GiftCertificateApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GiftCertificateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public GiftCertificateApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public GiftCertificateApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addGiftCertificateLedgerEntryCall(Integer giftCertificateOid, GiftCertificateLedgerEntry giftCertificateLedgerEntry, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GiftCertificateLedgerEntry localVarPostBody = giftCertificateLedgerEntry;
        String localVarPath = "/gift_certificate/gift_certificates/{gift_certificate_oid}/ledger_entry".replaceAll("\\{gift_certificate_oid\\}", this.apiClient.escapeString(giftCertificateOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addGiftCertificateLedgerEntryValidateBeforeCall(Integer giftCertificateOid, GiftCertificateLedgerEntry giftCertificateLedgerEntry, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (giftCertificateOid == null) {
            throw new ApiException("Missing the required parameter 'giftCertificateOid' when calling addGiftCertificateLedgerEntry(Async)");
        }
        if (giftCertificateLedgerEntry == null) {
            throw new ApiException("Missing the required parameter 'giftCertificateLedgerEntry' when calling addGiftCertificateLedgerEntry(Async)");
        }
        Call call = this.addGiftCertificateLedgerEntryCall(giftCertificateOid, giftCertificateLedgerEntry, progressListener, progressRequestListener);
        return call;
    }

    public GiftCertificateResponse addGiftCertificateLedgerEntry(Integer giftCertificateOid, GiftCertificateLedgerEntry giftCertificateLedgerEntry) throws ApiException {
        ApiResponse<GiftCertificateResponse> resp = this.addGiftCertificateLedgerEntryWithHttpInfo(giftCertificateOid, giftCertificateLedgerEntry);
        return resp.getData();
    }

    public ApiResponse<GiftCertificateResponse> addGiftCertificateLedgerEntryWithHttpInfo(Integer giftCertificateOid, GiftCertificateLedgerEntry giftCertificateLedgerEntry) throws ApiException {
        Call call = this.addGiftCertificateLedgerEntryValidateBeforeCall(giftCertificateOid, giftCertificateLedgerEntry, null, null);
        Type localVarReturnType = new TypeToken<GiftCertificateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addGiftCertificateLedgerEntryAsync(Integer giftCertificateOid, GiftCertificateLedgerEntry giftCertificateLedgerEntry, final ApiCallback<GiftCertificateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addGiftCertificateLedgerEntryValidateBeforeCall(giftCertificateOid, giftCertificateLedgerEntry, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GiftCertificateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createGiftCertificateCall(GiftCertificateCreateRequest giftCertificateCreateRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GiftCertificateCreateRequest localVarPostBody = giftCertificateCreateRequest;
        String localVarPath = "/gift_certificate/gift_certificates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createGiftCertificateValidateBeforeCall(GiftCertificateCreateRequest giftCertificateCreateRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (giftCertificateCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'giftCertificateCreateRequest' when calling createGiftCertificate(Async)");
        }
        Call call = this.createGiftCertificateCall(giftCertificateCreateRequest, progressListener, progressRequestListener);
        return call;
    }

    public GiftCertificateResponse createGiftCertificate(GiftCertificateCreateRequest giftCertificateCreateRequest) throws ApiException {
        ApiResponse<GiftCertificateResponse> resp = this.createGiftCertificateWithHttpInfo(giftCertificateCreateRequest);
        return resp.getData();
    }

    public ApiResponse<GiftCertificateResponse> createGiftCertificateWithHttpInfo(GiftCertificateCreateRequest giftCertificateCreateRequest) throws ApiException {
        Call call = this.createGiftCertificateValidateBeforeCall(giftCertificateCreateRequest, null, null);
        Type localVarReturnType = new TypeToken<GiftCertificateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createGiftCertificateAsync(GiftCertificateCreateRequest giftCertificateCreateRequest, final ApiCallback<GiftCertificateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createGiftCertificateValidateBeforeCall(giftCertificateCreateRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GiftCertificateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteGiftCertificateCall(Integer giftCertificateOid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/gift_certificate/gift_certificates/{gift_certificate_oid}".replaceAll("\\{gift_certificate_oid\\}", this.apiClient.escapeString(giftCertificateOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteGiftCertificateValidateBeforeCall(Integer giftCertificateOid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (giftCertificateOid == null) {
            throw new ApiException("Missing the required parameter 'giftCertificateOid' when calling deleteGiftCertificate(Async)");
        }
        Call call = this.deleteGiftCertificateCall(giftCertificateOid, progressListener, progressRequestListener);
        return call;
    }

    public void deleteGiftCertificate(Integer giftCertificateOid) throws ApiException {
        this.deleteGiftCertificateWithHttpInfo(giftCertificateOid);
    }

    public ApiResponse<Void> deleteGiftCertificateWithHttpInfo(Integer giftCertificateOid) throws ApiException {
        Call call = this.deleteGiftCertificateValidateBeforeCall(giftCertificateOid, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteGiftCertificateAsync(Integer giftCertificateOid, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteGiftCertificateValidateBeforeCall(giftCertificateOid, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getGiftCertificateByCodeCall(String code, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/gift_certificate/gift_certificates/by_code/{code}".replaceAll("\\{code\\}", this.apiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getGiftCertificateByCodeValidateBeforeCall(String code, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling getGiftCertificateByCode(Async)");
        }
        Call call = this.getGiftCertificateByCodeCall(code, progressListener, progressRequestListener);
        return call;
    }

    public GiftCertificateResponse getGiftCertificateByCode(String code) throws ApiException {
        ApiResponse<GiftCertificateResponse> resp = this.getGiftCertificateByCodeWithHttpInfo(code);
        return resp.getData();
    }

    public ApiResponse<GiftCertificateResponse> getGiftCertificateByCodeWithHttpInfo(String code) throws ApiException {
        Call call = this.getGiftCertificateByCodeValidateBeforeCall(code, null, null);
        Type localVarReturnType = new TypeToken<GiftCertificateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getGiftCertificateByCodeAsync(String code, final ApiCallback<GiftCertificateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getGiftCertificateByCodeValidateBeforeCall(code, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GiftCertificateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getGiftCertificateByOidCall(Integer giftCertificateOid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/gift_certificate/gift_certificates/{gift_certificate_oid}".replaceAll("\\{gift_certificate_oid\\}", this.apiClient.escapeString(giftCertificateOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getGiftCertificateByOidValidateBeforeCall(Integer giftCertificateOid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (giftCertificateOid == null) {
            throw new ApiException("Missing the required parameter 'giftCertificateOid' when calling getGiftCertificateByOid(Async)");
        }
        Call call = this.getGiftCertificateByOidCall(giftCertificateOid, progressListener, progressRequestListener);
        return call;
    }

    public GiftCertificateResponse getGiftCertificateByOid(Integer giftCertificateOid) throws ApiException {
        ApiResponse<GiftCertificateResponse> resp = this.getGiftCertificateByOidWithHttpInfo(giftCertificateOid);
        return resp.getData();
    }

    public ApiResponse<GiftCertificateResponse> getGiftCertificateByOidWithHttpInfo(Integer giftCertificateOid) throws ApiException {
        Call call = this.getGiftCertificateByOidValidateBeforeCall(giftCertificateOid, null, null);
        Type localVarReturnType = new TypeToken<GiftCertificateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getGiftCertificateByOidAsync(Integer giftCertificateOid, final ApiCallback<GiftCertificateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getGiftCertificateByOidValidateBeforeCall(giftCertificateOid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GiftCertificateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getGiftCertificatesByEmailCall(String email, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/gift_certificate/gift_certificates/by_email/{email}".replaceAll("\\{email\\}", this.apiClient.escapeString(email.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getGiftCertificatesByEmailValidateBeforeCall(String email, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (email == null) {
            throw new ApiException("Missing the required parameter 'email' when calling getGiftCertificatesByEmail(Async)");
        }
        Call call = this.getGiftCertificatesByEmailCall(email, progressListener, progressRequestListener);
        return call;
    }

    public GiftCertificatesResponse getGiftCertificatesByEmail(String email) throws ApiException {
        ApiResponse<GiftCertificatesResponse> resp = this.getGiftCertificatesByEmailWithHttpInfo(email);
        return resp.getData();
    }

    public ApiResponse<GiftCertificatesResponse> getGiftCertificatesByEmailWithHttpInfo(String email) throws ApiException {
        Call call = this.getGiftCertificatesByEmailValidateBeforeCall(email, null, null);
        Type localVarReturnType = new TypeToken<GiftCertificatesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getGiftCertificatesByEmailAsync(String email, final ApiCallback<GiftCertificatesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getGiftCertificatesByEmailValidateBeforeCall(email, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GiftCertificatesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getGiftCertificatesByQueryCall(GiftCertificateQuery giftCertificateQuery, Integer limit, Integer offset, String since, String sort, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GiftCertificateQuery localVarPostBody = giftCertificateQuery;
        String localVarPath = "/gift_certificate/gift_certificates/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_since", since));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getGiftCertificatesByQueryValidateBeforeCall(GiftCertificateQuery giftCertificateQuery, Integer limit, Integer offset, String since, String sort, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (giftCertificateQuery == null) {
            throw new ApiException("Missing the required parameter 'giftCertificateQuery' when calling getGiftCertificatesByQuery(Async)");
        }
        Call call = this.getGiftCertificatesByQueryCall(giftCertificateQuery, limit, offset, since, sort, expand, progressListener, progressRequestListener);
        return call;
    }

    public GiftCertificatesResponse getGiftCertificatesByQuery(GiftCertificateQuery giftCertificateQuery, Integer limit, Integer offset, String since, String sort, String expand) throws ApiException {
        ApiResponse<GiftCertificatesResponse> resp = this.getGiftCertificatesByQueryWithHttpInfo(giftCertificateQuery, limit, offset, since, sort, expand);
        return resp.getData();
    }

    public ApiResponse<GiftCertificatesResponse> getGiftCertificatesByQueryWithHttpInfo(GiftCertificateQuery giftCertificateQuery, Integer limit, Integer offset, String since, String sort, String expand) throws ApiException {
        Call call = this.getGiftCertificatesByQueryValidateBeforeCall(giftCertificateQuery, limit, offset, since, sort, expand, null, null);
        Type localVarReturnType = new TypeToken<GiftCertificatesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getGiftCertificatesByQueryAsync(GiftCertificateQuery giftCertificateQuery, Integer limit, Integer offset, String since, String sort, String expand, final ApiCallback<GiftCertificatesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getGiftCertificatesByQueryValidateBeforeCall(giftCertificateQuery, limit, offset, since, sort, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GiftCertificatesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateGiftCertificateCall(Integer giftCertificateOid, GiftCertificate giftCertificate, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GiftCertificate localVarPostBody = giftCertificate;
        String localVarPath = "/gift_certificate/gift_certificates/{gift_certificate_oid}".replaceAll("\\{gift_certificate_oid\\}", this.apiClient.escapeString(giftCertificateOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateGiftCertificateValidateBeforeCall(Integer giftCertificateOid, GiftCertificate giftCertificate, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (giftCertificateOid == null) {
            throw new ApiException("Missing the required parameter 'giftCertificateOid' when calling updateGiftCertificate(Async)");
        }
        if (giftCertificate == null) {
            throw new ApiException("Missing the required parameter 'giftCertificate' when calling updateGiftCertificate(Async)");
        }
        Call call = this.updateGiftCertificateCall(giftCertificateOid, giftCertificate, progressListener, progressRequestListener);
        return call;
    }

    public GiftCertificateResponse updateGiftCertificate(Integer giftCertificateOid, GiftCertificate giftCertificate) throws ApiException {
        ApiResponse<GiftCertificateResponse> resp = this.updateGiftCertificateWithHttpInfo(giftCertificateOid, giftCertificate);
        return resp.getData();
    }

    public ApiResponse<GiftCertificateResponse> updateGiftCertificateWithHttpInfo(Integer giftCertificateOid, GiftCertificate giftCertificate) throws ApiException {
        Call call = this.updateGiftCertificateValidateBeforeCall(giftCertificateOid, giftCertificate, null, null);
        Type localVarReturnType = new TypeToken<GiftCertificateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateGiftCertificateAsync(Integer giftCertificateOid, GiftCertificate giftCertificate, final ApiCallback<GiftCertificateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateGiftCertificateValidateBeforeCall(giftCertificateOid, giftCertificate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GiftCertificateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

