/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.DistributionCentersResponse;
import com.ultracart.admin.v2.models.FulfillmentInventory;
import com.ultracart.admin.v2.models.FulfillmentShipment;
import com.ultracart.admin.v2.models.OrdersResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FulfillmentApi {
    private ApiClient apiClient;

    public FulfillmentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FulfillmentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FulfillmentApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public FulfillmentApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call acknowledgeOrdersCall(String distributionCenterCode, List<String> orderIds, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<String> localVarPostBody = orderIds;
        String localVarPath = "/fulfillment/distribution_centers/{distribution_center_code}/acknowledgements".replaceAll("\\{distribution_center_code\\}", this.apiClient.escapeString(distributionCenterCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call acknowledgeOrdersValidateBeforeCall(String distributionCenterCode, List<String> orderIds, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (distributionCenterCode == null) {
            throw new ApiException("Missing the required parameter 'distributionCenterCode' when calling acknowledgeOrders(Async)");
        }
        if (orderIds == null) {
            throw new ApiException("Missing the required parameter 'orderIds' when calling acknowledgeOrders(Async)");
        }
        Call call = this.acknowledgeOrdersCall(distributionCenterCode, orderIds, progressListener, progressRequestListener);
        return call;
    }

    public void acknowledgeOrders(String distributionCenterCode, List<String> orderIds) throws ApiException {
        this.acknowledgeOrdersWithHttpInfo(distributionCenterCode, orderIds);
    }

    public ApiResponse<Void> acknowledgeOrdersWithHttpInfo(String distributionCenterCode, List<String> orderIds) throws ApiException {
        Call call = this.acknowledgeOrdersValidateBeforeCall(distributionCenterCode, orderIds, null, null);
        return this.apiClient.execute(call);
    }

    public Call acknowledgeOrdersAsync(String distributionCenterCode, List<String> orderIds, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.acknowledgeOrdersValidateBeforeCall(distributionCenterCode, orderIds, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call generatePackingSlipCall(String distributionCenterCode, String orderId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/fulfillment/distribution_centers/{distribution_center_code}/orders/{order_id}".replaceAll("\\{distribution_center_code\\}", this.apiClient.escapeString(distributionCenterCode.toString())).replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generatePackingSlipValidateBeforeCall(String distributionCenterCode, String orderId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (distributionCenterCode == null) {
            throw new ApiException("Missing the required parameter 'distributionCenterCode' when calling generatePackingSlip(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling generatePackingSlip(Async)");
        }
        Call call = this.generatePackingSlipCall(distributionCenterCode, orderId, progressListener, progressRequestListener);
        return call;
    }

    public OrdersResponse generatePackingSlip(String distributionCenterCode, String orderId) throws ApiException {
        ApiResponse<OrdersResponse> resp = this.generatePackingSlipWithHttpInfo(distributionCenterCode, orderId);
        return resp.getData();
    }

    public ApiResponse<OrdersResponse> generatePackingSlipWithHttpInfo(String distributionCenterCode, String orderId) throws ApiException {
        Call call = this.generatePackingSlipValidateBeforeCall(distributionCenterCode, orderId, null, null);
        Type localVarReturnType = new TypeToken<OrdersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generatePackingSlipAsync(String distributionCenterCode, String orderId, final ApiCallback<OrdersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generatePackingSlipValidateBeforeCall(distributionCenterCode, orderId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrdersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDistributionCenterOrdersCall(String distributionCenterCode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/fulfillment/distribution_centers/{distribution_center_code}/orders".replaceAll("\\{distribution_center_code\\}", this.apiClient.escapeString(distributionCenterCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDistributionCenterOrdersValidateBeforeCall(String distributionCenterCode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (distributionCenterCode == null) {
            throw new ApiException("Missing the required parameter 'distributionCenterCode' when calling getDistributionCenterOrders(Async)");
        }
        Call call = this.getDistributionCenterOrdersCall(distributionCenterCode, progressListener, progressRequestListener);
        return call;
    }

    public OrdersResponse getDistributionCenterOrders(String distributionCenterCode) throws ApiException {
        ApiResponse<OrdersResponse> resp = this.getDistributionCenterOrdersWithHttpInfo(distributionCenterCode);
        return resp.getData();
    }

    public ApiResponse<OrdersResponse> getDistributionCenterOrdersWithHttpInfo(String distributionCenterCode) throws ApiException {
        Call call = this.getDistributionCenterOrdersValidateBeforeCall(distributionCenterCode, null, null);
        Type localVarReturnType = new TypeToken<OrdersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDistributionCenterOrdersAsync(String distributionCenterCode, final ApiCallback<OrdersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDistributionCenterOrdersValidateBeforeCall(distributionCenterCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrdersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getDistributionCentersCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/fulfillment/distribution_centers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDistributionCentersValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getDistributionCentersCall(progressListener, progressRequestListener);
        return call;
    }

    public DistributionCentersResponse getDistributionCenters() throws ApiException {
        ApiResponse<DistributionCentersResponse> resp = this.getDistributionCentersWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<DistributionCentersResponse> getDistributionCentersWithHttpInfo() throws ApiException {
        Call call = this.getDistributionCentersValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<DistributionCentersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDistributionCentersAsync(final ApiCallback<DistributionCentersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDistributionCentersValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DistributionCentersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call shipOrdersCall(String distributionCenterCode, List<FulfillmentShipment> shipments, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<FulfillmentShipment> localVarPostBody = shipments;
        String localVarPath = "/fulfillment/distribution_centers/{distribution_center_code}/shipments".replaceAll("\\{distribution_center_code\\}", this.apiClient.escapeString(distributionCenterCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call shipOrdersValidateBeforeCall(String distributionCenterCode, List<FulfillmentShipment> shipments, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (distributionCenterCode == null) {
            throw new ApiException("Missing the required parameter 'distributionCenterCode' when calling shipOrders(Async)");
        }
        if (shipments == null) {
            throw new ApiException("Missing the required parameter 'shipments' when calling shipOrders(Async)");
        }
        Call call = this.shipOrdersCall(distributionCenterCode, shipments, progressListener, progressRequestListener);
        return call;
    }

    public void shipOrders(String distributionCenterCode, List<FulfillmentShipment> shipments) throws ApiException {
        this.shipOrdersWithHttpInfo(distributionCenterCode, shipments);
    }

    public ApiResponse<Void> shipOrdersWithHttpInfo(String distributionCenterCode, List<FulfillmentShipment> shipments) throws ApiException {
        Call call = this.shipOrdersValidateBeforeCall(distributionCenterCode, shipments, null, null);
        return this.apiClient.execute(call);
    }

    public Call shipOrdersAsync(String distributionCenterCode, List<FulfillmentShipment> shipments, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.shipOrdersValidateBeforeCall(distributionCenterCode, shipments, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateInventoryCall(String distributionCenterCode, List<FulfillmentInventory> inventories, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<FulfillmentInventory> localVarPostBody = inventories;
        String localVarPath = "/fulfillment/distribution_centers/{distribution_center_code}/inventory".replaceAll("\\{distribution_center_code\\}", this.apiClient.escapeString(distributionCenterCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateInventoryValidateBeforeCall(String distributionCenterCode, List<FulfillmentInventory> inventories, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (distributionCenterCode == null) {
            throw new ApiException("Missing the required parameter 'distributionCenterCode' when calling updateInventory(Async)");
        }
        if (inventories == null) {
            throw new ApiException("Missing the required parameter 'inventories' when calling updateInventory(Async)");
        }
        Call call = this.updateInventoryCall(distributionCenterCode, inventories, progressListener, progressRequestListener);
        return call;
    }

    public void updateInventory(String distributionCenterCode, List<FulfillmentInventory> inventories) throws ApiException {
        this.updateInventoryWithHttpInfo(distributionCenterCode, inventories);
    }

    public ApiResponse<Void> updateInventoryWithHttpInfo(String distributionCenterCode, List<FulfillmentInventory> inventories) throws ApiException {
        Call call = this.updateInventoryValidateBeforeCall(distributionCenterCode, inventories, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateInventoryAsync(String distributionCenterCode, List<FulfillmentInventory> inventories, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateInventoryValidateBeforeCall(distributionCenterCode, inventories, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

