/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.AdjustInternalCertificateRequest;
import com.ultracart.admin.v2.models.AdjustInternalCertificateResponse;
import com.ultracart.admin.v2.models.BaseResponse;
import com.ultracart.admin.v2.models.Customer;
import com.ultracart.admin.v2.models.CustomerEditorValues;
import com.ultracart.admin.v2.models.CustomerEmailListChanges;
import com.ultracart.admin.v2.models.CustomerQuery;
import com.ultracart.admin.v2.models.CustomerResponse;
import com.ultracart.admin.v2.models.CustomerStoreCreditAddRequest;
import com.ultracart.admin.v2.models.CustomerStoreCreditResponse;
import com.ultracart.admin.v2.models.CustomersResponse;
import com.ultracart.admin.v2.models.DataTablesServerSideResponse;
import com.ultracart.admin.v2.models.EmailListsResponse;
import com.ultracart.admin.v2.models.EmailVerifyTokenRequest;
import com.ultracart.admin.v2.models.EmailVerifyTokenResponse;
import com.ultracart.admin.v2.models.EmailVerifyTokenValidateRequest;
import com.ultracart.admin.v2.models.EmailVerifyTokenValidateResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class CustomerApi {
    private ApiClient apiClient;

    public CustomerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CustomerApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public CustomerApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addCustomerStoreCreditCall(Integer customerProfileOid, CustomerStoreCreditAddRequest storeCreditRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CustomerStoreCreditAddRequest localVarPostBody = storeCreditRequest;
        String localVarPath = "/customer/customers/{customer_profile_oid}/store_credit".replaceAll("\\{customer_profile_oid\\}", this.apiClient.escapeString(customerProfileOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addCustomerStoreCreditValidateBeforeCall(Integer customerProfileOid, CustomerStoreCreditAddRequest storeCreditRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerProfileOid == null) {
            throw new ApiException("Missing the required parameter 'customerProfileOid' when calling addCustomerStoreCredit(Async)");
        }
        if (storeCreditRequest == null) {
            throw new ApiException("Missing the required parameter 'storeCreditRequest' when calling addCustomerStoreCredit(Async)");
        }
        Call call = this.addCustomerStoreCreditCall(customerProfileOid, storeCreditRequest, progressListener, progressRequestListener);
        return call;
    }

    public BaseResponse addCustomerStoreCredit(Integer customerProfileOid, CustomerStoreCreditAddRequest storeCreditRequest) throws ApiException {
        ApiResponse<BaseResponse> resp = this.addCustomerStoreCreditWithHttpInfo(customerProfileOid, storeCreditRequest);
        return resp.getData();
    }

    public ApiResponse<BaseResponse> addCustomerStoreCreditWithHttpInfo(Integer customerProfileOid, CustomerStoreCreditAddRequest storeCreditRequest) throws ApiException {
        Call call = this.addCustomerStoreCreditValidateBeforeCall(customerProfileOid, storeCreditRequest, null, null);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addCustomerStoreCreditAsync(Integer customerProfileOid, CustomerStoreCreditAddRequest storeCreditRequest, final ApiCallback<BaseResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addCustomerStoreCreditValidateBeforeCall(customerProfileOid, storeCreditRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call adjustInternalCertificateCall(Integer customerProfileOid, AdjustInternalCertificateRequest adjustInternalCertificateRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AdjustInternalCertificateRequest localVarPostBody = adjustInternalCertificateRequest;
        String localVarPath = "/customer/customers/{customer_profile_oid}/adjust_cashback_balance".replaceAll("\\{customer_profile_oid\\}", this.apiClient.escapeString(customerProfileOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call adjustInternalCertificateValidateBeforeCall(Integer customerProfileOid, AdjustInternalCertificateRequest adjustInternalCertificateRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerProfileOid == null) {
            throw new ApiException("Missing the required parameter 'customerProfileOid' when calling adjustInternalCertificate(Async)");
        }
        if (adjustInternalCertificateRequest == null) {
            throw new ApiException("Missing the required parameter 'adjustInternalCertificateRequest' when calling adjustInternalCertificate(Async)");
        }
        Call call = this.adjustInternalCertificateCall(customerProfileOid, adjustInternalCertificateRequest, progressListener, progressRequestListener);
        return call;
    }

    public AdjustInternalCertificateResponse adjustInternalCertificate(Integer customerProfileOid, AdjustInternalCertificateRequest adjustInternalCertificateRequest) throws ApiException {
        ApiResponse<AdjustInternalCertificateResponse> resp = this.adjustInternalCertificateWithHttpInfo(customerProfileOid, adjustInternalCertificateRequest);
        return resp.getData();
    }

    public ApiResponse<AdjustInternalCertificateResponse> adjustInternalCertificateWithHttpInfo(Integer customerProfileOid, AdjustInternalCertificateRequest adjustInternalCertificateRequest) throws ApiException {
        Call call = this.adjustInternalCertificateValidateBeforeCall(customerProfileOid, adjustInternalCertificateRequest, null, null);
        Type localVarReturnType = new TypeToken<AdjustInternalCertificateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call adjustInternalCertificateAsync(Integer customerProfileOid, AdjustInternalCertificateRequest adjustInternalCertificateRequest, final ApiCallback<AdjustInternalCertificateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.adjustInternalCertificateValidateBeforeCall(customerProfileOid, adjustInternalCertificateRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AdjustInternalCertificateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteCustomerCall(Integer customerProfileOid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/customer/customers/{customer_profile_oid}".replaceAll("\\{customer_profile_oid\\}", this.apiClient.escapeString(customerProfileOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCustomerValidateBeforeCall(Integer customerProfileOid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerProfileOid == null) {
            throw new ApiException("Missing the required parameter 'customerProfileOid' when calling deleteCustomer(Async)");
        }
        Call call = this.deleteCustomerCall(customerProfileOid, progressListener, progressRequestListener);
        return call;
    }

    public void deleteCustomer(Integer customerProfileOid) throws ApiException {
        this.deleteCustomerWithHttpInfo(customerProfileOid);
    }

    public ApiResponse<Void> deleteCustomerWithHttpInfo(Integer customerProfileOid) throws ApiException {
        Call call = this.deleteCustomerValidateBeforeCall(customerProfileOid, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCustomerAsync(Integer customerProfileOid, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCustomerValidateBeforeCall(customerProfileOid, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getCustomerCall(Integer customerProfileOid, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/customer/customers/{customer_profile_oid}".replaceAll("\\{customer_profile_oid\\}", this.apiClient.escapeString(customerProfileOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerValidateBeforeCall(Integer customerProfileOid, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerProfileOid == null) {
            throw new ApiException("Missing the required parameter 'customerProfileOid' when calling getCustomer(Async)");
        }
        Call call = this.getCustomerCall(customerProfileOid, expand, progressListener, progressRequestListener);
        return call;
    }

    public CustomerResponse getCustomer(Integer customerProfileOid, String expand) throws ApiException {
        ApiResponse<CustomerResponse> resp = this.getCustomerWithHttpInfo(customerProfileOid, expand);
        return resp.getData();
    }

    public ApiResponse<CustomerResponse> getCustomerWithHttpInfo(Integer customerProfileOid, String expand) throws ApiException {
        Call call = this.getCustomerValidateBeforeCall(customerProfileOid, expand, null, null);
        Type localVarReturnType = new TypeToken<CustomerResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerAsync(Integer customerProfileOid, String expand, final ApiCallback<CustomerResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerValidateBeforeCall(customerProfileOid, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomerResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCustomerByEmailCall(String email, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/customer/customers/by_email/{email}".replaceAll("\\{email\\}", this.apiClient.escapeString(email.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerByEmailValidateBeforeCall(String email, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (email == null) {
            throw new ApiException("Missing the required parameter 'email' when calling getCustomerByEmail(Async)");
        }
        Call call = this.getCustomerByEmailCall(email, expand, progressListener, progressRequestListener);
        return call;
    }

    public CustomerResponse getCustomerByEmail(String email, String expand) throws ApiException {
        ApiResponse<CustomerResponse> resp = this.getCustomerByEmailWithHttpInfo(email, expand);
        return resp.getData();
    }

    public ApiResponse<CustomerResponse> getCustomerByEmailWithHttpInfo(String email, String expand) throws ApiException {
        Call call = this.getCustomerByEmailValidateBeforeCall(email, expand, null, null);
        Type localVarReturnType = new TypeToken<CustomerResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerByEmailAsync(String email, String expand, final ApiCallback<CustomerResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerByEmailValidateBeforeCall(email, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomerResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCustomerEditorValuesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/customer/editor_values";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerEditorValuesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getCustomerEditorValuesCall(progressListener, progressRequestListener);
        return call;
    }

    public CustomerEditorValues getCustomerEditorValues() throws ApiException {
        ApiResponse<CustomerEditorValues> resp = this.getCustomerEditorValuesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<CustomerEditorValues> getCustomerEditorValuesWithHttpInfo() throws ApiException {
        Call call = this.getCustomerEditorValuesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<CustomerEditorValues>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerEditorValuesAsync(final ApiCallback<CustomerEditorValues> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerEditorValuesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomerEditorValues>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCustomerEmailListsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/customer/email_lists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerEmailListsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getCustomerEmailListsCall(progressListener, progressRequestListener);
        return call;
    }

    public EmailListsResponse getCustomerEmailLists() throws ApiException {
        ApiResponse<EmailListsResponse> resp = this.getCustomerEmailListsWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<EmailListsResponse> getCustomerEmailListsWithHttpInfo() throws ApiException {
        Call call = this.getCustomerEmailListsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<EmailListsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerEmailListsAsync(final ApiCallback<EmailListsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerEmailListsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EmailListsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCustomerStoreCreditCall(Integer customerProfileOid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/customer/customers/{customer_profile_oid}/store_credit".replaceAll("\\{customer_profile_oid\\}", this.apiClient.escapeString(customerProfileOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerStoreCreditValidateBeforeCall(Integer customerProfileOid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerProfileOid == null) {
            throw new ApiException("Missing the required parameter 'customerProfileOid' when calling getCustomerStoreCredit(Async)");
        }
        Call call = this.getCustomerStoreCreditCall(customerProfileOid, progressListener, progressRequestListener);
        return call;
    }

    public CustomerStoreCreditResponse getCustomerStoreCredit(Integer customerProfileOid) throws ApiException {
        ApiResponse<CustomerStoreCreditResponse> resp = this.getCustomerStoreCreditWithHttpInfo(customerProfileOid);
        return resp.getData();
    }

    public ApiResponse<CustomerStoreCreditResponse> getCustomerStoreCreditWithHttpInfo(Integer customerProfileOid) throws ApiException {
        Call call = this.getCustomerStoreCreditValidateBeforeCall(customerProfileOid, null, null);
        Type localVarReturnType = new TypeToken<CustomerStoreCreditResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerStoreCreditAsync(Integer customerProfileOid, final ApiCallback<CustomerStoreCreditResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerStoreCreditValidateBeforeCall(customerProfileOid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomerStoreCreditResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCustomersCall(String email, String qbClass, String quickbooksCode, String lastModifiedDtsStart, String lastModifiedDtsEnd, String signupDtsStart, String signupDtsEnd, String billingFirstName, String billingLastName, String billingCompany, String billingCity, String billingState, String billingPostalCode, String billingCountryCode, String billingDayPhone, String billingEveningPhone, String shippingFirstName, String shippingLastName, String shippingCompany, String shippingCity, String shippingState, String shippingPostalCode, String shippingCountryCode, String shippingDayPhone, String shippingEveningPhone, Integer pricingTierOid, String pricingTierName, Integer limit, Integer offset, String since, String sort, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/customer/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (email != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", email));
        }
        if (qbClass != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("qb_class", qbClass));
        }
        if (quickbooksCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("quickbooks_code", quickbooksCode));
        }
        if (lastModifiedDtsStart != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("last_modified_dts_start", lastModifiedDtsStart));
        }
        if (lastModifiedDtsEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("last_modified_dts_end", lastModifiedDtsEnd));
        }
        if (signupDtsStart != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("signup_dts_start", signupDtsStart));
        }
        if (signupDtsEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("signup_dts_end", signupDtsEnd));
        }
        if (billingFirstName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("billing_first_name", billingFirstName));
        }
        if (billingLastName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("billing_last_name", billingLastName));
        }
        if (billingCompany != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("billing_company", billingCompany));
        }
        if (billingCity != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("billing_city", billingCity));
        }
        if (billingState != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("billing_state", billingState));
        }
        if (billingPostalCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("billing_postal_code", billingPostalCode));
        }
        if (billingCountryCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("billing_country_code", billingCountryCode));
        }
        if (billingDayPhone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("billing_day_phone", billingDayPhone));
        }
        if (billingEveningPhone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("billing_evening_phone", billingEveningPhone));
        }
        if (shippingFirstName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipping_first_name", shippingFirstName));
        }
        if (shippingLastName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipping_last_name", shippingLastName));
        }
        if (shippingCompany != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipping_company", shippingCompany));
        }
        if (shippingCity != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipping_city", shippingCity));
        }
        if (shippingState != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipping_state", shippingState));
        }
        if (shippingPostalCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipping_postal_code", shippingPostalCode));
        }
        if (shippingCountryCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipping_country_code", shippingCountryCode));
        }
        if (shippingDayPhone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipping_day_phone", shippingDayPhone));
        }
        if (shippingEveningPhone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipping_evening_phone", shippingEveningPhone));
        }
        if (pricingTierOid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pricing_tier_oid", pricingTierOid));
        }
        if (pricingTierName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pricing_tier_name", pricingTierName));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_since", since));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomersValidateBeforeCall(String email, String qbClass, String quickbooksCode, String lastModifiedDtsStart, String lastModifiedDtsEnd, String signupDtsStart, String signupDtsEnd, String billingFirstName, String billingLastName, String billingCompany, String billingCity, String billingState, String billingPostalCode, String billingCountryCode, String billingDayPhone, String billingEveningPhone, String shippingFirstName, String shippingLastName, String shippingCompany, String shippingCity, String shippingState, String shippingPostalCode, String shippingCountryCode, String shippingDayPhone, String shippingEveningPhone, Integer pricingTierOid, String pricingTierName, Integer limit, Integer offset, String since, String sort, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getCustomersCall(email, qbClass, quickbooksCode, lastModifiedDtsStart, lastModifiedDtsEnd, signupDtsStart, signupDtsEnd, billingFirstName, billingLastName, billingCompany, billingCity, billingState, billingPostalCode, billingCountryCode, billingDayPhone, billingEveningPhone, shippingFirstName, shippingLastName, shippingCompany, shippingCity, shippingState, shippingPostalCode, shippingCountryCode, shippingDayPhone, shippingEveningPhone, pricingTierOid, pricingTierName, limit, offset, since, sort, expand, progressListener, progressRequestListener);
        return call;
    }

    public CustomersResponse getCustomers(String email, String qbClass, String quickbooksCode, String lastModifiedDtsStart, String lastModifiedDtsEnd, String signupDtsStart, String signupDtsEnd, String billingFirstName, String billingLastName, String billingCompany, String billingCity, String billingState, String billingPostalCode, String billingCountryCode, String billingDayPhone, String billingEveningPhone, String shippingFirstName, String shippingLastName, String shippingCompany, String shippingCity, String shippingState, String shippingPostalCode, String shippingCountryCode, String shippingDayPhone, String shippingEveningPhone, Integer pricingTierOid, String pricingTierName, Integer limit, Integer offset, String since, String sort, String expand) throws ApiException {
        ApiResponse<CustomersResponse> resp = this.getCustomersWithHttpInfo(email, qbClass, quickbooksCode, lastModifiedDtsStart, lastModifiedDtsEnd, signupDtsStart, signupDtsEnd, billingFirstName, billingLastName, billingCompany, billingCity, billingState, billingPostalCode, billingCountryCode, billingDayPhone, billingEveningPhone, shippingFirstName, shippingLastName, shippingCompany, shippingCity, shippingState, shippingPostalCode, shippingCountryCode, shippingDayPhone, shippingEveningPhone, pricingTierOid, pricingTierName, limit, offset, since, sort, expand);
        return resp.getData();
    }

    public ApiResponse<CustomersResponse> getCustomersWithHttpInfo(String email, String qbClass, String quickbooksCode, String lastModifiedDtsStart, String lastModifiedDtsEnd, String signupDtsStart, String signupDtsEnd, String billingFirstName, String billingLastName, String billingCompany, String billingCity, String billingState, String billingPostalCode, String billingCountryCode, String billingDayPhone, String billingEveningPhone, String shippingFirstName, String shippingLastName, String shippingCompany, String shippingCity, String shippingState, String shippingPostalCode, String shippingCountryCode, String shippingDayPhone, String shippingEveningPhone, Integer pricingTierOid, String pricingTierName, Integer limit, Integer offset, String since, String sort, String expand) throws ApiException {
        Call call = this.getCustomersValidateBeforeCall(email, qbClass, quickbooksCode, lastModifiedDtsStart, lastModifiedDtsEnd, signupDtsStart, signupDtsEnd, billingFirstName, billingLastName, billingCompany, billingCity, billingState, billingPostalCode, billingCountryCode, billingDayPhone, billingEveningPhone, shippingFirstName, shippingLastName, shippingCompany, shippingCity, shippingState, shippingPostalCode, shippingCountryCode, shippingDayPhone, shippingEveningPhone, pricingTierOid, pricingTierName, limit, offset, since, sort, expand, null, null);
        Type localVarReturnType = new TypeToken<CustomersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomersAsync(String email, String qbClass, String quickbooksCode, String lastModifiedDtsStart, String lastModifiedDtsEnd, String signupDtsStart, String signupDtsEnd, String billingFirstName, String billingLastName, String billingCompany, String billingCity, String billingState, String billingPostalCode, String billingCountryCode, String billingDayPhone, String billingEveningPhone, String shippingFirstName, String shippingLastName, String shippingCompany, String shippingCity, String shippingState, String shippingPostalCode, String shippingCountryCode, String shippingDayPhone, String shippingEveningPhone, Integer pricingTierOid, String pricingTierName, Integer limit, Integer offset, String since, String sort, String expand, final ApiCallback<CustomersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomersValidateBeforeCall(email, qbClass, quickbooksCode, lastModifiedDtsStart, lastModifiedDtsEnd, signupDtsStart, signupDtsEnd, billingFirstName, billingLastName, billingCompany, billingCity, billingState, billingPostalCode, billingCountryCode, billingDayPhone, billingEveningPhone, shippingFirstName, shippingLastName, shippingCompany, shippingCity, shippingState, shippingPostalCode, shippingCountryCode, shippingDayPhone, shippingEveningPhone, pricingTierOid, pricingTierName, limit, offset, since, sort, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCustomersByQueryCall(CustomerQuery customerQuery, Integer limit, Integer offset, String since, String sort, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CustomerQuery localVarPostBody = customerQuery;
        String localVarPath = "/customer/customers/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_since", since));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomersByQueryValidateBeforeCall(CustomerQuery customerQuery, Integer limit, Integer offset, String since, String sort, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerQuery == null) {
            throw new ApiException("Missing the required parameter 'customerQuery' when calling getCustomersByQuery(Async)");
        }
        Call call = this.getCustomersByQueryCall(customerQuery, limit, offset, since, sort, expand, progressListener, progressRequestListener);
        return call;
    }

    public CustomersResponse getCustomersByQuery(CustomerQuery customerQuery, Integer limit, Integer offset, String since, String sort, String expand) throws ApiException {
        ApiResponse<CustomersResponse> resp = this.getCustomersByQueryWithHttpInfo(customerQuery, limit, offset, since, sort, expand);
        return resp.getData();
    }

    public ApiResponse<CustomersResponse> getCustomersByQueryWithHttpInfo(CustomerQuery customerQuery, Integer limit, Integer offset, String since, String sort, String expand) throws ApiException {
        Call call = this.getCustomersByQueryValidateBeforeCall(customerQuery, limit, offset, since, sort, expand, null, null);
        Type localVarReturnType = new TypeToken<CustomersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomersByQueryAsync(CustomerQuery customerQuery, Integer limit, Integer offset, String since, String sort, String expand, final ApiCallback<CustomersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomersByQueryValidateBeforeCall(customerQuery, limit, offset, since, sort, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCustomersForDataTablesCall(String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/customer/customers/dataTables";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomersForDataTablesValidateBeforeCall(String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getCustomersForDataTablesCall(expand, progressListener, progressRequestListener);
        return call;
    }

    public DataTablesServerSideResponse getCustomersForDataTables(String expand) throws ApiException {
        ApiResponse<DataTablesServerSideResponse> resp = this.getCustomersForDataTablesWithHttpInfo(expand);
        return resp.getData();
    }

    public ApiResponse<DataTablesServerSideResponse> getCustomersForDataTablesWithHttpInfo(String expand) throws ApiException {
        Call call = this.getCustomersForDataTablesValidateBeforeCall(expand, null, null);
        Type localVarReturnType = new TypeToken<DataTablesServerSideResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomersForDataTablesAsync(String expand, final ApiCallback<DataTablesServerSideResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomersForDataTablesValidateBeforeCall(expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DataTablesServerSideResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getEmailVerificationTokenCall(EmailVerifyTokenRequest tokenRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EmailVerifyTokenRequest localVarPostBody = tokenRequest;
        String localVarPath = "/customer/customers/email_verify/get_token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getEmailVerificationTokenValidateBeforeCall(EmailVerifyTokenRequest tokenRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tokenRequest == null) {
            throw new ApiException("Missing the required parameter 'tokenRequest' when calling getEmailVerificationToken(Async)");
        }
        Call call = this.getEmailVerificationTokenCall(tokenRequest, progressListener, progressRequestListener);
        return call;
    }

    public EmailVerifyTokenResponse getEmailVerificationToken(EmailVerifyTokenRequest tokenRequest) throws ApiException {
        ApiResponse<EmailVerifyTokenResponse> resp = this.getEmailVerificationTokenWithHttpInfo(tokenRequest);
        return resp.getData();
    }

    public ApiResponse<EmailVerifyTokenResponse> getEmailVerificationTokenWithHttpInfo(EmailVerifyTokenRequest tokenRequest) throws ApiException {
        Call call = this.getEmailVerificationTokenValidateBeforeCall(tokenRequest, null, null);
        Type localVarReturnType = new TypeToken<EmailVerifyTokenResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getEmailVerificationTokenAsync(EmailVerifyTokenRequest tokenRequest, final ApiCallback<EmailVerifyTokenResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getEmailVerificationTokenValidateBeforeCall(tokenRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EmailVerifyTokenResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call insertCustomerCall(Customer customer, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Customer localVarPostBody = customer;
        String localVarPath = "/customer/customers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call insertCustomerValidateBeforeCall(Customer customer, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customer == null) {
            throw new ApiException("Missing the required parameter 'customer' when calling insertCustomer(Async)");
        }
        Call call = this.insertCustomerCall(customer, expand, progressListener, progressRequestListener);
        return call;
    }

    public CustomerResponse insertCustomer(Customer customer, String expand) throws ApiException {
        ApiResponse<CustomerResponse> resp = this.insertCustomerWithHttpInfo(customer, expand);
        return resp.getData();
    }

    public ApiResponse<CustomerResponse> insertCustomerWithHttpInfo(Customer customer, String expand) throws ApiException {
        Call call = this.insertCustomerValidateBeforeCall(customer, expand, null, null);
        Type localVarReturnType = new TypeToken<CustomerResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call insertCustomerAsync(Customer customer, String expand, final ApiCallback<CustomerResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.insertCustomerValidateBeforeCall(customer, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomerResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateCustomerCall(Customer customer, Integer customerProfileOid, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Customer localVarPostBody = customer;
        String localVarPath = "/customer/customers/{customer_profile_oid}".replaceAll("\\{customer_profile_oid\\}", this.apiClient.escapeString(customerProfileOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateCustomerValidateBeforeCall(Customer customer, Integer customerProfileOid, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customer == null) {
            throw new ApiException("Missing the required parameter 'customer' when calling updateCustomer(Async)");
        }
        if (customerProfileOid == null) {
            throw new ApiException("Missing the required parameter 'customerProfileOid' when calling updateCustomer(Async)");
        }
        Call call = this.updateCustomerCall(customer, customerProfileOid, expand, progressListener, progressRequestListener);
        return call;
    }

    public CustomerResponse updateCustomer(Customer customer, Integer customerProfileOid, String expand) throws ApiException {
        ApiResponse<CustomerResponse> resp = this.updateCustomerWithHttpInfo(customer, customerProfileOid, expand);
        return resp.getData();
    }

    public ApiResponse<CustomerResponse> updateCustomerWithHttpInfo(Customer customer, Integer customerProfileOid, String expand) throws ApiException {
        Call call = this.updateCustomerValidateBeforeCall(customer, customerProfileOid, expand, null, null);
        Type localVarReturnType = new TypeToken<CustomerResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateCustomerAsync(Customer customer, Integer customerProfileOid, String expand, final ApiCallback<CustomerResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateCustomerValidateBeforeCall(customer, customerProfileOid, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomerResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateCustomerEmailListsCall(Integer customerProfileOid, CustomerEmailListChanges listChanges, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CustomerEmailListChanges localVarPostBody = listChanges;
        String localVarPath = "/customer/customers/{customer_profile_oid}/email_lists".replaceAll("\\{customer_profile_oid\\}", this.apiClient.escapeString(customerProfileOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateCustomerEmailListsValidateBeforeCall(Integer customerProfileOid, CustomerEmailListChanges listChanges, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerProfileOid == null) {
            throw new ApiException("Missing the required parameter 'customerProfileOid' when calling updateCustomerEmailLists(Async)");
        }
        if (listChanges == null) {
            throw new ApiException("Missing the required parameter 'listChanges' when calling updateCustomerEmailLists(Async)");
        }
        Call call = this.updateCustomerEmailListsCall(customerProfileOid, listChanges, progressListener, progressRequestListener);
        return call;
    }

    public CustomerEmailListChanges updateCustomerEmailLists(Integer customerProfileOid, CustomerEmailListChanges listChanges) throws ApiException {
        ApiResponse<CustomerEmailListChanges> resp = this.updateCustomerEmailListsWithHttpInfo(customerProfileOid, listChanges);
        return resp.getData();
    }

    public ApiResponse<CustomerEmailListChanges> updateCustomerEmailListsWithHttpInfo(Integer customerProfileOid, CustomerEmailListChanges listChanges) throws ApiException {
        Call call = this.updateCustomerEmailListsValidateBeforeCall(customerProfileOid, listChanges, null, null);
        Type localVarReturnType = new TypeToken<CustomerEmailListChanges>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateCustomerEmailListsAsync(Integer customerProfileOid, CustomerEmailListChanges listChanges, final ApiCallback<CustomerEmailListChanges> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateCustomerEmailListsValidateBeforeCall(customerProfileOid, listChanges, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomerEmailListChanges>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call validateEmailVerificationTokenCall(EmailVerifyTokenValidateRequest validationRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EmailVerifyTokenValidateRequest localVarPostBody = validationRequest;
        String localVarPath = "/customer/customers/email_verify/validate_token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call validateEmailVerificationTokenValidateBeforeCall(EmailVerifyTokenValidateRequest validationRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (validationRequest == null) {
            throw new ApiException("Missing the required parameter 'validationRequest' when calling validateEmailVerificationToken(Async)");
        }
        Call call = this.validateEmailVerificationTokenCall(validationRequest, progressListener, progressRequestListener);
        return call;
    }

    public EmailVerifyTokenValidateResponse validateEmailVerificationToken(EmailVerifyTokenValidateRequest validationRequest) throws ApiException {
        ApiResponse<EmailVerifyTokenValidateResponse> resp = this.validateEmailVerificationTokenWithHttpInfo(validationRequest);
        return resp.getData();
    }

    public ApiResponse<EmailVerifyTokenValidateResponse> validateEmailVerificationTokenWithHttpInfo(EmailVerifyTokenValidateRequest validationRequest) throws ApiException {
        Call call = this.validateEmailVerificationTokenValidateBeforeCall(validationRequest, null, null);
        Type localVarReturnType = new TypeToken<EmailVerifyTokenValidateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call validateEmailVerificationTokenAsync(EmailVerifyTokenValidateRequest validationRequest, final ApiCallback<EmailVerifyTokenValidateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.validateEmailVerificationTokenValidateBeforeCall(validationRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EmailVerifyTokenValidateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

