/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.Coupon;
import com.ultracart.admin.v2.models.CouponAutoApplyConditions;
import com.ultracart.admin.v2.models.CouponCodesRequest;
import com.ultracart.admin.v2.models.CouponCodesResponse;
import com.ultracart.admin.v2.models.CouponDeletesRequest;
import com.ultracart.admin.v2.models.CouponEditorValues;
import com.ultracart.admin.v2.models.CouponExistsResponse;
import com.ultracart.admin.v2.models.CouponItemSearchResultsResponse;
import com.ultracart.admin.v2.models.CouponQuery;
import com.ultracart.admin.v2.models.CouponResponse;
import com.ultracart.admin.v2.models.CouponsRequest;
import com.ultracart.admin.v2.models.CouponsResponse;
import com.ultracart.admin.v2.models.UploadCouponCodesRequest;
import com.ultracart.admin.v2.models.UploadCouponCodesResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class CouponApi {
    private ApiClient apiClient;

    public CouponApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CouponApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CouponApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public CouponApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteCouponCall(Integer couponOid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/coupon/coupons/{coupon_oid}".replaceAll("\\{coupon_oid\\}", this.apiClient.escapeString(couponOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCouponValidateBeforeCall(Integer couponOid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (couponOid == null) {
            throw new ApiException("Missing the required parameter 'couponOid' when calling deleteCoupon(Async)");
        }
        Call call = this.deleteCouponCall(couponOid, progressListener, progressRequestListener);
        return call;
    }

    public void deleteCoupon(Integer couponOid) throws ApiException {
        this.deleteCouponWithHttpInfo(couponOid);
    }

    public ApiResponse<Void> deleteCouponWithHttpInfo(Integer couponOid) throws ApiException {
        Call call = this.deleteCouponValidateBeforeCall(couponOid, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCouponAsync(Integer couponOid, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCouponValidateBeforeCall(couponOid, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteCouponsByCodeCall(CouponDeletesRequest couponDeleteRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CouponDeletesRequest localVarPostBody = couponDeleteRequest;
        String localVarPath = "/coupon/coupons/by_code";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCouponsByCodeValidateBeforeCall(CouponDeletesRequest couponDeleteRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (couponDeleteRequest == null) {
            throw new ApiException("Missing the required parameter 'couponDeleteRequest' when calling deleteCouponsByCode(Async)");
        }
        Call call = this.deleteCouponsByCodeCall(couponDeleteRequest, progressListener, progressRequestListener);
        return call;
    }

    public void deleteCouponsByCode(CouponDeletesRequest couponDeleteRequest) throws ApiException {
        this.deleteCouponsByCodeWithHttpInfo(couponDeleteRequest);
    }

    public ApiResponse<Void> deleteCouponsByCodeWithHttpInfo(CouponDeletesRequest couponDeleteRequest) throws ApiException {
        Call call = this.deleteCouponsByCodeValidateBeforeCall(couponDeleteRequest, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCouponsByCodeAsync(CouponDeletesRequest couponDeleteRequest, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCouponsByCodeValidateBeforeCall(couponDeleteRequest, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteCouponsByOidCall(CouponDeletesRequest couponDeleteRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CouponDeletesRequest localVarPostBody = couponDeleteRequest;
        String localVarPath = "/coupon/coupons/by_oid";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCouponsByOidValidateBeforeCall(CouponDeletesRequest couponDeleteRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (couponDeleteRequest == null) {
            throw new ApiException("Missing the required parameter 'couponDeleteRequest' when calling deleteCouponsByOid(Async)");
        }
        Call call = this.deleteCouponsByOidCall(couponDeleteRequest, progressListener, progressRequestListener);
        return call;
    }

    public void deleteCouponsByOid(CouponDeletesRequest couponDeleteRequest) throws ApiException {
        this.deleteCouponsByOidWithHttpInfo(couponDeleteRequest);
    }

    public ApiResponse<Void> deleteCouponsByOidWithHttpInfo(CouponDeletesRequest couponDeleteRequest) throws ApiException {
        Call call = this.deleteCouponsByOidValidateBeforeCall(couponDeleteRequest, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCouponsByOidAsync(CouponDeletesRequest couponDeleteRequest, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCouponsByOidValidateBeforeCall(couponDeleteRequest, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call doesCouponCodeExistCall(String merchantCode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/coupon/coupons/merchant_code/{merchant_code}/exists".replaceAll("\\{merchant_code\\}", this.apiClient.escapeString(merchantCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call doesCouponCodeExistValidateBeforeCall(String merchantCode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (merchantCode == null) {
            throw new ApiException("Missing the required parameter 'merchantCode' when calling doesCouponCodeExist(Async)");
        }
        Call call = this.doesCouponCodeExistCall(merchantCode, progressListener, progressRequestListener);
        return call;
    }

    public CouponExistsResponse doesCouponCodeExist(String merchantCode) throws ApiException {
        ApiResponse<CouponExistsResponse> resp = this.doesCouponCodeExistWithHttpInfo(merchantCode);
        return resp.getData();
    }

    public ApiResponse<CouponExistsResponse> doesCouponCodeExistWithHttpInfo(String merchantCode) throws ApiException {
        Call call = this.doesCouponCodeExistValidateBeforeCall(merchantCode, null, null);
        Type localVarReturnType = new TypeToken<CouponExistsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call doesCouponCodeExistAsync(String merchantCode, final ApiCallback<CouponExistsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.doesCouponCodeExistValidateBeforeCall(merchantCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponExistsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generateCouponCodesCall(Integer couponOid, CouponCodesRequest couponCodesRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CouponCodesRequest localVarPostBody = couponCodesRequest;
        String localVarPath = "/coupon/coupons/{coupon_oid}/generate_codes".replaceAll("\\{coupon_oid\\}", this.apiClient.escapeString(couponOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateCouponCodesValidateBeforeCall(Integer couponOid, CouponCodesRequest couponCodesRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (couponOid == null) {
            throw new ApiException("Missing the required parameter 'couponOid' when calling generateCouponCodes(Async)");
        }
        if (couponCodesRequest == null) {
            throw new ApiException("Missing the required parameter 'couponCodesRequest' when calling generateCouponCodes(Async)");
        }
        Call call = this.generateCouponCodesCall(couponOid, couponCodesRequest, progressListener, progressRequestListener);
        return call;
    }

    public CouponCodesResponse generateCouponCodes(Integer couponOid, CouponCodesRequest couponCodesRequest) throws ApiException {
        ApiResponse<CouponCodesResponse> resp = this.generateCouponCodesWithHttpInfo(couponOid, couponCodesRequest);
        return resp.getData();
    }

    public ApiResponse<CouponCodesResponse> generateCouponCodesWithHttpInfo(Integer couponOid, CouponCodesRequest couponCodesRequest) throws ApiException {
        Call call = this.generateCouponCodesValidateBeforeCall(couponOid, couponCodesRequest, null, null);
        Type localVarReturnType = new TypeToken<CouponCodesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generateCouponCodesAsync(Integer couponOid, CouponCodesRequest couponCodesRequest, final ApiCallback<CouponCodesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generateCouponCodesValidateBeforeCall(couponOid, couponCodesRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponCodesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call generateOneTimeCodesByMerchantCodeCall(String merchantCode, CouponCodesRequest couponCodesRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CouponCodesRequest localVarPostBody = couponCodesRequest;
        String localVarPath = "/coupon/coupons/merchant_code/{merchant_code}/generate_codes".replaceAll("\\{merchant_code\\}", this.apiClient.escapeString(merchantCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateOneTimeCodesByMerchantCodeValidateBeforeCall(String merchantCode, CouponCodesRequest couponCodesRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (merchantCode == null) {
            throw new ApiException("Missing the required parameter 'merchantCode' when calling generateOneTimeCodesByMerchantCode(Async)");
        }
        if (couponCodesRequest == null) {
            throw new ApiException("Missing the required parameter 'couponCodesRequest' when calling generateOneTimeCodesByMerchantCode(Async)");
        }
        Call call = this.generateOneTimeCodesByMerchantCodeCall(merchantCode, couponCodesRequest, progressListener, progressRequestListener);
        return call;
    }

    public CouponCodesResponse generateOneTimeCodesByMerchantCode(String merchantCode, CouponCodesRequest couponCodesRequest) throws ApiException {
        ApiResponse<CouponCodesResponse> resp = this.generateOneTimeCodesByMerchantCodeWithHttpInfo(merchantCode, couponCodesRequest);
        return resp.getData();
    }

    public ApiResponse<CouponCodesResponse> generateOneTimeCodesByMerchantCodeWithHttpInfo(String merchantCode, CouponCodesRequest couponCodesRequest) throws ApiException {
        Call call = this.generateOneTimeCodesByMerchantCodeValidateBeforeCall(merchantCode, couponCodesRequest, null, null);
        Type localVarReturnType = new TypeToken<CouponCodesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generateOneTimeCodesByMerchantCodeAsync(String merchantCode, CouponCodesRequest couponCodesRequest, final ApiCallback<CouponCodesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generateOneTimeCodesByMerchantCodeValidateBeforeCall(merchantCode, couponCodesRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponCodesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAutoApplyCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/coupon/auto_apply";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAutoApplyValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAutoApplyCall(progressListener, progressRequestListener);
        return call;
    }

    public CouponAutoApplyConditions getAutoApply() throws ApiException {
        ApiResponse<CouponAutoApplyConditions> resp = this.getAutoApplyWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<CouponAutoApplyConditions> getAutoApplyWithHttpInfo() throws ApiException {
        Call call = this.getAutoApplyValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<CouponAutoApplyConditions>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAutoApplyAsync(final ApiCallback<CouponAutoApplyConditions> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAutoApplyValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponAutoApplyConditions>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCouponCall(Integer couponOid, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/coupon/coupons/{coupon_oid}".replaceAll("\\{coupon_oid\\}", this.apiClient.escapeString(couponOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCouponValidateBeforeCall(Integer couponOid, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (couponOid == null) {
            throw new ApiException("Missing the required parameter 'couponOid' when calling getCoupon(Async)");
        }
        Call call = this.getCouponCall(couponOid, expand, progressListener, progressRequestListener);
        return call;
    }

    public CouponResponse getCoupon(Integer couponOid, String expand) throws ApiException {
        ApiResponse<CouponResponse> resp = this.getCouponWithHttpInfo(couponOid, expand);
        return resp.getData();
    }

    public ApiResponse<CouponResponse> getCouponWithHttpInfo(Integer couponOid, String expand) throws ApiException {
        Call call = this.getCouponValidateBeforeCall(couponOid, expand, null, null);
        Type localVarReturnType = new TypeToken<CouponResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCouponAsync(Integer couponOid, String expand, final ApiCallback<CouponResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCouponValidateBeforeCall(couponOid, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCouponByMerchantCodeCall(String merchantCode, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/coupon/coupons/merchant_code/{merchant_code}".replaceAll("\\{merchant_code\\}", this.apiClient.escapeString(merchantCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCouponByMerchantCodeValidateBeforeCall(String merchantCode, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (merchantCode == null) {
            throw new ApiException("Missing the required parameter 'merchantCode' when calling getCouponByMerchantCode(Async)");
        }
        Call call = this.getCouponByMerchantCodeCall(merchantCode, expand, progressListener, progressRequestListener);
        return call;
    }

    public CouponResponse getCouponByMerchantCode(String merchantCode, String expand) throws ApiException {
        ApiResponse<CouponResponse> resp = this.getCouponByMerchantCodeWithHttpInfo(merchantCode, expand);
        return resp.getData();
    }

    public ApiResponse<CouponResponse> getCouponByMerchantCodeWithHttpInfo(String merchantCode, String expand) throws ApiException {
        Call call = this.getCouponByMerchantCodeValidateBeforeCall(merchantCode, expand, null, null);
        Type localVarReturnType = new TypeToken<CouponResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCouponByMerchantCodeAsync(String merchantCode, String expand, final ApiCallback<CouponResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCouponByMerchantCodeValidateBeforeCall(merchantCode, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCouponsCall(String merchantCode, String description, String couponType, String startDateBegin, String startDateEnd, String expirationDateBegin, String expirationDateEnd, Integer affiliateOid, Boolean excludeExpired, Integer limit, Integer offset, String sort, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/coupon/coupons";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (merchantCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("merchant_code", merchantCode));
        }
        if (description != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("description", description));
        }
        if (couponType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("coupon_type", couponType));
        }
        if (startDateBegin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_date_begin", startDateBegin));
        }
        if (startDateEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_date_end", startDateEnd));
        }
        if (expirationDateBegin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("expiration_date_begin", expirationDateBegin));
        }
        if (expirationDateEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("expiration_date_end", expirationDateEnd));
        }
        if (affiliateOid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("affiliate_oid", affiliateOid));
        }
        if (excludeExpired != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("exclude_expired", excludeExpired));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCouponsValidateBeforeCall(String merchantCode, String description, String couponType, String startDateBegin, String startDateEnd, String expirationDateBegin, String expirationDateEnd, Integer affiliateOid, Boolean excludeExpired, Integer limit, Integer offset, String sort, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getCouponsCall(merchantCode, description, couponType, startDateBegin, startDateEnd, expirationDateBegin, expirationDateEnd, affiliateOid, excludeExpired, limit, offset, sort, expand, progressListener, progressRequestListener);
        return call;
    }

    public CouponsResponse getCoupons(String merchantCode, String description, String couponType, String startDateBegin, String startDateEnd, String expirationDateBegin, String expirationDateEnd, Integer affiliateOid, Boolean excludeExpired, Integer limit, Integer offset, String sort, String expand) throws ApiException {
        ApiResponse<CouponsResponse> resp = this.getCouponsWithHttpInfo(merchantCode, description, couponType, startDateBegin, startDateEnd, expirationDateBegin, expirationDateEnd, affiliateOid, excludeExpired, limit, offset, sort, expand);
        return resp.getData();
    }

    public ApiResponse<CouponsResponse> getCouponsWithHttpInfo(String merchantCode, String description, String couponType, String startDateBegin, String startDateEnd, String expirationDateBegin, String expirationDateEnd, Integer affiliateOid, Boolean excludeExpired, Integer limit, Integer offset, String sort, String expand) throws ApiException {
        Call call = this.getCouponsValidateBeforeCall(merchantCode, description, couponType, startDateBegin, startDateEnd, expirationDateBegin, expirationDateEnd, affiliateOid, excludeExpired, limit, offset, sort, expand, null, null);
        Type localVarReturnType = new TypeToken<CouponsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCouponsAsync(String merchantCode, String description, String couponType, String startDateBegin, String startDateEnd, String expirationDateBegin, String expirationDateEnd, Integer affiliateOid, Boolean excludeExpired, Integer limit, Integer offset, String sort, String expand, final ApiCallback<CouponsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCouponsValidateBeforeCall(merchantCode, description, couponType, startDateBegin, startDateEnd, expirationDateBegin, expirationDateEnd, affiliateOid, excludeExpired, limit, offset, sort, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCouponsByQueryCall(CouponQuery couponQuery, Integer limit, Integer offset, String sort, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CouponQuery localVarPostBody = couponQuery;
        String localVarPath = "/coupon/coupons/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCouponsByQueryValidateBeforeCall(CouponQuery couponQuery, Integer limit, Integer offset, String sort, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (couponQuery == null) {
            throw new ApiException("Missing the required parameter 'couponQuery' when calling getCouponsByQuery(Async)");
        }
        Call call = this.getCouponsByQueryCall(couponQuery, limit, offset, sort, expand, progressListener, progressRequestListener);
        return call;
    }

    public CouponsResponse getCouponsByQuery(CouponQuery couponQuery, Integer limit, Integer offset, String sort, String expand) throws ApiException {
        ApiResponse<CouponsResponse> resp = this.getCouponsByQueryWithHttpInfo(couponQuery, limit, offset, sort, expand);
        return resp.getData();
    }

    public ApiResponse<CouponsResponse> getCouponsByQueryWithHttpInfo(CouponQuery couponQuery, Integer limit, Integer offset, String sort, String expand) throws ApiException {
        Call call = this.getCouponsByQueryValidateBeforeCall(couponQuery, limit, offset, sort, expand, null, null);
        Type localVarReturnType = new TypeToken<CouponsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCouponsByQueryAsync(CouponQuery couponQuery, Integer limit, Integer offset, String sort, String expand, final ApiCallback<CouponsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCouponsByQueryValidateBeforeCall(couponQuery, limit, offset, sort, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getEditorValuesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/coupon/editor_values";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getEditorValuesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getEditorValuesCall(progressListener, progressRequestListener);
        return call;
    }

    public CouponEditorValues getEditorValues() throws ApiException {
        ApiResponse<CouponEditorValues> resp = this.getEditorValuesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<CouponEditorValues> getEditorValuesWithHttpInfo() throws ApiException {
        Call call = this.getEditorValuesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<CouponEditorValues>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getEditorValuesAsync(final ApiCallback<CouponEditorValues> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getEditorValuesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponEditorValues>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call insertCouponCall(Coupon coupon, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Coupon localVarPostBody = coupon;
        String localVarPath = "/coupon/coupons";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call insertCouponValidateBeforeCall(Coupon coupon, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (coupon == null) {
            throw new ApiException("Missing the required parameter 'coupon' when calling insertCoupon(Async)");
        }
        Call call = this.insertCouponCall(coupon, expand, progressListener, progressRequestListener);
        return call;
    }

    public CouponResponse insertCoupon(Coupon coupon, String expand) throws ApiException {
        ApiResponse<CouponResponse> resp = this.insertCouponWithHttpInfo(coupon, expand);
        return resp.getData();
    }

    public ApiResponse<CouponResponse> insertCouponWithHttpInfo(Coupon coupon, String expand) throws ApiException {
        Call call = this.insertCouponValidateBeforeCall(coupon, expand, null, null);
        Type localVarReturnType = new TypeToken<CouponResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call insertCouponAsync(Coupon coupon, String expand, final ApiCallback<CouponResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.insertCouponValidateBeforeCall(coupon, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call insertCouponsCall(CouponsRequest couponsRequest, String expand, Boolean placeholders, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CouponsRequest localVarPostBody = couponsRequest;
        String localVarPath = "/coupon/coupons/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        if (placeholders != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_placeholders", placeholders));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call insertCouponsValidateBeforeCall(CouponsRequest couponsRequest, String expand, Boolean placeholders, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (couponsRequest == null) {
            throw new ApiException("Missing the required parameter 'couponsRequest' when calling insertCoupons(Async)");
        }
        Call call = this.insertCouponsCall(couponsRequest, expand, placeholders, progressListener, progressRequestListener);
        return call;
    }

    public CouponsResponse insertCoupons(CouponsRequest couponsRequest, String expand, Boolean placeholders) throws ApiException {
        ApiResponse<CouponsResponse> resp = this.insertCouponsWithHttpInfo(couponsRequest, expand, placeholders);
        return resp.getData();
    }

    public ApiResponse<CouponsResponse> insertCouponsWithHttpInfo(CouponsRequest couponsRequest, String expand, Boolean placeholders) throws ApiException {
        Call call = this.insertCouponsValidateBeforeCall(couponsRequest, expand, placeholders, null, null);
        Type localVarReturnType = new TypeToken<CouponsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call insertCouponsAsync(CouponsRequest couponsRequest, String expand, Boolean placeholders, final ApiCallback<CouponsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.insertCouponsValidateBeforeCall(couponsRequest, expand, placeholders, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call searchItemsCall(String s, Integer m, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/coupon/searchItems";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (s != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("s", s));
        }
        if (m != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("m", m));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call searchItemsValidateBeforeCall(String s, Integer m, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.searchItemsCall(s, m, progressListener, progressRequestListener);
        return call;
    }

    public CouponItemSearchResultsResponse searchItems(String s, Integer m) throws ApiException {
        ApiResponse<CouponItemSearchResultsResponse> resp = this.searchItemsWithHttpInfo(s, m);
        return resp.getData();
    }

    public ApiResponse<CouponItemSearchResultsResponse> searchItemsWithHttpInfo(String s, Integer m) throws ApiException {
        Call call = this.searchItemsValidateBeforeCall(s, m, null, null);
        Type localVarReturnType = new TypeToken<CouponItemSearchResultsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call searchItemsAsync(String s, Integer m, final ApiCallback<CouponItemSearchResultsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.searchItemsValidateBeforeCall(s, m, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponItemSearchResultsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateAutoApplyCall(CouponAutoApplyConditions conditions, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CouponAutoApplyConditions localVarPostBody = conditions;
        String localVarPath = "/coupon/auto_apply";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateAutoApplyValidateBeforeCall(CouponAutoApplyConditions conditions, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (conditions == null) {
            throw new ApiException("Missing the required parameter 'conditions' when calling updateAutoApply(Async)");
        }
        Call call = this.updateAutoApplyCall(conditions, progressListener, progressRequestListener);
        return call;
    }

    public void updateAutoApply(CouponAutoApplyConditions conditions) throws ApiException {
        this.updateAutoApplyWithHttpInfo(conditions);
    }

    public ApiResponse<Void> updateAutoApplyWithHttpInfo(CouponAutoApplyConditions conditions) throws ApiException {
        Call call = this.updateAutoApplyValidateBeforeCall(conditions, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateAutoApplyAsync(CouponAutoApplyConditions conditions, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateAutoApplyValidateBeforeCall(conditions, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateCouponCall(Coupon coupon, Integer couponOid, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Coupon localVarPostBody = coupon;
        String localVarPath = "/coupon/coupons/{coupon_oid}".replaceAll("\\{coupon_oid\\}", this.apiClient.escapeString(couponOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateCouponValidateBeforeCall(Coupon coupon, Integer couponOid, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (coupon == null) {
            throw new ApiException("Missing the required parameter 'coupon' when calling updateCoupon(Async)");
        }
        if (couponOid == null) {
            throw new ApiException("Missing the required parameter 'couponOid' when calling updateCoupon(Async)");
        }
        Call call = this.updateCouponCall(coupon, couponOid, expand, progressListener, progressRequestListener);
        return call;
    }

    public CouponResponse updateCoupon(Coupon coupon, Integer couponOid, String expand) throws ApiException {
        ApiResponse<CouponResponse> resp = this.updateCouponWithHttpInfo(coupon, couponOid, expand);
        return resp.getData();
    }

    public ApiResponse<CouponResponse> updateCouponWithHttpInfo(Coupon coupon, Integer couponOid, String expand) throws ApiException {
        Call call = this.updateCouponValidateBeforeCall(coupon, couponOid, expand, null, null);
        Type localVarReturnType = new TypeToken<CouponResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateCouponAsync(Coupon coupon, Integer couponOid, String expand, final ApiCallback<CouponResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateCouponValidateBeforeCall(coupon, couponOid, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateCouponsCall(CouponsRequest couponsRequest, String expand, Boolean placeholders, Boolean async, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CouponsRequest localVarPostBody = couponsRequest;
        String localVarPath = "/coupon/coupons/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        if (placeholders != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_placeholders", placeholders));
        }
        if (async != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_async", async));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateCouponsValidateBeforeCall(CouponsRequest couponsRequest, String expand, Boolean placeholders, Boolean async, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (couponsRequest == null) {
            throw new ApiException("Missing the required parameter 'couponsRequest' when calling updateCoupons(Async)");
        }
        Call call = this.updateCouponsCall(couponsRequest, expand, placeholders, async, progressListener, progressRequestListener);
        return call;
    }

    public CouponsResponse updateCoupons(CouponsRequest couponsRequest, String expand, Boolean placeholders, Boolean async) throws ApiException {
        ApiResponse<CouponsResponse> resp = this.updateCouponsWithHttpInfo(couponsRequest, expand, placeholders, async);
        return resp.getData();
    }

    public ApiResponse<CouponsResponse> updateCouponsWithHttpInfo(CouponsRequest couponsRequest, String expand, Boolean placeholders, Boolean async) throws ApiException {
        Call call = this.updateCouponsValidateBeforeCall(couponsRequest, expand, placeholders, async, null, null);
        Type localVarReturnType = new TypeToken<CouponsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateCouponsAsync(CouponsRequest couponsRequest, String expand, Boolean placeholders, Boolean async, final ApiCallback<CouponsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateCouponsValidateBeforeCall(couponsRequest, expand, placeholders, async, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CouponsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call uploadCouponCodesCall(Integer couponOid, UploadCouponCodesRequest uploadCouponCodesRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UploadCouponCodesRequest localVarPostBody = uploadCouponCodesRequest;
        String localVarPath = "/coupon/coupons/{coupon_oid}/upload_codes".replaceAll("\\{coupon_oid\\}", this.apiClient.escapeString(couponOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uploadCouponCodesValidateBeforeCall(Integer couponOid, UploadCouponCodesRequest uploadCouponCodesRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (couponOid == null) {
            throw new ApiException("Missing the required parameter 'couponOid' when calling uploadCouponCodes(Async)");
        }
        if (uploadCouponCodesRequest == null) {
            throw new ApiException("Missing the required parameter 'uploadCouponCodesRequest' when calling uploadCouponCodes(Async)");
        }
        Call call = this.uploadCouponCodesCall(couponOid, uploadCouponCodesRequest, progressListener, progressRequestListener);
        return call;
    }

    public UploadCouponCodesResponse uploadCouponCodes(Integer couponOid, UploadCouponCodesRequest uploadCouponCodesRequest) throws ApiException {
        ApiResponse<UploadCouponCodesResponse> resp = this.uploadCouponCodesWithHttpInfo(couponOid, uploadCouponCodesRequest);
        return resp.getData();
    }

    public ApiResponse<UploadCouponCodesResponse> uploadCouponCodesWithHttpInfo(Integer couponOid, UploadCouponCodesRequest uploadCouponCodesRequest) throws ApiException {
        Call call = this.uploadCouponCodesValidateBeforeCall(couponOid, uploadCouponCodesRequest, null, null);
        Type localVarReturnType = new TypeToken<UploadCouponCodesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call uploadCouponCodesAsync(Integer couponOid, UploadCouponCodesRequest uploadCouponCodesRequest, final ApiCallback<UploadCouponCodesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uploadCouponCodesValidateBeforeCall(couponOid, uploadCouponCodesRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UploadCouponCodesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

