/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.BaseResponse;
import com.ultracart.admin.v2.models.DelayAutoOrdersResponse;
import com.ultracart.admin.v2.models.PaymentsConfiguration;
import com.ultracart.admin.v2.models.PaymentsConfigurationResponse;
import com.ultracart.admin.v2.models.PaymentsWepayEnroll;
import com.ultracart.admin.v2.models.RotatingTransactionGateway;
import com.ultracart.admin.v2.models.RotatingTransactionGatewayResponse;
import com.ultracart.admin.v2.models.RotatingTransactionGatewaysResponse;
import com.ultracart.admin.v2.models.RtgSummaryResponse;
import com.ultracart.admin.v2.models.StripeConnectResponse;
import com.ultracart.admin.v2.models.TransactionGatewaysRequest;
import com.ultracart.admin.v2.models.TransactionGatewaysResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ConfigurationApi {
    private ApiClient apiClient;

    public ConfigurationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ConfigurationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ConfigurationApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public ConfigurationApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call delayAutoOrdersCall(Integer rtgOid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/checkout/payments/rtg/{rtg_oid}/delayAutoOrders".replaceAll("\\{rtg_oid\\}", this.apiClient.escapeString(rtgOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call delayAutoOrdersValidateBeforeCall(Integer rtgOid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (rtgOid == null) {
            throw new ApiException("Missing the required parameter 'rtgOid' when calling delayAutoOrders(Async)");
        }
        Call call = this.delayAutoOrdersCall(rtgOid, progressListener, progressRequestListener);
        return call;
    }

    public DelayAutoOrdersResponse delayAutoOrders(Integer rtgOid) throws ApiException {
        ApiResponse<DelayAutoOrdersResponse> resp = this.delayAutoOrdersWithHttpInfo(rtgOid);
        return resp.getData();
    }

    public ApiResponse<DelayAutoOrdersResponse> delayAutoOrdersWithHttpInfo(Integer rtgOid) throws ApiException {
        Call call = this.delayAutoOrdersValidateBeforeCall(rtgOid, null, null);
        Type localVarReturnType = new TypeToken<DelayAutoOrdersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call delayAutoOrdersAsync(Integer rtgOid, final ApiCallback<DelayAutoOrdersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.delayAutoOrdersValidateBeforeCall(rtgOid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DelayAutoOrdersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteRotatingTransactionGatewayCall(Integer rtgOid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/checkout/payments/rtg/{rtg_oid}".replaceAll("\\{rtg_oid\\}", this.apiClient.escapeString(rtgOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteRotatingTransactionGatewayValidateBeforeCall(Integer rtgOid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (rtgOid == null) {
            throw new ApiException("Missing the required parameter 'rtgOid' when calling deleteRotatingTransactionGateway(Async)");
        }
        Call call = this.deleteRotatingTransactionGatewayCall(rtgOid, progressListener, progressRequestListener);
        return call;
    }

    public BaseResponse deleteRotatingTransactionGateway(Integer rtgOid) throws ApiException {
        ApiResponse<BaseResponse> resp = this.deleteRotatingTransactionGatewayWithHttpInfo(rtgOid);
        return resp.getData();
    }

    public ApiResponse<BaseResponse> deleteRotatingTransactionGatewayWithHttpInfo(Integer rtgOid) throws ApiException {
        Call call = this.deleteRotatingTransactionGatewayValidateBeforeCall(rtgOid, null, null);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteRotatingTransactionGatewayAsync(Integer rtgOid, final ApiCallback<BaseResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteRotatingTransactionGatewayValidateBeforeCall(rtgOid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getPaymentsConfigurationCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/checkout/payments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPaymentsConfigurationValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getPaymentsConfigurationCall(progressListener, progressRequestListener);
        return call;
    }

    public PaymentsConfigurationResponse getPaymentsConfiguration() throws ApiException {
        ApiResponse<PaymentsConfigurationResponse> resp = this.getPaymentsConfigurationWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<PaymentsConfigurationResponse> getPaymentsConfigurationWithHttpInfo() throws ApiException {
        Call call = this.getPaymentsConfigurationValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<PaymentsConfigurationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPaymentsConfigurationAsync(final ApiCallback<PaymentsConfigurationResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPaymentsConfigurationValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PaymentsConfigurationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getPaymentsRotatingGatewayCall(Integer rtgOid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/checkout/payments/rtg/{rtg_oid}".replaceAll("\\{rtg_oid\\}", this.apiClient.escapeString(rtgOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPaymentsRotatingGatewayValidateBeforeCall(Integer rtgOid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (rtgOid == null) {
            throw new ApiException("Missing the required parameter 'rtgOid' when calling getPaymentsRotatingGateway(Async)");
        }
        Call call = this.getPaymentsRotatingGatewayCall(rtgOid, progressListener, progressRequestListener);
        return call;
    }

    public RotatingTransactionGatewayResponse getPaymentsRotatingGateway(Integer rtgOid) throws ApiException {
        ApiResponse<RotatingTransactionGatewayResponse> resp = this.getPaymentsRotatingGatewayWithHttpInfo(rtgOid);
        return resp.getData();
    }

    public ApiResponse<RotatingTransactionGatewayResponse> getPaymentsRotatingGatewayWithHttpInfo(Integer rtgOid) throws ApiException {
        Call call = this.getPaymentsRotatingGatewayValidateBeforeCall(rtgOid, null, null);
        Type localVarReturnType = new TypeToken<RotatingTransactionGatewayResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPaymentsRotatingGatewayAsync(Integer rtgOid, final ApiCallback<RotatingTransactionGatewayResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPaymentsRotatingGatewayValidateBeforeCall(rtgOid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RotatingTransactionGatewayResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getPaymentsRotatingGatewayByCodeCall(String code, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/checkout/payments/rtg/byCode/{code}".replaceAll("\\{code\\}", this.apiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPaymentsRotatingGatewayByCodeValidateBeforeCall(String code, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling getPaymentsRotatingGatewayByCode(Async)");
        }
        Call call = this.getPaymentsRotatingGatewayByCodeCall(code, progressListener, progressRequestListener);
        return call;
    }

    public RotatingTransactionGatewayResponse getPaymentsRotatingGatewayByCode(String code) throws ApiException {
        ApiResponse<RotatingTransactionGatewayResponse> resp = this.getPaymentsRotatingGatewayByCodeWithHttpInfo(code);
        return resp.getData();
    }

    public ApiResponse<RotatingTransactionGatewayResponse> getPaymentsRotatingGatewayByCodeWithHttpInfo(String code) throws ApiException {
        Call call = this.getPaymentsRotatingGatewayByCodeValidateBeforeCall(code, null, null);
        Type localVarReturnType = new TypeToken<RotatingTransactionGatewayResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPaymentsRotatingGatewayByCodeAsync(String code, final ApiCallback<RotatingTransactionGatewayResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPaymentsRotatingGatewayByCodeValidateBeforeCall(code, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RotatingTransactionGatewayResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getPaymentsRotatingTransactionGatewaysCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/checkout/payments/rtg";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPaymentsRotatingTransactionGatewaysValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getPaymentsRotatingTransactionGatewaysCall(progressListener, progressRequestListener);
        return call;
    }

    public RotatingTransactionGatewaysResponse getPaymentsRotatingTransactionGateways() throws ApiException {
        ApiResponse<RotatingTransactionGatewaysResponse> resp = this.getPaymentsRotatingTransactionGatewaysWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<RotatingTransactionGatewaysResponse> getPaymentsRotatingTransactionGatewaysWithHttpInfo() throws ApiException {
        Call call = this.getPaymentsRotatingTransactionGatewaysValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<RotatingTransactionGatewaysResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPaymentsRotatingTransactionGatewaysAsync(final ApiCallback<RotatingTransactionGatewaysResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPaymentsRotatingTransactionGatewaysValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RotatingTransactionGatewaysResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getPaymentsRtgSummariesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/checkout/payments/rtg/summaries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPaymentsRtgSummariesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getPaymentsRtgSummariesCall(progressListener, progressRequestListener);
        return call;
    }

    public RtgSummaryResponse getPaymentsRtgSummaries() throws ApiException {
        ApiResponse<RtgSummaryResponse> resp = this.getPaymentsRtgSummariesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<RtgSummaryResponse> getPaymentsRtgSummariesWithHttpInfo() throws ApiException {
        Call call = this.getPaymentsRtgSummariesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<RtgSummaryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPaymentsRtgSummariesAsync(final ApiCallback<RtgSummaryResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPaymentsRtgSummariesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RtgSummaryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getPaymentsTransactionGatewaysCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/checkout/payments/tg";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPaymentsTransactionGatewaysValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getPaymentsTransactionGatewaysCall(progressListener, progressRequestListener);
        return call;
    }

    public TransactionGatewaysResponse getPaymentsTransactionGateways() throws ApiException {
        ApiResponse<TransactionGatewaysResponse> resp = this.getPaymentsTransactionGatewaysWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<TransactionGatewaysResponse> getPaymentsTransactionGatewaysWithHttpInfo() throws ApiException {
        Call call = this.getPaymentsTransactionGatewaysValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<TransactionGatewaysResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPaymentsTransactionGatewaysAsync(final ApiCallback<TransactionGatewaysResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPaymentsTransactionGatewaysValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TransactionGatewaysResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call insertRotatingTransactionGatewayCall(RotatingTransactionGateway rotatingTransactionGateway, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RotatingTransactionGateway localVarPostBody = rotatingTransactionGateway;
        String localVarPath = "/configuration/checkout/payments/rtg/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call insertRotatingTransactionGatewayValidateBeforeCall(RotatingTransactionGateway rotatingTransactionGateway, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (rotatingTransactionGateway == null) {
            throw new ApiException("Missing the required parameter 'rotatingTransactionGateway' when calling insertRotatingTransactionGateway(Async)");
        }
        Call call = this.insertRotatingTransactionGatewayCall(rotatingTransactionGateway, progressListener, progressRequestListener);
        return call;
    }

    public RotatingTransactionGatewayResponse insertRotatingTransactionGateway(RotatingTransactionGateway rotatingTransactionGateway) throws ApiException {
        ApiResponse<RotatingTransactionGatewayResponse> resp = this.insertRotatingTransactionGatewayWithHttpInfo(rotatingTransactionGateway);
        return resp.getData();
    }

    public ApiResponse<RotatingTransactionGatewayResponse> insertRotatingTransactionGatewayWithHttpInfo(RotatingTransactionGateway rotatingTransactionGateway) throws ApiException {
        Call call = this.insertRotatingTransactionGatewayValidateBeforeCall(rotatingTransactionGateway, null, null);
        Type localVarReturnType = new TypeToken<RotatingTransactionGatewayResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call insertRotatingTransactionGatewayAsync(RotatingTransactionGateway rotatingTransactionGateway, final ApiCallback<RotatingTransactionGatewayResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.insertRotatingTransactionGatewayValidateBeforeCall(rotatingTransactionGateway, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RotatingTransactionGatewayResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call migrateToRotatingTransactionGatewayCall(String code, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/checkout/payments/tg/migrateToRtgWithCodeOf/{code}".replaceAll("\\{code\\}", this.apiClient.escapeString(code.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call migrateToRotatingTransactionGatewayValidateBeforeCall(String code, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (code == null) {
            throw new ApiException("Missing the required parameter 'code' when calling migrateToRotatingTransactionGateway(Async)");
        }
        Call call = this.migrateToRotatingTransactionGatewayCall(code, progressListener, progressRequestListener);
        return call;
    }

    public RotatingTransactionGatewayResponse migrateToRotatingTransactionGateway(String code) throws ApiException {
        ApiResponse<RotatingTransactionGatewayResponse> resp = this.migrateToRotatingTransactionGatewayWithHttpInfo(code);
        return resp.getData();
    }

    public ApiResponse<RotatingTransactionGatewayResponse> migrateToRotatingTransactionGatewayWithHttpInfo(String code) throws ApiException {
        Call call = this.migrateToRotatingTransactionGatewayValidateBeforeCall(code, null, null);
        Type localVarReturnType = new TypeToken<RotatingTransactionGatewayResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call migrateToRotatingTransactionGatewayAsync(String code, final ApiCallback<RotatingTransactionGatewayResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.migrateToRotatingTransactionGatewayValidateBeforeCall(code, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RotatingTransactionGatewayResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call stripeConnectCall(Integer rtgOid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/configuration/checkout/payments/rtg/{rtg_oid}/stripeConnect".replaceAll("\\{rtg_oid\\}", this.apiClient.escapeString(rtgOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call stripeConnectValidateBeforeCall(Integer rtgOid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (rtgOid == null) {
            throw new ApiException("Missing the required parameter 'rtgOid' when calling stripeConnect(Async)");
        }
        Call call = this.stripeConnectCall(rtgOid, progressListener, progressRequestListener);
        return call;
    }

    public StripeConnectResponse stripeConnect(Integer rtgOid) throws ApiException {
        ApiResponse<StripeConnectResponse> resp = this.stripeConnectWithHttpInfo(rtgOid);
        return resp.getData();
    }

    public ApiResponse<StripeConnectResponse> stripeConnectWithHttpInfo(Integer rtgOid) throws ApiException {
        Call call = this.stripeConnectValidateBeforeCall(rtgOid, null, null);
        Type localVarReturnType = new TypeToken<StripeConnectResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call stripeConnectAsync(Integer rtgOid, final ApiCallback<StripeConnectResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.stripeConnectValidateBeforeCall(rtgOid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<StripeConnectResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updatePaymentsConfigurationCall(PaymentsConfiguration paymentsConfiguration, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PaymentsConfiguration localVarPostBody = paymentsConfiguration;
        String localVarPath = "/configuration/checkout/payments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updatePaymentsConfigurationValidateBeforeCall(PaymentsConfiguration paymentsConfiguration, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (paymentsConfiguration == null) {
            throw new ApiException("Missing the required parameter 'paymentsConfiguration' when calling updatePaymentsConfiguration(Async)");
        }
        Call call = this.updatePaymentsConfigurationCall(paymentsConfiguration, progressListener, progressRequestListener);
        return call;
    }

    public PaymentsConfigurationResponse updatePaymentsConfiguration(PaymentsConfiguration paymentsConfiguration) throws ApiException {
        ApiResponse<PaymentsConfigurationResponse> resp = this.updatePaymentsConfigurationWithHttpInfo(paymentsConfiguration);
        return resp.getData();
    }

    public ApiResponse<PaymentsConfigurationResponse> updatePaymentsConfigurationWithHttpInfo(PaymentsConfiguration paymentsConfiguration) throws ApiException {
        Call call = this.updatePaymentsConfigurationValidateBeforeCall(paymentsConfiguration, null, null);
        Type localVarReturnType = new TypeToken<PaymentsConfigurationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updatePaymentsConfigurationAsync(PaymentsConfiguration paymentsConfiguration, final ApiCallback<PaymentsConfigurationResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updatePaymentsConfigurationValidateBeforeCall(paymentsConfiguration, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PaymentsConfigurationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updatePaymentsTransactionGatewayCall(TransactionGatewaysRequest updateGatewayRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TransactionGatewaysRequest localVarPostBody = updateGatewayRequest;
        String localVarPath = "/configuration/checkout/payments/tg";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updatePaymentsTransactionGatewayValidateBeforeCall(TransactionGatewaysRequest updateGatewayRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (updateGatewayRequest == null) {
            throw new ApiException("Missing the required parameter 'updateGatewayRequest' when calling updatePaymentsTransactionGateway(Async)");
        }
        Call call = this.updatePaymentsTransactionGatewayCall(updateGatewayRequest, progressListener, progressRequestListener);
        return call;
    }

    public TransactionGatewaysResponse updatePaymentsTransactionGateway(TransactionGatewaysRequest updateGatewayRequest) throws ApiException {
        ApiResponse<TransactionGatewaysResponse> resp = this.updatePaymentsTransactionGatewayWithHttpInfo(updateGatewayRequest);
        return resp.getData();
    }

    public ApiResponse<TransactionGatewaysResponse> updatePaymentsTransactionGatewayWithHttpInfo(TransactionGatewaysRequest updateGatewayRequest) throws ApiException {
        Call call = this.updatePaymentsTransactionGatewayValidateBeforeCall(updateGatewayRequest, null, null);
        Type localVarReturnType = new TypeToken<TransactionGatewaysResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updatePaymentsTransactionGatewayAsync(TransactionGatewaysRequest updateGatewayRequest, final ApiCallback<TransactionGatewaysResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updatePaymentsTransactionGatewayValidateBeforeCall(updateGatewayRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TransactionGatewaysResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateRotatingTransactionGatewayCall(Integer rtgOid, RotatingTransactionGateway rotatingTransactionGateway, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RotatingTransactionGateway localVarPostBody = rotatingTransactionGateway;
        String localVarPath = "/configuration/checkout/payments/rtg/{rtg_oid}".replaceAll("\\{rtg_oid\\}", this.apiClient.escapeString(rtgOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateRotatingTransactionGatewayValidateBeforeCall(Integer rtgOid, RotatingTransactionGateway rotatingTransactionGateway, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (rtgOid == null) {
            throw new ApiException("Missing the required parameter 'rtgOid' when calling updateRotatingTransactionGateway(Async)");
        }
        if (rotatingTransactionGateway == null) {
            throw new ApiException("Missing the required parameter 'rotatingTransactionGateway' when calling updateRotatingTransactionGateway(Async)");
        }
        Call call = this.updateRotatingTransactionGatewayCall(rtgOid, rotatingTransactionGateway, progressListener, progressRequestListener);
        return call;
    }

    public RotatingTransactionGatewayResponse updateRotatingTransactionGateway(Integer rtgOid, RotatingTransactionGateway rotatingTransactionGateway) throws ApiException {
        ApiResponse<RotatingTransactionGatewayResponse> resp = this.updateRotatingTransactionGatewayWithHttpInfo(rtgOid, rotatingTransactionGateway);
        return resp.getData();
    }

    public ApiResponse<RotatingTransactionGatewayResponse> updateRotatingTransactionGatewayWithHttpInfo(Integer rtgOid, RotatingTransactionGateway rotatingTransactionGateway) throws ApiException {
        Call call = this.updateRotatingTransactionGatewayValidateBeforeCall(rtgOid, rotatingTransactionGateway, null, null);
        Type localVarReturnType = new TypeToken<RotatingTransactionGatewayResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateRotatingTransactionGatewayAsync(Integer rtgOid, RotatingTransactionGateway rotatingTransactionGateway, final ApiCallback<RotatingTransactionGatewayResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateRotatingTransactionGatewayValidateBeforeCall(rtgOid, rotatingTransactionGateway, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RotatingTransactionGatewayResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call wepayEnrollCall(PaymentsWepayEnroll wepayEnroll, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PaymentsWepayEnroll localVarPostBody = wepayEnroll;
        String localVarPath = "/configuration/checkout/wepayEnroll";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call wepayEnrollValidateBeforeCall(PaymentsWepayEnroll wepayEnroll, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (wepayEnroll == null) {
            throw new ApiException("Missing the required parameter 'wepayEnroll' when calling wepayEnroll(Async)");
        }
        Call call = this.wepayEnrollCall(wepayEnroll, progressListener, progressRequestListener);
        return call;
    }

    public PaymentsConfigurationResponse wepayEnroll(PaymentsWepayEnroll wepayEnroll) throws ApiException {
        ApiResponse<PaymentsConfigurationResponse> resp = this.wepayEnrollWithHttpInfo(wepayEnroll);
        return resp.getData();
    }

    public ApiResponse<PaymentsConfigurationResponse> wepayEnrollWithHttpInfo(PaymentsWepayEnroll wepayEnroll) throws ApiException {
        Call call = this.wepayEnrollValidateBeforeCall(wepayEnroll, null, null);
        Type localVarReturnType = new TypeToken<PaymentsConfigurationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call wepayEnrollAsync(PaymentsWepayEnroll wepayEnroll, final ApiCallback<PaymentsConfigurationResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.wepayEnrollValidateBeforeCall(wepayEnroll, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PaymentsConfigurationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

