/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.Cart;
import com.ultracart.admin.v2.models.CartAffirmCheckoutResponse;
import com.ultracart.admin.v2.models.CartFinalizeOrderRequest;
import com.ultracart.admin.v2.models.CartFinalizeOrderResponse;
import com.ultracart.admin.v2.models.CartProfileLoginRequest;
import com.ultracart.admin.v2.models.CartProfileLoginResponse;
import com.ultracart.admin.v2.models.CartProfileRegisterRequest;
import com.ultracart.admin.v2.models.CartProfileRegisterResponse;
import com.ultracart.admin.v2.models.CartResponse;
import com.ultracart.admin.v2.models.CartValidationRequest;
import com.ultracart.admin.v2.models.CartValidationResponse;
import com.ultracart.admin.v2.models.CheckoutAllowedCountriesResponse;
import com.ultracart.admin.v2.models.CheckoutHandoffRequest;
import com.ultracart.admin.v2.models.CheckoutHandoffResponse;
import com.ultracart.admin.v2.models.CheckoutSetupBrowserKeyRequest;
import com.ultracart.admin.v2.models.CheckoutSetupBrowserKeyResponse;
import com.ultracart.admin.v2.models.CheckoutStateProvinceResponse;
import com.ultracart.admin.v2.models.CityStateZip;
import com.ultracart.admin.v2.models.ItemsResponse;
import com.ultracart.admin.v2.models.RegisterAffiliateClickRequest;
import com.ultracart.admin.v2.models.RegisterAffiliateClickResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class CheckoutApi {
    private ApiClient apiClient;

    public CheckoutApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CheckoutApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CheckoutApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public CheckoutApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call cityStateCall(Cart cart, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Cart localVarPostBody = cart;
        String localVarPath = "/checkout/city_state";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call cityStateValidateBeforeCall(Cart cart, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (cart == null) {
            throw new ApiException("Missing the required parameter 'cart' when calling cityState(Async)");
        }
        Call call = this.cityStateCall(cart, progressListener, progressRequestListener);
        return call;
    }

    public CityStateZip cityState(Cart cart) throws ApiException {
        ApiResponse<CityStateZip> resp = this.cityStateWithHttpInfo(cart);
        return resp.getData();
    }

    public ApiResponse<CityStateZip> cityStateWithHttpInfo(Cart cart) throws ApiException {
        Call call = this.cityStateValidateBeforeCall(cart, null, null);
        Type localVarReturnType = new TypeToken<CityStateZip>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call cityStateAsync(Cart cart, final ApiCallback<CityStateZip> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.cityStateValidateBeforeCall(cart, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CityStateZip>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call finalizeOrderCall(CartFinalizeOrderRequest finalizeRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CartFinalizeOrderRequest localVarPostBody = finalizeRequest;
        String localVarPath = "/checkout/cart/finalizeOrder";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call finalizeOrderValidateBeforeCall(CartFinalizeOrderRequest finalizeRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (finalizeRequest == null) {
            throw new ApiException("Missing the required parameter 'finalizeRequest' when calling finalizeOrder(Async)");
        }
        Call call = this.finalizeOrderCall(finalizeRequest, progressListener, progressRequestListener);
        return call;
    }

    public CartFinalizeOrderResponse finalizeOrder(CartFinalizeOrderRequest finalizeRequest) throws ApiException {
        ApiResponse<CartFinalizeOrderResponse> resp = this.finalizeOrderWithHttpInfo(finalizeRequest);
        return resp.getData();
    }

    public ApiResponse<CartFinalizeOrderResponse> finalizeOrderWithHttpInfo(CartFinalizeOrderRequest finalizeRequest) throws ApiException {
        Call call = this.finalizeOrderValidateBeforeCall(finalizeRequest, null, null);
        Type localVarReturnType = new TypeToken<CartFinalizeOrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call finalizeOrderAsync(CartFinalizeOrderRequest finalizeRequest, final ApiCallback<CartFinalizeOrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.finalizeOrderValidateBeforeCall(finalizeRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CartFinalizeOrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAffirmCheckoutCall(String cartId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/checkout/cart/{cart_id}/affirmCheckout".replaceAll("\\{cart_id\\}", this.apiClient.escapeString(cartId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAffirmCheckoutValidateBeforeCall(String cartId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (cartId == null) {
            throw new ApiException("Missing the required parameter 'cartId' when calling getAffirmCheckout(Async)");
        }
        Call call = this.getAffirmCheckoutCall(cartId, progressListener, progressRequestListener);
        return call;
    }

    public CartAffirmCheckoutResponse getAffirmCheckout(String cartId) throws ApiException {
        ApiResponse<CartAffirmCheckoutResponse> resp = this.getAffirmCheckoutWithHttpInfo(cartId);
        return resp.getData();
    }

    public ApiResponse<CartAffirmCheckoutResponse> getAffirmCheckoutWithHttpInfo(String cartId) throws ApiException {
        Call call = this.getAffirmCheckoutValidateBeforeCall(cartId, null, null);
        Type localVarReturnType = new TypeToken<CartAffirmCheckoutResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAffirmCheckoutAsync(String cartId, final ApiCallback<CartAffirmCheckoutResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAffirmCheckoutValidateBeforeCall(cartId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CartAffirmCheckoutResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAllowedCountriesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/checkout/allowedCountries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllowedCountriesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAllowedCountriesCall(progressListener, progressRequestListener);
        return call;
    }

    public CheckoutAllowedCountriesResponse getAllowedCountries() throws ApiException {
        ApiResponse<CheckoutAllowedCountriesResponse> resp = this.getAllowedCountriesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<CheckoutAllowedCountriesResponse> getAllowedCountriesWithHttpInfo() throws ApiException {
        Call call = this.getAllowedCountriesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<CheckoutAllowedCountriesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllowedCountriesAsync(final ApiCallback<CheckoutAllowedCountriesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllowedCountriesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CheckoutAllowedCountriesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCartCall(String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/checkout/cart";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCartValidateBeforeCall(String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getCartCall(expand, progressListener, progressRequestListener);
        return call;
    }

    public CartResponse getCart(String expand) throws ApiException {
        ApiResponse<CartResponse> resp = this.getCartWithHttpInfo(expand);
        return resp.getData();
    }

    public ApiResponse<CartResponse> getCartWithHttpInfo(String expand) throws ApiException {
        Call call = this.getCartValidateBeforeCall(expand, null, null);
        Type localVarReturnType = new TypeToken<CartResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCartAsync(String expand, final ApiCallback<CartResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCartValidateBeforeCall(expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CartResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCartByCartIdCall(String cartId, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/checkout/cart/{cart_id}".replaceAll("\\{cart_id\\}", this.apiClient.escapeString(cartId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCartByCartIdValidateBeforeCall(String cartId, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (cartId == null) {
            throw new ApiException("Missing the required parameter 'cartId' when calling getCartByCartId(Async)");
        }
        Call call = this.getCartByCartIdCall(cartId, expand, progressListener, progressRequestListener);
        return call;
    }

    public CartResponse getCartByCartId(String cartId, String expand) throws ApiException {
        ApiResponse<CartResponse> resp = this.getCartByCartIdWithHttpInfo(cartId, expand);
        return resp.getData();
    }

    public ApiResponse<CartResponse> getCartByCartIdWithHttpInfo(String cartId, String expand) throws ApiException {
        Call call = this.getCartByCartIdValidateBeforeCall(cartId, expand, null, null);
        Type localVarReturnType = new TypeToken<CartResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCartByCartIdAsync(String cartId, String expand, final ApiCallback<CartResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCartByCartIdValidateBeforeCall(cartId, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CartResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCartByReturnCodeCall(String returnCode, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/checkout/return/{return_code}".replaceAll("\\{return_code\\}", this.apiClient.escapeString(returnCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCartByReturnCodeValidateBeforeCall(String returnCode, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (returnCode == null) {
            throw new ApiException("Missing the required parameter 'returnCode' when calling getCartByReturnCode(Async)");
        }
        Call call = this.getCartByReturnCodeCall(returnCode, expand, progressListener, progressRequestListener);
        return call;
    }

    public CartResponse getCartByReturnCode(String returnCode, String expand) throws ApiException {
        ApiResponse<CartResponse> resp = this.getCartByReturnCodeWithHttpInfo(returnCode, expand);
        return resp.getData();
    }

    public ApiResponse<CartResponse> getCartByReturnCodeWithHttpInfo(String returnCode, String expand) throws ApiException {
        Call call = this.getCartByReturnCodeValidateBeforeCall(returnCode, expand, null, null);
        Type localVarReturnType = new TypeToken<CartResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCartByReturnCodeAsync(String returnCode, String expand, final ApiCallback<CartResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCartByReturnCodeValidateBeforeCall(returnCode, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CartResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCartByReturnTokenCall(String returnToken, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/checkout/return_token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (returnToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("return_token", returnToken));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCartByReturnTokenValidateBeforeCall(String returnToken, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getCartByReturnTokenCall(returnToken, expand, progressListener, progressRequestListener);
        return call;
    }

    public CartResponse getCartByReturnToken(String returnToken, String expand) throws ApiException {
        ApiResponse<CartResponse> resp = this.getCartByReturnTokenWithHttpInfo(returnToken, expand);
        return resp.getData();
    }

    public ApiResponse<CartResponse> getCartByReturnTokenWithHttpInfo(String returnToken, String expand) throws ApiException {
        Call call = this.getCartByReturnTokenValidateBeforeCall(returnToken, expand, null, null);
        Type localVarReturnType = new TypeToken<CartResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCartByReturnTokenAsync(String returnToken, String expand, final ApiCallback<CartResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCartByReturnTokenValidateBeforeCall(returnToken, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CartResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getStateProvincesForCountryCall(String countryCode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/checkout/stateProvincesForCountry/{country_code}".replaceAll("\\{country_code\\}", this.apiClient.escapeString(countryCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getStateProvincesForCountryValidateBeforeCall(String countryCode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling getStateProvincesForCountry(Async)");
        }
        Call call = this.getStateProvincesForCountryCall(countryCode, progressListener, progressRequestListener);
        return call;
    }

    public CheckoutStateProvinceResponse getStateProvincesForCountry(String countryCode) throws ApiException {
        ApiResponse<CheckoutStateProvinceResponse> resp = this.getStateProvincesForCountryWithHttpInfo(countryCode);
        return resp.getData();
    }

    public ApiResponse<CheckoutStateProvinceResponse> getStateProvincesForCountryWithHttpInfo(String countryCode) throws ApiException {
        Call call = this.getStateProvincesForCountryValidateBeforeCall(countryCode, null, null);
        Type localVarReturnType = new TypeToken<CheckoutStateProvinceResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getStateProvincesForCountryAsync(String countryCode, final ApiCallback<CheckoutStateProvinceResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getStateProvincesForCountryValidateBeforeCall(countryCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CheckoutStateProvinceResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call handoffCartCall(CheckoutHandoffRequest handoffRequest, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CheckoutHandoffRequest localVarPostBody = handoffRequest;
        String localVarPath = "/checkout/cart/handoff";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call handoffCartValidateBeforeCall(CheckoutHandoffRequest handoffRequest, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (handoffRequest == null) {
            throw new ApiException("Missing the required parameter 'handoffRequest' when calling handoffCart(Async)");
        }
        Call call = this.handoffCartCall(handoffRequest, expand, progressListener, progressRequestListener);
        return call;
    }

    public CheckoutHandoffResponse handoffCart(CheckoutHandoffRequest handoffRequest, String expand) throws ApiException {
        ApiResponse<CheckoutHandoffResponse> resp = this.handoffCartWithHttpInfo(handoffRequest, expand);
        return resp.getData();
    }

    public ApiResponse<CheckoutHandoffResponse> handoffCartWithHttpInfo(CheckoutHandoffRequest handoffRequest, String expand) throws ApiException {
        Call call = this.handoffCartValidateBeforeCall(handoffRequest, expand, null, null);
        Type localVarReturnType = new TypeToken<CheckoutHandoffResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call handoffCartAsync(CheckoutHandoffRequest handoffRequest, String expand, final ApiCallback<CheckoutHandoffResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.handoffCartValidateBeforeCall(handoffRequest, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CheckoutHandoffResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call loginCall(CartProfileLoginRequest loginRequest, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CartProfileLoginRequest localVarPostBody = loginRequest;
        String localVarPath = "/checkout/cart/profile/login";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call loginValidateBeforeCall(CartProfileLoginRequest loginRequest, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (loginRequest == null) {
            throw new ApiException("Missing the required parameter 'loginRequest' when calling login(Async)");
        }
        Call call = this.loginCall(loginRequest, expand, progressListener, progressRequestListener);
        return call;
    }

    public CartProfileLoginResponse login(CartProfileLoginRequest loginRequest, String expand) throws ApiException {
        ApiResponse<CartProfileLoginResponse> resp = this.loginWithHttpInfo(loginRequest, expand);
        return resp.getData();
    }

    public ApiResponse<CartProfileLoginResponse> loginWithHttpInfo(CartProfileLoginRequest loginRequest, String expand) throws ApiException {
        Call call = this.loginValidateBeforeCall(loginRequest, expand, null, null);
        Type localVarReturnType = new TypeToken<CartProfileLoginResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call loginAsync(CartProfileLoginRequest loginRequest, String expand, final ApiCallback<CartProfileLoginResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.loginValidateBeforeCall(loginRequest, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CartProfileLoginResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call logoutCall(Cart cart, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Cart localVarPostBody = cart;
        String localVarPath = "/checkout/cart/profile/logout";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call logoutValidateBeforeCall(Cart cart, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (cart == null) {
            throw new ApiException("Missing the required parameter 'cart' when calling logout(Async)");
        }
        Call call = this.logoutCall(cart, expand, progressListener, progressRequestListener);
        return call;
    }

    public CartResponse logout(Cart cart, String expand) throws ApiException {
        ApiResponse<CartResponse> resp = this.logoutWithHttpInfo(cart, expand);
        return resp.getData();
    }

    public ApiResponse<CartResponse> logoutWithHttpInfo(Cart cart, String expand) throws ApiException {
        Call call = this.logoutValidateBeforeCall(cart, expand, null, null);
        Type localVarReturnType = new TypeToken<CartResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call logoutAsync(Cart cart, String expand, final ApiCallback<CartResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.logoutValidateBeforeCall(cart, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CartResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call registerCall(CartProfileRegisterRequest registerRequest, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CartProfileRegisterRequest localVarPostBody = registerRequest;
        String localVarPath = "/checkout/cart/profile/register";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call registerValidateBeforeCall(CartProfileRegisterRequest registerRequest, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (registerRequest == null) {
            throw new ApiException("Missing the required parameter 'registerRequest' when calling register(Async)");
        }
        Call call = this.registerCall(registerRequest, expand, progressListener, progressRequestListener);
        return call;
    }

    public CartProfileRegisterResponse register(CartProfileRegisterRequest registerRequest, String expand) throws ApiException {
        ApiResponse<CartProfileRegisterResponse> resp = this.registerWithHttpInfo(registerRequest, expand);
        return resp.getData();
    }

    public ApiResponse<CartProfileRegisterResponse> registerWithHttpInfo(CartProfileRegisterRequest registerRequest, String expand) throws ApiException {
        Call call = this.registerValidateBeforeCall(registerRequest, expand, null, null);
        Type localVarReturnType = new TypeToken<CartProfileRegisterResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call registerAsync(CartProfileRegisterRequest registerRequest, String expand, final ApiCallback<CartProfileRegisterResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.registerValidateBeforeCall(registerRequest, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CartProfileRegisterResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call registerAffiliateClickCall(RegisterAffiliateClickRequest registerAffiliateClickRequest, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RegisterAffiliateClickRequest localVarPostBody = registerAffiliateClickRequest;
        String localVarPath = "/checkout/affiliateClick/register";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call registerAffiliateClickValidateBeforeCall(RegisterAffiliateClickRequest registerAffiliateClickRequest, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (registerAffiliateClickRequest == null) {
            throw new ApiException("Missing the required parameter 'registerAffiliateClickRequest' when calling registerAffiliateClick(Async)");
        }
        Call call = this.registerAffiliateClickCall(registerAffiliateClickRequest, expand, progressListener, progressRequestListener);
        return call;
    }

    public RegisterAffiliateClickResponse registerAffiliateClick(RegisterAffiliateClickRequest registerAffiliateClickRequest, String expand) throws ApiException {
        ApiResponse<RegisterAffiliateClickResponse> resp = this.registerAffiliateClickWithHttpInfo(registerAffiliateClickRequest, expand);
        return resp.getData();
    }

    public ApiResponse<RegisterAffiliateClickResponse> registerAffiliateClickWithHttpInfo(RegisterAffiliateClickRequest registerAffiliateClickRequest, String expand) throws ApiException {
        Call call = this.registerAffiliateClickValidateBeforeCall(registerAffiliateClickRequest, expand, null, null);
        Type localVarReturnType = new TypeToken<RegisterAffiliateClickResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call registerAffiliateClickAsync(RegisterAffiliateClickRequest registerAffiliateClickRequest, String expand, final ApiCallback<RegisterAffiliateClickResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.registerAffiliateClickValidateBeforeCall(registerAffiliateClickRequest, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RegisterAffiliateClickResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call relatedItemsForCartCall(Cart cart, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Cart localVarPostBody = cart;
        String localVarPath = "/checkout/related_items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call relatedItemsForCartValidateBeforeCall(Cart cart, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (cart == null) {
            throw new ApiException("Missing the required parameter 'cart' when calling relatedItemsForCart(Async)");
        }
        Call call = this.relatedItemsForCartCall(cart, expand, progressListener, progressRequestListener);
        return call;
    }

    public ItemsResponse relatedItemsForCart(Cart cart, String expand) throws ApiException {
        ApiResponse<ItemsResponse> resp = this.relatedItemsForCartWithHttpInfo(cart, expand);
        return resp.getData();
    }

    public ApiResponse<ItemsResponse> relatedItemsForCartWithHttpInfo(Cart cart, String expand) throws ApiException {
        Call call = this.relatedItemsForCartValidateBeforeCall(cart, expand, null, null);
        Type localVarReturnType = new TypeToken<ItemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call relatedItemsForCartAsync(Cart cart, String expand, final ApiCallback<ItemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.relatedItemsForCartValidateBeforeCall(cart, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ItemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call relatedItemsForItemCall(String itemId, Cart cart, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Cart localVarPostBody = cart;
        String localVarPath = "/checkout/relatedItems/{item_id}".replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call relatedItemsForItemValidateBeforeCall(String itemId, Cart cart, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (itemId == null) {
            throw new ApiException("Missing the required parameter 'itemId' when calling relatedItemsForItem(Async)");
        }
        if (cart == null) {
            throw new ApiException("Missing the required parameter 'cart' when calling relatedItemsForItem(Async)");
        }
        Call call = this.relatedItemsForItemCall(itemId, cart, expand, progressListener, progressRequestListener);
        return call;
    }

    public ItemsResponse relatedItemsForItem(String itemId, Cart cart, String expand) throws ApiException {
        ApiResponse<ItemsResponse> resp = this.relatedItemsForItemWithHttpInfo(itemId, cart, expand);
        return resp.getData();
    }

    public ApiResponse<ItemsResponse> relatedItemsForItemWithHttpInfo(String itemId, Cart cart, String expand) throws ApiException {
        Call call = this.relatedItemsForItemValidateBeforeCall(itemId, cart, expand, null, null);
        Type localVarReturnType = new TypeToken<ItemsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call relatedItemsForItemAsync(String itemId, Cart cart, String expand, final ApiCallback<ItemsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.relatedItemsForItemValidateBeforeCall(itemId, cart, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ItemsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call setupBrowserKeyCall(CheckoutSetupBrowserKeyRequest browserKeyRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CheckoutSetupBrowserKeyRequest localVarPostBody = browserKeyRequest;
        String localVarPath = "/checkout/browser_key";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call setupBrowserKeyValidateBeforeCall(CheckoutSetupBrowserKeyRequest browserKeyRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (browserKeyRequest == null) {
            throw new ApiException("Missing the required parameter 'browserKeyRequest' when calling setupBrowserKey(Async)");
        }
        Call call = this.setupBrowserKeyCall(browserKeyRequest, progressListener, progressRequestListener);
        return call;
    }

    public CheckoutSetupBrowserKeyResponse setupBrowserKey(CheckoutSetupBrowserKeyRequest browserKeyRequest) throws ApiException {
        ApiResponse<CheckoutSetupBrowserKeyResponse> resp = this.setupBrowserKeyWithHttpInfo(browserKeyRequest);
        return resp.getData();
    }

    public ApiResponse<CheckoutSetupBrowserKeyResponse> setupBrowserKeyWithHttpInfo(CheckoutSetupBrowserKeyRequest browserKeyRequest) throws ApiException {
        Call call = this.setupBrowserKeyValidateBeforeCall(browserKeyRequest, null, null);
        Type localVarReturnType = new TypeToken<CheckoutSetupBrowserKeyResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call setupBrowserKeyAsync(CheckoutSetupBrowserKeyRequest browserKeyRequest, final ApiCallback<CheckoutSetupBrowserKeyResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.setupBrowserKeyValidateBeforeCall(browserKeyRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CheckoutSetupBrowserKeyResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateCartCall(Cart cart, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Cart localVarPostBody = cart;
        String localVarPath = "/checkout/cart";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateCartValidateBeforeCall(Cart cart, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (cart == null) {
            throw new ApiException("Missing the required parameter 'cart' when calling updateCart(Async)");
        }
        Call call = this.updateCartCall(cart, expand, progressListener, progressRequestListener);
        return call;
    }

    public CartResponse updateCart(Cart cart, String expand) throws ApiException {
        ApiResponse<CartResponse> resp = this.updateCartWithHttpInfo(cart, expand);
        return resp.getData();
    }

    public ApiResponse<CartResponse> updateCartWithHttpInfo(Cart cart, String expand) throws ApiException {
        Call call = this.updateCartValidateBeforeCall(cart, expand, null, null);
        Type localVarReturnType = new TypeToken<CartResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateCartAsync(Cart cart, String expand, final ApiCallback<CartResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateCartValidateBeforeCall(cart, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CartResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call validateCartCall(CartValidationRequest validationRequest, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CartValidationRequest localVarPostBody = validationRequest;
        String localVarPath = "/checkout/cart/validate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartBrowserApiKey", "ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call validateCartValidateBeforeCall(CartValidationRequest validationRequest, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (validationRequest == null) {
            throw new ApiException("Missing the required parameter 'validationRequest' when calling validateCart(Async)");
        }
        Call call = this.validateCartCall(validationRequest, expand, progressListener, progressRequestListener);
        return call;
    }

    public CartValidationResponse validateCart(CartValidationRequest validationRequest, String expand) throws ApiException {
        ApiResponse<CartValidationResponse> resp = this.validateCartWithHttpInfo(validationRequest, expand);
        return resp.getData();
    }

    public ApiResponse<CartValidationResponse> validateCartWithHttpInfo(CartValidationRequest validationRequest, String expand) throws ApiException {
        Call call = this.validateCartValidateBeforeCall(validationRequest, expand, null, null);
        Type localVarReturnType = new TypeToken<CartValidationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call validateCartAsync(CartValidationRequest validationRequest, String expand, final ApiCallback<CartValidationResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.validateCartValidateBeforeCall(validationRequest, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CartValidationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

