/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.ChargebackDispute;
import com.ultracart.admin.v2.models.ChargebackDisputeResponse;
import com.ultracart.admin.v2.models.ChargebackDisputesResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ChargebackApi {
    private ApiClient apiClient;

    public ChargebackApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ChargebackApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ChargebackApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public ChargebackApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteChargebackCall(Integer chargebackDisputeOid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/chargeback/chargebacks/{chargeback_dispute_oid}".replaceAll("\\{chargeback_dispute_oid\\}", this.apiClient.escapeString(chargebackDisputeOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteChargebackValidateBeforeCall(Integer chargebackDisputeOid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (chargebackDisputeOid == null) {
            throw new ApiException("Missing the required parameter 'chargebackDisputeOid' when calling deleteChargeback(Async)");
        }
        Call call = this.deleteChargebackCall(chargebackDisputeOid, progressListener, progressRequestListener);
        return call;
    }

    public ChargebackDisputeResponse deleteChargeback(Integer chargebackDisputeOid) throws ApiException {
        ApiResponse<ChargebackDisputeResponse> resp = this.deleteChargebackWithHttpInfo(chargebackDisputeOid);
        return resp.getData();
    }

    public ApiResponse<ChargebackDisputeResponse> deleteChargebackWithHttpInfo(Integer chargebackDisputeOid) throws ApiException {
        Call call = this.deleteChargebackValidateBeforeCall(chargebackDisputeOid, null, null);
        Type localVarReturnType = new TypeToken<ChargebackDisputeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteChargebackAsync(Integer chargebackDisputeOid, final ApiCallback<ChargebackDisputeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteChargebackValidateBeforeCall(chargebackDisputeOid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ChargebackDisputeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getChargebackDisputeCall(Integer chargebackDisputeOid, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/chargeback/chargebacks/{chargeback_dispute_oid}".replaceAll("\\{chargeback_dispute_oid\\}", this.apiClient.escapeString(chargebackDisputeOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getChargebackDisputeValidateBeforeCall(Integer chargebackDisputeOid, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (chargebackDisputeOid == null) {
            throw new ApiException("Missing the required parameter 'chargebackDisputeOid' when calling getChargebackDispute(Async)");
        }
        Call call = this.getChargebackDisputeCall(chargebackDisputeOid, expand, progressListener, progressRequestListener);
        return call;
    }

    public ChargebackDisputeResponse getChargebackDispute(Integer chargebackDisputeOid, String expand) throws ApiException {
        ApiResponse<ChargebackDisputeResponse> resp = this.getChargebackDisputeWithHttpInfo(chargebackDisputeOid, expand);
        return resp.getData();
    }

    public ApiResponse<ChargebackDisputeResponse> getChargebackDisputeWithHttpInfo(Integer chargebackDisputeOid, String expand) throws ApiException {
        Call call = this.getChargebackDisputeValidateBeforeCall(chargebackDisputeOid, expand, null, null);
        Type localVarReturnType = new TypeToken<ChargebackDisputeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getChargebackDisputeAsync(Integer chargebackDisputeOid, String expand, final ApiCallback<ChargebackDisputeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getChargebackDisputeValidateBeforeCall(chargebackDisputeOid, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ChargebackDisputeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getChargebackDisputesCall(String orderId, String caseNumber, String status, String expirationDtsStart, String expirationDtsEnd, String chargebackDtsStart, String chargebackDtsEnd, Integer limit, Integer offset, String since, String sort, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/chargeback/chargebacks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (orderId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("order_id", orderId));
        }
        if (caseNumber != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("case_number", caseNumber));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (expirationDtsStart != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("expiration_dts_start", expirationDtsStart));
        }
        if (expirationDtsEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("expiration_dts_end", expirationDtsEnd));
        }
        if (chargebackDtsStart != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("chargeback_dts_start", chargebackDtsStart));
        }
        if (chargebackDtsEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("chargeback_dts_end", chargebackDtsEnd));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_since", since));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getChargebackDisputesValidateBeforeCall(String orderId, String caseNumber, String status, String expirationDtsStart, String expirationDtsEnd, String chargebackDtsStart, String chargebackDtsEnd, Integer limit, Integer offset, String since, String sort, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getChargebackDisputesCall(orderId, caseNumber, status, expirationDtsStart, expirationDtsEnd, chargebackDtsStart, chargebackDtsEnd, limit, offset, since, sort, expand, progressListener, progressRequestListener);
        return call;
    }

    public ChargebackDisputesResponse getChargebackDisputes(String orderId, String caseNumber, String status, String expirationDtsStart, String expirationDtsEnd, String chargebackDtsStart, String chargebackDtsEnd, Integer limit, Integer offset, String since, String sort, String expand) throws ApiException {
        ApiResponse<ChargebackDisputesResponse> resp = this.getChargebackDisputesWithHttpInfo(orderId, caseNumber, status, expirationDtsStart, expirationDtsEnd, chargebackDtsStart, chargebackDtsEnd, limit, offset, since, sort, expand);
        return resp.getData();
    }

    public ApiResponse<ChargebackDisputesResponse> getChargebackDisputesWithHttpInfo(String orderId, String caseNumber, String status, String expirationDtsStart, String expirationDtsEnd, String chargebackDtsStart, String chargebackDtsEnd, Integer limit, Integer offset, String since, String sort, String expand) throws ApiException {
        Call call = this.getChargebackDisputesValidateBeforeCall(orderId, caseNumber, status, expirationDtsStart, expirationDtsEnd, chargebackDtsStart, chargebackDtsEnd, limit, offset, since, sort, expand, null, null);
        Type localVarReturnType = new TypeToken<ChargebackDisputesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getChargebackDisputesAsync(String orderId, String caseNumber, String status, String expirationDtsStart, String expirationDtsEnd, String chargebackDtsStart, String chargebackDtsEnd, Integer limit, Integer offset, String since, String sort, String expand, final ApiCallback<ChargebackDisputesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getChargebackDisputesValidateBeforeCall(orderId, caseNumber, status, expirationDtsStart, expirationDtsEnd, chargebackDtsStart, chargebackDtsEnd, limit, offset, since, sort, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ChargebackDisputesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call insertChargebackCall(ChargebackDispute chargeback, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ChargebackDispute localVarPostBody = chargeback;
        String localVarPath = "/chargeback/chargebacks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call insertChargebackValidateBeforeCall(ChargebackDispute chargeback, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (chargeback == null) {
            throw new ApiException("Missing the required parameter 'chargeback' when calling insertChargeback(Async)");
        }
        Call call = this.insertChargebackCall(chargeback, expand, progressListener, progressRequestListener);
        return call;
    }

    public ChargebackDisputeResponse insertChargeback(ChargebackDispute chargeback, String expand) throws ApiException {
        ApiResponse<ChargebackDisputeResponse> resp = this.insertChargebackWithHttpInfo(chargeback, expand);
        return resp.getData();
    }

    public ApiResponse<ChargebackDisputeResponse> insertChargebackWithHttpInfo(ChargebackDispute chargeback, String expand) throws ApiException {
        Call call = this.insertChargebackValidateBeforeCall(chargeback, expand, null, null);
        Type localVarReturnType = new TypeToken<ChargebackDisputeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call insertChargebackAsync(ChargebackDispute chargeback, String expand, final ApiCallback<ChargebackDisputeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.insertChargebackValidateBeforeCall(chargeback, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ChargebackDisputeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateChargebackCall(ChargebackDispute chargeback, Integer chargebackDisputeOid, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ChargebackDispute localVarPostBody = chargeback;
        String localVarPath = "/chargeback/chargebacks/{chargeback_dispute_oid}".replaceAll("\\{chargeback_dispute_oid\\}", this.apiClient.escapeString(chargebackDisputeOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateChargebackValidateBeforeCall(ChargebackDispute chargeback, Integer chargebackDisputeOid, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (chargeback == null) {
            throw new ApiException("Missing the required parameter 'chargeback' when calling updateChargeback(Async)");
        }
        if (chargebackDisputeOid == null) {
            throw new ApiException("Missing the required parameter 'chargebackDisputeOid' when calling updateChargeback(Async)");
        }
        Call call = this.updateChargebackCall(chargeback, chargebackDisputeOid, expand, progressListener, progressRequestListener);
        return call;
    }

    public ChargebackDisputeResponse updateChargeback(ChargebackDispute chargeback, Integer chargebackDisputeOid, String expand) throws ApiException {
        ApiResponse<ChargebackDisputeResponse> resp = this.updateChargebackWithHttpInfo(chargeback, chargebackDisputeOid, expand);
        return resp.getData();
    }

    public ApiResponse<ChargebackDisputeResponse> updateChargebackWithHttpInfo(ChargebackDispute chargeback, Integer chargebackDisputeOid, String expand) throws ApiException {
        Call call = this.updateChargebackValidateBeforeCall(chargeback, chargebackDisputeOid, expand, null, null);
        Type localVarReturnType = new TypeToken<ChargebackDisputeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateChargebackAsync(ChargebackDispute chargeback, Integer chargebackDisputeOid, String expand, final ApiCallback<ChargebackDisputeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateChargebackValidateBeforeCall(chargeback, chargebackDisputeOid, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ChargebackDisputeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

