/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.ChannelPartnerCancelResponse;
import com.ultracart.admin.v2.models.ChannelPartnerEstimateShippingResponse;
import com.ultracart.admin.v2.models.ChannelPartnerImportResponse;
import com.ultracart.admin.v2.models.ChannelPartnerOrder;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ChannelPartnerApi {
    private ApiClient apiClient;

    public ChannelPartnerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ChannelPartnerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ChannelPartnerApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public ChannelPartnerApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call cancelOrderByChannelPartnerOrderIdCall(String orderId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/channel_partner/cancel/by_channel_partner_order_id/{order_id}".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call cancelOrderByChannelPartnerOrderIdValidateBeforeCall(String orderId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelOrderByChannelPartnerOrderId(Async)");
        }
        Call call = this.cancelOrderByChannelPartnerOrderIdCall(orderId, progressListener, progressRequestListener);
        return call;
    }

    public ChannelPartnerCancelResponse cancelOrderByChannelPartnerOrderId(String orderId) throws ApiException {
        ApiResponse<ChannelPartnerCancelResponse> resp = this.cancelOrderByChannelPartnerOrderIdWithHttpInfo(orderId);
        return resp.getData();
    }

    public ApiResponse<ChannelPartnerCancelResponse> cancelOrderByChannelPartnerOrderIdWithHttpInfo(String orderId) throws ApiException {
        Call call = this.cancelOrderByChannelPartnerOrderIdValidateBeforeCall(orderId, null, null);
        Type localVarReturnType = new TypeToken<ChannelPartnerCancelResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call cancelOrderByChannelPartnerOrderIdAsync(String orderId, final ApiCallback<ChannelPartnerCancelResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.cancelOrderByChannelPartnerOrderIdValidateBeforeCall(orderId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ChannelPartnerCancelResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call cancelOrderByUltraCartOrderIdCall(String orderId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/channel_partner/cancel/by_ultracart_order_id/{order_id}".replaceAll("\\{order_id\\}", this.apiClient.escapeString(orderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call cancelOrderByUltraCartOrderIdValidateBeforeCall(String orderId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelOrderByUltraCartOrderId(Async)");
        }
        Call call = this.cancelOrderByUltraCartOrderIdCall(orderId, progressListener, progressRequestListener);
        return call;
    }

    public ChannelPartnerCancelResponse cancelOrderByUltraCartOrderId(String orderId) throws ApiException {
        ApiResponse<ChannelPartnerCancelResponse> resp = this.cancelOrderByUltraCartOrderIdWithHttpInfo(orderId);
        return resp.getData();
    }

    public ApiResponse<ChannelPartnerCancelResponse> cancelOrderByUltraCartOrderIdWithHttpInfo(String orderId) throws ApiException {
        Call call = this.cancelOrderByUltraCartOrderIdValidateBeforeCall(orderId, null, null);
        Type localVarReturnType = new TypeToken<ChannelPartnerCancelResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call cancelOrderByUltraCartOrderIdAsync(String orderId, final ApiCallback<ChannelPartnerCancelResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.cancelOrderByUltraCartOrderIdValidateBeforeCall(orderId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ChannelPartnerCancelResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call estimateShippingForChannelPartnerOrderCall(ChannelPartnerOrder channelPartnerOrder, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ChannelPartnerOrder localVarPostBody = channelPartnerOrder;
        String localVarPath = "/channel_partner/estimate_shipping";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call estimateShippingForChannelPartnerOrderValidateBeforeCall(ChannelPartnerOrder channelPartnerOrder, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (channelPartnerOrder == null) {
            throw new ApiException("Missing the required parameter 'channelPartnerOrder' when calling estimateShippingForChannelPartnerOrder(Async)");
        }
        Call call = this.estimateShippingForChannelPartnerOrderCall(channelPartnerOrder, progressListener, progressRequestListener);
        return call;
    }

    public ChannelPartnerEstimateShippingResponse estimateShippingForChannelPartnerOrder(ChannelPartnerOrder channelPartnerOrder) throws ApiException {
        ApiResponse<ChannelPartnerEstimateShippingResponse> resp = this.estimateShippingForChannelPartnerOrderWithHttpInfo(channelPartnerOrder);
        return resp.getData();
    }

    public ApiResponse<ChannelPartnerEstimateShippingResponse> estimateShippingForChannelPartnerOrderWithHttpInfo(ChannelPartnerOrder channelPartnerOrder) throws ApiException {
        Call call = this.estimateShippingForChannelPartnerOrderValidateBeforeCall(channelPartnerOrder, null, null);
        Type localVarReturnType = new TypeToken<ChannelPartnerEstimateShippingResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call estimateShippingForChannelPartnerOrderAsync(ChannelPartnerOrder channelPartnerOrder, final ApiCallback<ChannelPartnerEstimateShippingResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.estimateShippingForChannelPartnerOrderValidateBeforeCall(channelPartnerOrder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ChannelPartnerEstimateShippingResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call importChannelPartnerOrderCall(ChannelPartnerOrder channelPartnerOrder, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ChannelPartnerOrder localVarPostBody = channelPartnerOrder;
        String localVarPath = "/channel_partner/import";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call importChannelPartnerOrderValidateBeforeCall(ChannelPartnerOrder channelPartnerOrder, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (channelPartnerOrder == null) {
            throw new ApiException("Missing the required parameter 'channelPartnerOrder' when calling importChannelPartnerOrder(Async)");
        }
        Call call = this.importChannelPartnerOrderCall(channelPartnerOrder, progressListener, progressRequestListener);
        return call;
    }

    public ChannelPartnerImportResponse importChannelPartnerOrder(ChannelPartnerOrder channelPartnerOrder) throws ApiException {
        ApiResponse<ChannelPartnerImportResponse> resp = this.importChannelPartnerOrderWithHttpInfo(channelPartnerOrder);
        return resp.getData();
    }

    public ApiResponse<ChannelPartnerImportResponse> importChannelPartnerOrderWithHttpInfo(ChannelPartnerOrder channelPartnerOrder) throws ApiException {
        Call call = this.importChannelPartnerOrderValidateBeforeCall(channelPartnerOrder, null, null);
        Type localVarReturnType = new TypeToken<ChannelPartnerImportResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call importChannelPartnerOrderAsync(ChannelPartnerOrder channelPartnerOrder, final ApiCallback<ChannelPartnerImportResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.importChannelPartnerOrderValidateBeforeCall(channelPartnerOrder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ChannelPartnerImportResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

