/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.AutoOrder;
import com.ultracart.admin.v2.models.AutoOrderQuery;
import com.ultracart.admin.v2.models.AutoOrderQueryBatch;
import com.ultracart.admin.v2.models.AutoOrderResponse;
import com.ultracart.admin.v2.models.AutoOrdersRequest;
import com.ultracart.admin.v2.models.AutoOrdersResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AutoOrderApi {
    private ApiClient apiClient;

    public AutoOrderApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AutoOrderApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AutoOrderApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public AutoOrderApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getAutoOrderCall(Integer autoOrderOid, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/auto_order/auto_orders/{auto_order_oid}".replaceAll("\\{auto_order_oid\\}", this.apiClient.escapeString(autoOrderOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAutoOrderValidateBeforeCall(Integer autoOrderOid, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (autoOrderOid == null) {
            throw new ApiException("Missing the required parameter 'autoOrderOid' when calling getAutoOrder(Async)");
        }
        Call call = this.getAutoOrderCall(autoOrderOid, expand, progressListener, progressRequestListener);
        return call;
    }

    public AutoOrderResponse getAutoOrder(Integer autoOrderOid, String expand) throws ApiException {
        ApiResponse<AutoOrderResponse> resp = this.getAutoOrderWithHttpInfo(autoOrderOid, expand);
        return resp.getData();
    }

    public ApiResponse<AutoOrderResponse> getAutoOrderWithHttpInfo(Integer autoOrderOid, String expand) throws ApiException {
        Call call = this.getAutoOrderValidateBeforeCall(autoOrderOid, expand, null, null);
        Type localVarReturnType = new TypeToken<AutoOrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAutoOrderAsync(Integer autoOrderOid, String expand, final ApiCallback<AutoOrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAutoOrderValidateBeforeCall(autoOrderOid, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AutoOrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAutoOrderByCodeCall(String autoOrderCode, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/auto_order/auto_orders/code/{auto_order_code}".replaceAll("\\{auto_order_code\\}", this.apiClient.escapeString(autoOrderCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAutoOrderByCodeValidateBeforeCall(String autoOrderCode, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (autoOrderCode == null) {
            throw new ApiException("Missing the required parameter 'autoOrderCode' when calling getAutoOrderByCode(Async)");
        }
        Call call = this.getAutoOrderByCodeCall(autoOrderCode, expand, progressListener, progressRequestListener);
        return call;
    }

    public AutoOrderResponse getAutoOrderByCode(String autoOrderCode, String expand) throws ApiException {
        ApiResponse<AutoOrderResponse> resp = this.getAutoOrderByCodeWithHttpInfo(autoOrderCode, expand);
        return resp.getData();
    }

    public ApiResponse<AutoOrderResponse> getAutoOrderByCodeWithHttpInfo(String autoOrderCode, String expand) throws ApiException {
        Call call = this.getAutoOrderByCodeValidateBeforeCall(autoOrderCode, expand, null, null);
        Type localVarReturnType = new TypeToken<AutoOrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAutoOrderByCodeAsync(String autoOrderCode, String expand, final ApiCallback<AutoOrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAutoOrderByCodeValidateBeforeCall(autoOrderCode, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AutoOrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAutoOrderByReferenceOrderIdCall(String referenceOrderId, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/auto_order/auto_orders/reference_order_id/{reference_order_id}".replaceAll("\\{reference_order_id\\}", this.apiClient.escapeString(referenceOrderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAutoOrderByReferenceOrderIdValidateBeforeCall(String referenceOrderId, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (referenceOrderId == null) {
            throw new ApiException("Missing the required parameter 'referenceOrderId' when calling getAutoOrderByReferenceOrderId(Async)");
        }
        Call call = this.getAutoOrderByReferenceOrderIdCall(referenceOrderId, expand, progressListener, progressRequestListener);
        return call;
    }

    public AutoOrderResponse getAutoOrderByReferenceOrderId(String referenceOrderId, String expand) throws ApiException {
        ApiResponse<AutoOrderResponse> resp = this.getAutoOrderByReferenceOrderIdWithHttpInfo(referenceOrderId, expand);
        return resp.getData();
    }

    public ApiResponse<AutoOrderResponse> getAutoOrderByReferenceOrderIdWithHttpInfo(String referenceOrderId, String expand) throws ApiException {
        Call call = this.getAutoOrderByReferenceOrderIdValidateBeforeCall(referenceOrderId, expand, null, null);
        Type localVarReturnType = new TypeToken<AutoOrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAutoOrderByReferenceOrderIdAsync(String referenceOrderId, String expand, final ApiCallback<AutoOrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAutoOrderByReferenceOrderIdValidateBeforeCall(referenceOrderId, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AutoOrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAutoOrdersCall(String autoOrderCode, String originalOrderId, String firstName, String lastName, String company, String city, String state, String postalCode, String countryCode, String phone, String email, String originalOrderDateBegin, String originalOrderDateEnd, String nextShipmentDateBegin, String nextShipmentDateEnd, String cardType, String itemId, String status, Integer limit, Integer offset, String since, String sort, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/auto_order/auto_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (autoOrderCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("auto_order_code", autoOrderCode));
        }
        if (originalOrderId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("original_order_id", originalOrderId));
        }
        if (firstName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("first_name", firstName));
        }
        if (lastName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("last_name", lastName));
        }
        if (company != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("company", company));
        }
        if (city != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("city", city));
        }
        if (state != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("state", state));
        }
        if (postalCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("postal_code", postalCode));
        }
        if (countryCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("country_code", countryCode));
        }
        if (phone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("phone", phone));
        }
        if (email != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", email));
        }
        if (originalOrderDateBegin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("original_order_date_begin", originalOrderDateBegin));
        }
        if (originalOrderDateEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("original_order_date_end", originalOrderDateEnd));
        }
        if (nextShipmentDateBegin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("next_shipment_date_begin", nextShipmentDateBegin));
        }
        if (nextShipmentDateEnd != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("next_shipment_date_end", nextShipmentDateEnd));
        }
        if (cardType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("card_type", cardType));
        }
        if (itemId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("item_id", itemId));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_since", since));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAutoOrdersValidateBeforeCall(String autoOrderCode, String originalOrderId, String firstName, String lastName, String company, String city, String state, String postalCode, String countryCode, String phone, String email, String originalOrderDateBegin, String originalOrderDateEnd, String nextShipmentDateBegin, String nextShipmentDateEnd, String cardType, String itemId, String status, Integer limit, Integer offset, String since, String sort, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAutoOrdersCall(autoOrderCode, originalOrderId, firstName, lastName, company, city, state, postalCode, countryCode, phone, email, originalOrderDateBegin, originalOrderDateEnd, nextShipmentDateBegin, nextShipmentDateEnd, cardType, itemId, status, limit, offset, since, sort, expand, progressListener, progressRequestListener);
        return call;
    }

    public AutoOrdersResponse getAutoOrders(String autoOrderCode, String originalOrderId, String firstName, String lastName, String company, String city, String state, String postalCode, String countryCode, String phone, String email, String originalOrderDateBegin, String originalOrderDateEnd, String nextShipmentDateBegin, String nextShipmentDateEnd, String cardType, String itemId, String status, Integer limit, Integer offset, String since, String sort, String expand) throws ApiException {
        ApiResponse<AutoOrdersResponse> resp = this.getAutoOrdersWithHttpInfo(autoOrderCode, originalOrderId, firstName, lastName, company, city, state, postalCode, countryCode, phone, email, originalOrderDateBegin, originalOrderDateEnd, nextShipmentDateBegin, nextShipmentDateEnd, cardType, itemId, status, limit, offset, since, sort, expand);
        return resp.getData();
    }

    public ApiResponse<AutoOrdersResponse> getAutoOrdersWithHttpInfo(String autoOrderCode, String originalOrderId, String firstName, String lastName, String company, String city, String state, String postalCode, String countryCode, String phone, String email, String originalOrderDateBegin, String originalOrderDateEnd, String nextShipmentDateBegin, String nextShipmentDateEnd, String cardType, String itemId, String status, Integer limit, Integer offset, String since, String sort, String expand) throws ApiException {
        Call call = this.getAutoOrdersValidateBeforeCall(autoOrderCode, originalOrderId, firstName, lastName, company, city, state, postalCode, countryCode, phone, email, originalOrderDateBegin, originalOrderDateEnd, nextShipmentDateBegin, nextShipmentDateEnd, cardType, itemId, status, limit, offset, since, sort, expand, null, null);
        Type localVarReturnType = new TypeToken<AutoOrdersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAutoOrdersAsync(String autoOrderCode, String originalOrderId, String firstName, String lastName, String company, String city, String state, String postalCode, String countryCode, String phone, String email, String originalOrderDateBegin, String originalOrderDateEnd, String nextShipmentDateBegin, String nextShipmentDateEnd, String cardType, String itemId, String status, Integer limit, Integer offset, String since, String sort, String expand, final ApiCallback<AutoOrdersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAutoOrdersValidateBeforeCall(autoOrderCode, originalOrderId, firstName, lastName, company, city, state, postalCode, countryCode, phone, email, originalOrderDateBegin, originalOrderDateEnd, nextShipmentDateBegin, nextShipmentDateEnd, cardType, itemId, status, limit, offset, since, sort, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AutoOrdersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAutoOrdersBatchCall(AutoOrderQueryBatch autoOrderBatch, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AutoOrderQueryBatch localVarPostBody = autoOrderBatch;
        String localVarPath = "/auto_order/auto_orders/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAutoOrdersBatchValidateBeforeCall(AutoOrderQueryBatch autoOrderBatch, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (autoOrderBatch == null) {
            throw new ApiException("Missing the required parameter 'autoOrderBatch' when calling getAutoOrdersBatch(Async)");
        }
        Call call = this.getAutoOrdersBatchCall(autoOrderBatch, expand, progressListener, progressRequestListener);
        return call;
    }

    public AutoOrdersResponse getAutoOrdersBatch(AutoOrderQueryBatch autoOrderBatch, String expand) throws ApiException {
        ApiResponse<AutoOrdersResponse> resp = this.getAutoOrdersBatchWithHttpInfo(autoOrderBatch, expand);
        return resp.getData();
    }

    public ApiResponse<AutoOrdersResponse> getAutoOrdersBatchWithHttpInfo(AutoOrderQueryBatch autoOrderBatch, String expand) throws ApiException {
        Call call = this.getAutoOrdersBatchValidateBeforeCall(autoOrderBatch, expand, null, null);
        Type localVarReturnType = new TypeToken<AutoOrdersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAutoOrdersBatchAsync(AutoOrderQueryBatch autoOrderBatch, String expand, final ApiCallback<AutoOrdersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAutoOrdersBatchValidateBeforeCall(autoOrderBatch, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AutoOrdersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAutoOrdersByQueryCall(AutoOrderQuery autoOrderQuery, Integer limit, Integer offset, String sort, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AutoOrderQuery localVarPostBody = autoOrderQuery;
        String localVarPath = "/auto_order/auto_orders/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAutoOrdersByQueryValidateBeforeCall(AutoOrderQuery autoOrderQuery, Integer limit, Integer offset, String sort, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (autoOrderQuery == null) {
            throw new ApiException("Missing the required parameter 'autoOrderQuery' when calling getAutoOrdersByQuery(Async)");
        }
        Call call = this.getAutoOrdersByQueryCall(autoOrderQuery, limit, offset, sort, expand, progressListener, progressRequestListener);
        return call;
    }

    public AutoOrdersResponse getAutoOrdersByQuery(AutoOrderQuery autoOrderQuery, Integer limit, Integer offset, String sort, String expand) throws ApiException {
        ApiResponse<AutoOrdersResponse> resp = this.getAutoOrdersByQueryWithHttpInfo(autoOrderQuery, limit, offset, sort, expand);
        return resp.getData();
    }

    public ApiResponse<AutoOrdersResponse> getAutoOrdersByQueryWithHttpInfo(AutoOrderQuery autoOrderQuery, Integer limit, Integer offset, String sort, String expand) throws ApiException {
        Call call = this.getAutoOrdersByQueryValidateBeforeCall(autoOrderQuery, limit, offset, sort, expand, null, null);
        Type localVarReturnType = new TypeToken<AutoOrdersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAutoOrdersByQueryAsync(AutoOrderQuery autoOrderQuery, Integer limit, Integer offset, String sort, String expand, final ApiCallback<AutoOrdersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAutoOrdersByQueryValidateBeforeCall(autoOrderQuery, limit, offset, sort, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AutoOrdersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateAutoOrderCall(AutoOrder autoOrder, Integer autoOrderOid, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AutoOrder localVarPostBody = autoOrder;
        String localVarPath = "/auto_order/auto_orders/{auto_order_oid}".replaceAll("\\{auto_order_oid\\}", this.apiClient.escapeString(autoOrderOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateAutoOrderValidateBeforeCall(AutoOrder autoOrder, Integer autoOrderOid, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (autoOrder == null) {
            throw new ApiException("Missing the required parameter 'autoOrder' when calling updateAutoOrder(Async)");
        }
        if (autoOrderOid == null) {
            throw new ApiException("Missing the required parameter 'autoOrderOid' when calling updateAutoOrder(Async)");
        }
        Call call = this.updateAutoOrderCall(autoOrder, autoOrderOid, expand, progressListener, progressRequestListener);
        return call;
    }

    public AutoOrderResponse updateAutoOrder(AutoOrder autoOrder, Integer autoOrderOid, String expand) throws ApiException {
        ApiResponse<AutoOrderResponse> resp = this.updateAutoOrderWithHttpInfo(autoOrder, autoOrderOid, expand);
        return resp.getData();
    }

    public ApiResponse<AutoOrderResponse> updateAutoOrderWithHttpInfo(AutoOrder autoOrder, Integer autoOrderOid, String expand) throws ApiException {
        Call call = this.updateAutoOrderValidateBeforeCall(autoOrder, autoOrderOid, expand, null, null);
        Type localVarReturnType = new TypeToken<AutoOrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAutoOrderAsync(AutoOrder autoOrder, Integer autoOrderOid, String expand, final ApiCallback<AutoOrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateAutoOrderValidateBeforeCall(autoOrder, autoOrderOid, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AutoOrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateAutoOrdersBatchCall(AutoOrdersRequest autoOrdersRequest, String expand, Boolean placeholders, Boolean async, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AutoOrdersRequest localVarPostBody = autoOrdersRequest;
        String localVarPath = "/auto_order/auto_orders/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        if (placeholders != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_placeholders", placeholders));
        }
        if (async != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_async", async));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateAutoOrdersBatchValidateBeforeCall(AutoOrdersRequest autoOrdersRequest, String expand, Boolean placeholders, Boolean async, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (autoOrdersRequest == null) {
            throw new ApiException("Missing the required parameter 'autoOrdersRequest' when calling updateAutoOrdersBatch(Async)");
        }
        Call call = this.updateAutoOrdersBatchCall(autoOrdersRequest, expand, placeholders, async, progressListener, progressRequestListener);
        return call;
    }

    public AutoOrdersResponse updateAutoOrdersBatch(AutoOrdersRequest autoOrdersRequest, String expand, Boolean placeholders, Boolean async) throws ApiException {
        ApiResponse<AutoOrdersResponse> resp = this.updateAutoOrdersBatchWithHttpInfo(autoOrdersRequest, expand, placeholders, async);
        return resp.getData();
    }

    public ApiResponse<AutoOrdersResponse> updateAutoOrdersBatchWithHttpInfo(AutoOrdersRequest autoOrdersRequest, String expand, Boolean placeholders, Boolean async) throws ApiException {
        Call call = this.updateAutoOrdersBatchValidateBeforeCall(autoOrdersRequest, expand, placeholders, async, null, null);
        Type localVarReturnType = new TypeToken<AutoOrdersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateAutoOrdersBatchAsync(AutoOrdersRequest autoOrdersRequest, String expand, Boolean placeholders, Boolean async, final ApiCallback<AutoOrdersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateAutoOrdersBatchValidateBeforeCall(autoOrdersRequest, expand, placeholders, async, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AutoOrdersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

