/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.AffiliateClickQuery;
import com.ultracart.admin.v2.models.AffiliateClicksResponse;
import com.ultracart.admin.v2.models.AffiliateLedgerQuery;
import com.ultracart.admin.v2.models.AffiliateLedgersResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class AffiliateApi {
    private ApiClient apiClient;

    public AffiliateApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AffiliateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AffiliateApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public AffiliateApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getClicksByQueryCall(AffiliateClickQuery clickQuery, Integer limit, Integer offset, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AffiliateClickQuery localVarPostBody = clickQuery;
        String localVarPath = "/affiliate/clicks/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getClicksByQueryValidateBeforeCall(AffiliateClickQuery clickQuery, Integer limit, Integer offset, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clickQuery == null) {
            throw new ApiException("Missing the required parameter 'clickQuery' when calling getClicksByQuery(Async)");
        }
        Call call = this.getClicksByQueryCall(clickQuery, limit, offset, expand, progressListener, progressRequestListener);
        return call;
    }

    public AffiliateClicksResponse getClicksByQuery(AffiliateClickQuery clickQuery, Integer limit, Integer offset, String expand) throws ApiException {
        ApiResponse<AffiliateClicksResponse> resp = this.getClicksByQueryWithHttpInfo(clickQuery, limit, offset, expand);
        return resp.getData();
    }

    public ApiResponse<AffiliateClicksResponse> getClicksByQueryWithHttpInfo(AffiliateClickQuery clickQuery, Integer limit, Integer offset, String expand) throws ApiException {
        Call call = this.getClicksByQueryValidateBeforeCall(clickQuery, limit, offset, expand, null, null);
        Type localVarReturnType = new TypeToken<AffiliateClicksResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getClicksByQueryAsync(AffiliateClickQuery clickQuery, Integer limit, Integer offset, String expand, final ApiCallback<AffiliateClicksResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getClicksByQueryValidateBeforeCall(clickQuery, limit, offset, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AffiliateClicksResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getLedgersByQueryCall(AffiliateLedgerQuery ledgerQuery, Integer limit, Integer offset, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AffiliateLedgerQuery localVarPostBody = ledgerQuery;
        String localVarPath = "/affiliate/ledgers/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getLedgersByQueryValidateBeforeCall(AffiliateLedgerQuery ledgerQuery, Integer limit, Integer offset, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (ledgerQuery == null) {
            throw new ApiException("Missing the required parameter 'ledgerQuery' when calling getLedgersByQuery(Async)");
        }
        Call call = this.getLedgersByQueryCall(ledgerQuery, limit, offset, expand, progressListener, progressRequestListener);
        return call;
    }

    public AffiliateLedgersResponse getLedgersByQuery(AffiliateLedgerQuery ledgerQuery, Integer limit, Integer offset, String expand) throws ApiException {
        ApiResponse<AffiliateLedgersResponse> resp = this.getLedgersByQueryWithHttpInfo(ledgerQuery, limit, offset, expand);
        return resp.getData();
    }

    public ApiResponse<AffiliateLedgersResponse> getLedgersByQueryWithHttpInfo(AffiliateLedgerQuery ledgerQuery, Integer limit, Integer offset, String expand) throws ApiException {
        Call call = this.getLedgersByQueryValidateBeforeCall(ledgerQuery, limit, offset, expand, null, null);
        Type localVarReturnType = new TypeToken<AffiliateLedgersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getLedgersByQueryAsync(AffiliateLedgerQuery ledgerQuery, Integer limit, Integer offset, String expand, final ApiCallback<AffiliateLedgersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getLedgersByQueryValidateBeforeCall(ledgerQuery, limit, offset, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AffiliateLedgersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

