/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ullink.slack.simpleslackapi.SlackPresence;
import com.ullink.slack.simpleslackapi.SlackPresenceSerDes;
import com.ullink.slack.simpleslackapi.blocks.Block;
import com.ullink.slack.simpleslackapi.blocks.BlockSerDes;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;

public class SlackResponseHandler<T>
implements ResponseHandler<T> {
    private final Gson gson;
    private Class<T> reference;

    public SlackResponseHandler(Class<T> reference) {
        this.reference = reference;
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(SlackPresence.class, (Object)new SlackPresenceSerDes());
        builder.registerTypeAdapter(Block.class, (Object)new BlockSerDes());
        this.gson = builder.create();
    }

    public T handleResponse(HttpResponse response) throws IOException {
        String json = this.consumeToString(response.getEntity().getContent());
        return (T)this.gson.fromJson(json, this.reference);
    }

    private String consumeToString(InputStream content) throws IOException {
        int numread;
        InputStreamReader reader = new InputStreamReader(content, StandardCharsets.UTF_8);
        StringBuilder buf = new StringBuilder();
        char[] data = new char[16384];
        while (0 <= (numread = reader.read(data))) {
            buf.append(data, 0, numread);
        }
        return buf.toString();
    }
}

