/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.blocks.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.ullink.slack.simpleslackapi.blocks.ContextElement;
import com.ullink.slack.simpleslackapi.blocks.ContextElementSerDes;
import com.ullink.slack.simpleslackapi.blocks.actions.Action;
import com.ullink.slack.simpleslackapi.blocks.actions.ActionType;
import com.ullink.slack.simpleslackapi.blocks.actions.Button;
import com.ullink.slack.simpleslackapi.blocks.actions.ChannelsSelect;
import com.ullink.slack.simpleslackapi.blocks.actions.ConversationsSelect;
import com.ullink.slack.simpleslackapi.blocks.actions.DatePicker;
import com.ullink.slack.simpleslackapi.blocks.actions.ExternalSelect;
import com.ullink.slack.simpleslackapi.blocks.actions.MultiChannelsSelect;
import com.ullink.slack.simpleslackapi.blocks.actions.MultiConversationsSelect;
import com.ullink.slack.simpleslackapi.blocks.actions.MultiExternalSelect;
import com.ullink.slack.simpleslackapi.blocks.actions.MultiStaticSelect;
import com.ullink.slack.simpleslackapi.blocks.actions.MultiUsersSelect;
import com.ullink.slack.simpleslackapi.blocks.actions.OverflowMenu;
import com.ullink.slack.simpleslackapi.blocks.actions.PlaintextInput;
import com.ullink.slack.simpleslackapi.blocks.actions.RadioButtonGroup;
import com.ullink.slack.simpleslackapi.blocks.actions.StaticSelect;
import com.ullink.slack.simpleslackapi.blocks.actions.UsersSelect;
import com.ullink.slack.simpleslackapi.blocks.compositions.Image;
import java.lang.reflect.Type;

public class ActionSerDes
implements JsonSerializer<Action>,
JsonDeserializer<Action> {
    private Gson gson;

    public ActionSerDes() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ContextElement.class, (Object)new ContextElementSerDes());
        this.gson = builder.create();
    }

    public Action deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String type = json.getAsJsonObject().get("type").getAsString();
        ActionType actionType = ActionType.valueOf(type.toUpperCase());
        switch (actionType) {
            case BUTTON: {
                return (Action)this.gson.fromJson(json, Button.class);
            }
            case DATEPICKER: {
                return (Action)this.gson.fromJson(json, DatePicker.class);
            }
            case IMAGE: {
                return (Action)this.gson.fromJson(json, Image.class);
            }
            case OVERFLOW: {
                return (Action)this.gson.fromJson(json, OverflowMenu.class);
            }
            case RADIO_BUTTONS: {
                return (Action)this.gson.fromJson(json, RadioButtonGroup.class);
            }
            case PLAIN_TEXT_INPUT: {
                return (Action)this.gson.fromJson(json, PlaintextInput.class);
            }
            case MULTI_STATIC_SELECT: {
                return (Action)this.gson.fromJson(json, MultiStaticSelect.class);
            }
            case MULTI_USERS_SELECT: {
                return (Action)this.gson.fromJson(json, MultiUsersSelect.class);
            }
            case MULTI_EXTERNAL_SELECT: {
                return (Action)this.gson.fromJson(json, MultiExternalSelect.class);
            }
            case MULTI_CONVERSATIONS_SELECT: {
                return (Action)this.gson.fromJson(json, MultiConversationsSelect.class);
            }
            case MULTI_CHANNELS_SELECT: {
                return (Action)this.gson.fromJson(json, MultiChannelsSelect.class);
            }
            case STATIC_SELECT: {
                return (Action)this.gson.fromJson(json, StaticSelect.class);
            }
            case USERS_SELECT: {
                return (Action)this.gson.fromJson(json, UsersSelect.class);
            }
            case EXTERNAL_SELECT: {
                return (Action)this.gson.fromJson(json, ExternalSelect.class);
            }
            case CONVERSATIONS_SELECT: {
                return (Action)this.gson.fromJson(json, ConversationsSelect.class);
            }
            case CHANNELS_SELECT: {
                return (Action)this.gson.fromJson(json, ChannelsSelect.class);
            }
        }
        throw new IllegalArgumentException(type);
    }

    public JsonElement serialize(Action src, Type typeOfSrc, JsonSerializationContext context) {
        return this.gson.toJsonTree((Object)src);
    }
}

