/*
 * Decompiled with CFR 0.152.
 */
package com.ullink.slack.simpleslackapi.blocks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.ullink.slack.simpleslackapi.blocks.Actions;
import com.ullink.slack.simpleslackapi.blocks.Block;
import com.ullink.slack.simpleslackapi.blocks.BlockType;
import com.ullink.slack.simpleslackapi.blocks.Context;
import com.ullink.slack.simpleslackapi.blocks.ContextElement;
import com.ullink.slack.simpleslackapi.blocks.ContextElementSerDes;
import com.ullink.slack.simpleslackapi.blocks.Divider;
import com.ullink.slack.simpleslackapi.blocks.File;
import com.ullink.slack.simpleslackapi.blocks.Image;
import com.ullink.slack.simpleslackapi.blocks.Input;
import com.ullink.slack.simpleslackapi.blocks.Section;
import com.ullink.slack.simpleslackapi.blocks.actions.Action;
import com.ullink.slack.simpleslackapi.blocks.actions.ActionSerDes;
import com.ullink.slack.simpleslackapi.blocks.actions.ActionsElement;
import com.ullink.slack.simpleslackapi.blocks.actions.InputElement;
import com.ullink.slack.simpleslackapi.blocks.actions.SectionElement;
import com.ullink.slack.simpleslackapi.blocks.compositions.Text;
import java.lang.reflect.Type;

public class BlockSerDes
implements JsonDeserializer<Block>,
JsonSerializer<Block> {
    private Gson gson;

    public BlockSerDes() {
        GsonBuilder builder = new GsonBuilder();
        ActionSerDes actionSerializer = new ActionSerDes();
        builder.registerTypeAdapter(Action.class, (Object)actionSerializer);
        builder.registerTypeAdapter(ActionsElement.class, (Object)actionSerializer);
        builder.registerTypeAdapter(SectionElement.class, (Object)actionSerializer);
        builder.registerTypeAdapter(InputElement.class, (Object)actionSerializer);
        ContextElementSerDes ContextElementSerializer = new ContextElementSerDes();
        builder.registerTypeAdapter(ContextElement.class, (Object)ContextElementSerializer);
        builder.registerTypeAdapter(Text.class, (Object)ContextElementSerializer);
        this.gson = builder.create();
    }

    public Block deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String type = json.getAsJsonObject().get("type").getAsString();
        BlockType blockType = BlockType.valueOf(type.toUpperCase());
        switch (blockType) {
            case CONTEXT: {
                return (Block)this.gson.fromJson(json, Context.class);
            }
            case IMAGE: {
                return (Block)this.gson.fromJson(json, Image.class);
            }
            case FILE: {
                return (Block)this.gson.fromJson(json, File.class);
            }
            case DIVIDER: {
                return (Block)this.gson.fromJson(json, Divider.class);
            }
            case INPUT: {
                return (Block)this.gson.fromJson(json, Input.class);
            }
            case SECTION: {
                return (Block)this.gson.fromJson(json, Section.class);
            }
            case ACTIONS: {
                return (Block)this.gson.fromJson(json, Actions.class);
            }
        }
        throw new IllegalArgumentException(type);
    }

    public JsonElement serialize(Block src, Type typeOfSrc, JsonSerializationContext context) {
        return this.gson.toJsonTree((Object)src);
    }
}

