/*
 * Decompiled with CFR 0.152.
 */
package com.ullink;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.javadoc.Main;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class IKVMDocLet
extends Doclet {
    private static final Map<String, String> DATA_TYPE_MAPPING = new HashMap<String, String>();
    private static final String ASSEMBLY_PARAMETER = "-assembly";
    private static final String HTML_PARAMETER = "-nohtml";
    private static final String STRICT_FINAL_FIELD_SEMANTICS_PARAMETER = "-strictfinalfieldsemantics";
    private static final String AUTHOR_PARAMETER = "-author";
    private static final String DEPRECATED_PARAMETER = "-nodeprecated";
    private static final String SINCE_PARAMETER = "-nosince";
    private static final String VERSION_PARAMETER = "-version";
    private static File ASSEMBLY_FILE;
    private static boolean OUTPUT_HTML;
    private static boolean OUTPUT_AUTHOR;
    private static boolean OUTPUT_DEPRECATED;
    private static boolean OUTPUT_SINCE;
    private static boolean OUTPUT_VERSION;
    private static DocErrorReporter ERROR_REPORTER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc root) {
        String assemblyName = ASSEMBLY_FILE.getName();
        int extensionIndex = assemblyName.lastIndexOf(46);
        if (extensionIndex != -1) {
            assemblyName = assemblyName.substring(0, extensionIndex);
        }
        File documentationFile = new File(ASSEMBLY_FILE.getParent(), assemblyName + ".xml");
        PrintWriter pw = null;
        try {
            ClassDoc[] classes;
            FileOutputStream fos = new FileOutputStream(documentationFile);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            BufferedWriter bw = new BufferedWriter(osw);
            pw = new PrintWriter(bw);
            pw.println("<?xml version=\"1.0\"?>");
            pw.println("<doc>");
            IKVMDocLet.printIndent(pw, 1);
            pw.println("<assembly>");
            IKVMDocLet.printIndent(pw, 2);
            pw.print("<name>");
            pw.print(assemblyName);
            pw.println("</name>");
            IKVMDocLet.printIndent(pw, 1);
            pw.println("</assembly>");
            IKVMDocLet.printIndent(pw, 1);
            pw.println("<members>");
            for (ClassDoc classDoc : classes = root.classes()) {
                IKVMDocLet.print(pw, (ProgramElementDoc)classDoc);
            }
            IKVMDocLet.printIndent(pw, 1);
            pw.println("</members>");
            pw.println("</doc>");
            pw.close();
            IKVMDocLet.validate(documentationFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        return true;
    }

    private static void print(PrintWriter pw, ProgramElementDoc programElementDoc) {
        if (programElementDoc.tags("@exclude").length > 0) {
            return;
        }
        IKVMDocLet.printIndent(pw, 2);
        pw.print("<member name=\"");
        IKVMDocLet.printReference(pw, programElementDoc, true);
        pw.println("\">");
        IKVMDocLet.printIndent(pw, 3);
        pw.print("<summary>");
        if (OUTPUT_DEPRECATED) {
            IKVMDocLet.printTags(pw, programElementDoc, "DEPRECATED:", "@deprecated");
        }
        IKVMDocLet.printComment(pw, programElementDoc, programElementDoc.inlineTags());
        if (OUTPUT_AUTHOR) {
            IKVMDocLet.printTags(pw, programElementDoc, "Author:", "@author");
        }
        if (OUTPUT_VERSION) {
            IKVMDocLet.printTags(pw, programElementDoc, "Version:", "@version");
        }
        if (OUTPUT_SINCE) {
            IKVMDocLet.printTags(pw, programElementDoc, "Since:", "@since");
        }
        IKVMDocLet.printTags(pw, programElementDoc, "Serial:", "@serial");
        IKVMDocLet.printTags(pw, programElementDoc, "Serial Field:", "@serialField");
        IKVMDocLet.printTags(pw, programElementDoc, "Serial Data:", "@serialData");
        pw.println("</summary>");
        if (programElementDoc instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)programElementDoc;
            IKVMDocLet.printParamTags(pw, executableMemberDoc);
            IKVMDocLet.printReturnTag(pw, executableMemberDoc);
            IKVMDocLet.printThrowsTags(pw, executableMemberDoc);
        }
        IKVMDocLet.printSeeTags(pw, programElementDoc);
        IKVMDocLet.printIndent(pw, 2);
        pw.println("</member>");
        if (programElementDoc instanceof ClassDoc) {
            MethodDoc[] methods;
            ConstructorDoc[] constructors;
            FieldDoc[] fields;
            ClassDoc classDoc = (ClassDoc)programElementDoc;
            for (FieldDoc fieldDoc : fields = classDoc.fields()) {
                IKVMDocLet.print(pw, (ProgramElementDoc)fieldDoc);
            }
            for (ConstructorDoc constructorDoc : constructors = classDoc.constructors()) {
                IKVMDocLet.print(pw, (ProgramElementDoc)constructorDoc);
            }
            for (MethodDoc methodDoc : methods = classDoc.methods()) {
                IKVMDocLet.print(pw, (ProgramElementDoc)methodDoc);
            }
        }
    }

    private static void printParameters(PrintWriter pw, ExecutableMemberDoc memberDoc) {
        Parameter[] parameters = memberDoc.parameters();
        if (parameters.length > 0) {
            pw.print("(");
        }
        for (int i = 0; i < parameters.length; ++i) {
            String qualifiedTypeName;
            String mappedDataType;
            Type parameterType = parameters[i].type();
            if (i != 0) {
                pw.print(",");
            }
            if ((mappedDataType = DATA_TYPE_MAPPING.get(qualifiedTypeName = parameterType.qualifiedTypeName())) != null) {
                pw.print(mappedDataType);
            } else {
                pw.print(qualifiedTypeName);
            }
            pw.print(parameterType.dimension());
        }
        if (parameters.length > 0) {
            pw.print(")");
        }
    }

    private static void printParamTags(PrintWriter pw, ExecutableMemberDoc memberDoc) {
        ParamTag[] paramTags;
        for (ParamTag paramTag : paramTags = memberDoc.paramTags()) {
            IKVMDocLet.printIndent(pw, 3);
            pw.print("<param name=\"");
            pw.print(paramTag.parameterName());
            pw.print("\">");
            IKVMDocLet.printComment(pw, (ProgramElementDoc)memberDoc, paramTag.inlineTags());
            pw.println("</param>");
        }
    }

    private static void printReturnTag(PrintWriter pw, ExecutableMemberDoc memberDoc) {
        Tag[] returnDoc = memberDoc.tags("@return");
        if (returnDoc.length == 1) {
            IKVMDocLet.printIndent(pw, 3);
            pw.print("<returns>");
            IKVMDocLet.printComment(pw, (ProgramElementDoc)memberDoc, returnDoc[0].inlineTags());
            pw.println("</returns>");
        } else if (returnDoc.length > 1) {
            ERROR_REPORTER.printWarning("More than one return tag specified for '" + memberDoc.qualifiedName() + "'");
        }
    }

    private static void printThrowsTags(PrintWriter pw, ExecutableMemberDoc memberDoc) {
        ThrowsTag[] throwsTags;
        for (ThrowsTag throwsTag : throwsTags = memberDoc.throwsTags()) {
            ClassDoc exceptionDoc = throwsTag.exception();
            if (exceptionDoc == null) {
                ERROR_REPORTER.printWarning("Unable to locate class '" + throwsTag.exceptionName() + "' for '" + memberDoc.qualifiedName() + "'");
                continue;
            }
            IKVMDocLet.printIndent(pw, 3);
            pw.print("<exception cref=\"");
            IKVMDocLet.printReference(pw, (ProgramElementDoc)exceptionDoc, true);
            pw.print("\">");
            IKVMDocLet.printComment(pw, (ProgramElementDoc)memberDoc, throwsTag.inlineTags());
            pw.println("</exception>");
        }
    }

    private static void printSeeTags(PrintWriter pw, ProgramElementDoc memberDoc) {
        SeeTag[] seeTags;
        for (SeeTag seeTag : seeTags = memberDoc.seeTags()) {
            IKVMDocLet.printSeeTag(pw, memberDoc, seeTag, true);
        }
    }

    private static void printSeeTag(PrintWriter pw, ProgramElementDoc memberDoc, SeeTag seeTag, boolean asSeeAlso) {
        String type;
        String label = seeTag.label();
        String text = seeTag.text();
        boolean isAnchor = text.startsWith("<a") && text.endsWith("</a>");
        int endIndex = -1;
        MemberDoc referencedMemberDoc = seeTag.referencedMember();
        if (isAnchor) {
            endIndex = text.indexOf(62) + 1;
            if (endIndex == text.length()) {
                ERROR_REPORTER.printWarning("Invalid anchor '" + text + "' for '" + memberDoc.qualifiedName() + "'");
                IKVMDocLet.printText(pw, text);
                return;
            }
        } else {
            if (referencedMemberDoc == null) {
                referencedMemberDoc = seeTag.referencedClass();
            }
            if (referencedMemberDoc == null) {
                ERROR_REPORTER.printWarning("Unable to locate reference '" + text + "' for '" + memberDoc.qualifiedName() + "'");
                if (label == null || label.trim().length() == 0) {
                    IKVMDocLet.printText(pw, text);
                } else {
                    IKVMDocLet.printText(pw, label);
                }
                return;
            }
        }
        String string = type = asSeeAlso ? "seealso" : "see";
        if (asSeeAlso) {
            IKVMDocLet.printIndent(pw, 3);
        }
        pw.print("<");
        pw.print(type);
        if (isAnchor) {
            pw.print(text.substring(2, endIndex));
            IKVMDocLet.printText(pw, text.substring(endIndex, text.length() - 4));
        } else {
            pw.print(" cref=\"");
            IKVMDocLet.printReference(pw, (ProgramElementDoc)referencedMemberDoc, true);
            pw.print("\">");
            if (label == null || label.trim().length() == 0) {
                IKVMDocLet.printReference(pw, (ProgramElementDoc)referencedMemberDoc, false);
            } else {
                IKVMDocLet.printText(pw, label);
            }
        }
        pw.print("</");
        pw.print(type);
        pw.print(">");
        if (asSeeAlso) {
            pw.println();
        }
    }

    private static void printTags(PrintWriter pw, ProgramElementDoc referenceDoc, String label, String tagName) {
        Tag[] tags;
        for (Tag tag : tags = referenceDoc.tags(tagName)) {
            pw.print("<para><c>");
            pw.print(label);
            pw.print("</c> ");
            IKVMDocLet.printComment(pw, referenceDoc, tag.inlineTags());
            pw.println("</para>");
        }
    }

    private static void printReference(PrintWriter pw, ProgramElementDoc referenceDoc, boolean includeType) {
        ClassDoc classDoc;
        ClassDoc classDoc2 = classDoc = referenceDoc.isClass() || referenceDoc.isInterface() ? (ClassDoc)referenceDoc : referenceDoc.containingClass();
        if (includeType) {
            if (referenceDoc.isField()) {
                if (referenceDoc.isFinal() && !classDoc.isInterface()) {
                    pw.print("P:");
                } else {
                    pw.print("F:");
                }
            } else if (referenceDoc.isConstructor() || referenceDoc.isMethod()) {
                pw.print("M:");
            } else {
                pw.print("T:");
            }
        }
        pw.print(classDoc.qualifiedName());
        if (referenceDoc.isField()) {
            if (classDoc.isInterface()) {
                pw.print(".__Fields.");
            } else {
                pw.print(".");
            }
            pw.print(referenceDoc.name());
        } else if (referenceDoc.isConstructor()) {
            pw.print(".#ctor");
            IKVMDocLet.printParameters(pw, (ExecutableMemberDoc)((ConstructorDoc)referenceDoc));
        } else if (referenceDoc.isMethod()) {
            pw.print(".");
            pw.print(referenceDoc.name());
            IKVMDocLet.printParameters(pw, (ExecutableMemberDoc)((MethodDoc)referenceDoc));
        }
    }

    private static void printComment(PrintWriter pw, ProgramElementDoc memberDoc, Tag[] commentTags) {
        boolean isValid;
        StringBuilder ft = new StringBuilder();
        for (Tag tag : commentTags) {
            ft.append(tag.text());
        }
        boolean bl = isValid = OUTPUT_HTML && IKVMDocLet.validateXml(ft.toString().toLowerCase());
        if (OUTPUT_HTML && !isValid) {
            ERROR_REPORTER.printWarning(" >> Malformed XML detected, tags will be ignored for: " + memberDoc.name());
        }
        for (Tag tag : commentTags) {
            if (tag instanceof SeeTag) {
                SeeTag seeTag = (SeeTag)tag;
                IKVMDocLet.printSeeTag(pw, memberDoc, seeTag, false);
                continue;
            }
            String text = tag.text();
            IKVMDocLet.printText(pw, memberDoc, text, isValid);
        }
    }

    private static void printText(PrintWriter pw, ProgramElementDoc memberDoc, String text, boolean html) {
        char[] characters = text.toCharArray();
        block7: for (int index = 0; index < characters.length; ++index) {
            char character = characters[index];
            switch (character) {
                case '<': {
                    int endIndex;
                    int x = Character.offsetByCodePoints(text, 0, index);
                    if (x != index) {
                        System.out.println("x = " + x);
                    }
                    if ((endIndex = text.indexOf(62, index)) == -1 || endIndex - index < 2) {
                        pw.print("&lt;");
                        continue block7;
                    }
                    String tag = text.substring(index + 1, endIndex).trim().toLowerCase();
                    boolean isEndTag = false;
                    boolean isStandAloneTag = false;
                    if (tag.length() > 1) {
                        if (tag.startsWith("/")) {
                            tag = tag.substring(1);
                            isEndTag = true;
                        } else if (tag.endsWith("/")) {
                            tag = tag.substring(0, tag.length() - 1);
                            isStandAloneTag = true;
                        }
                    }
                    if ("p".equals(tag)) {
                        if (!isEndTag) {
                            pw.print("<para/>");
                        }
                        index = endIndex;
                        continue block7;
                    }
                    if ("br".equals(tag) || "hr".equals(tag) || "img".equals(tag)) {
                        if (!isEndTag) {
                            pw.print("<");
                            pw.print(tag);
                            pw.print("/>");
                        }
                        index = endIndex;
                        continue block7;
                    }
                    if (html) {
                        if ("code".equals(tag)) {
                            tag = "c";
                        } else if ("li".equals(tag)) {
                            tag = "item";
                        } else if ("ol".equals(tag)) {
                            tag = "list";
                            if (!isEndTag) {
                                tag = tag + " type=\"number\"";
                            }
                        } else if ("pre".equals(tag)) {
                            tag = "code";
                        } else if ("ul".equals(tag)) {
                            tag = "list";
                            if (!isEndTag) {
                                tag = tag + " type=\"bullet\"";
                            }
                        }
                        pw.print("<");
                        if (isEndTag) {
                            pw.print("/");
                        }
                        pw.print(tag);
                        if (isStandAloneTag) {
                            pw.print("/");
                        }
                        pw.print(">");
                        index = endIndex;
                        continue block7;
                    }
                    pw.print("&lt;");
                    continue block7;
                }
                case '>': {
                    pw.print("&gt;");
                    continue block7;
                }
                case '&': {
                    pw.print("&amp;");
                    continue block7;
                }
                case '\'': {
                    pw.print("&apos;");
                    continue block7;
                }
                case '\"': {
                    pw.print("&quot;");
                    continue block7;
                }
                default: {
                    pw.print(character);
                }
            }
        }
    }

    private static void printText(PrintWriter pw, String text) {
        char[] characters = text.toCharArray();
        block7: for (int index = 0; index < characters.length; ++index) {
            char character = characters[index];
            switch (character) {
                case '<': {
                    pw.print("&lt;");
                    continue block7;
                }
                case '>': {
                    pw.print("&gt;");
                    continue block7;
                }
                case '&': {
                    pw.print("&amp;");
                    continue block7;
                }
                case '\'': {
                    pw.print("&apos;");
                    continue block7;
                }
                case '\"': {
                    pw.print("&quot;");
                    continue block7;
                }
                default: {
                    pw.print(character);
                }
            }
        }
    }

    public static void printIndent(PrintWriter pw, int indentations) {
        for (int i = 0; i < indentations; ++i) {
            pw.write("\t");
        }
    }

    private static void validate(File file) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(file, new DefaultHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                this.fatalError(e);
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                ERROR_REPORTER.printError(e.getMessage());
                ERROR_REPORTER.printError("Line: " + e.getLineNumber() + ", Column: " + e.getColumnNumber());
                throw e;
            }
        });
    }

    private static boolean validateXml(String xml) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            final AtomicBoolean ret = new AtomicBoolean(true);
            parser.parse(new InputSource(new StringReader("<msg>" + xml + "</msg>")), new DefaultHandler(){

                @Override
                public void error(SAXParseException e) throws SAXException {
                    this.fatalError(e);
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    ERROR_REPORTER.printWarning(e.getMessage());
                    ERROR_REPORTER.printWarning("Line: " + e.getLineNumber() + ", Column: " + e.getColumnNumber());
                    ret.set(false);
                }
            });
            return ret.get();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) {
        Main.execute((String)"ikvmdoc", (String)IKVMDocLet.class.getName(), (String[])args);
    }

    public static int optionLength(String option) {
        if (ASSEMBLY_PARAMETER.equals(option)) {
            return 2;
        }
        if (STRICT_FINAL_FIELD_SEMANTICS_PARAMETER.equals(option)) {
            return 1;
        }
        if (HTML_PARAMETER.equals(option)) {
            return 1;
        }
        if (AUTHOR_PARAMETER.equals(option)) {
            return 1;
        }
        if (DEPRECATED_PARAMETER.equals(option)) {
            return 1;
        }
        if (SINCE_PARAMETER.equals(option)) {
            return 1;
        }
        if (VERSION_PARAMETER.equals(option)) {
            return 1;
        }
        try {
            Method getInstance = ConfigurationImpl.class.getMethod("getInstance", new Class[0]);
            return ((ConfigurationImpl)getInstance.invoke(null, new Object[0])).optionLength(option);
        }
        catch (Exception ignored) {
            try {
                Constructor ctor = ConfigurationImpl.class.getConstructor(new Class[0]);
                return ((ConfigurationImpl)ctor.newInstance(new Object[0])).optionLength(option);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        ERROR_REPORTER = reporter;
        for (String[] option : options) {
            if (ASSEMBLY_PARAMETER.equals(option[0])) {
                ASSEMBLY_FILE = new File(option[1]);
                if (ASSEMBLY_FILE.isFile() && ASSEMBLY_FILE.exists()) continue;
                reporter.printError("The assembly file specified '" + ASSEMBLY_FILE.getAbsolutePath() + "' is invalid.");
                return false;
            }
            if (HTML_PARAMETER.equals(option[0])) {
                OUTPUT_HTML = false;
                continue;
            }
            if (AUTHOR_PARAMETER.equals(option[0])) {
                OUTPUT_AUTHOR = true;
                continue;
            }
            if (DEPRECATED_PARAMETER.equals(option[0])) {
                OUTPUT_DEPRECATED = false;
                continue;
            }
            if (SINCE_PARAMETER.equals(option[0])) {
                OUTPUT_SINCE = false;
                continue;
            }
            if (!VERSION_PARAMETER.equals(option[0])) continue;
            OUTPUT_VERSION = true;
        }
        return true;
    }

    static {
        OUTPUT_HTML = true;
        OUTPUT_AUTHOR = false;
        OUTPUT_DEPRECATED = true;
        OUTPUT_SINCE = true;
        OUTPUT_VERSION = false;
        DATA_TYPE_MAPPING.put("boolean", "System.Boolean");
        DATA_TYPE_MAPPING.put("byte", "System.Byte");
        DATA_TYPE_MAPPING.put("char", "System.Char");
        DATA_TYPE_MAPPING.put("short", "System.Int16");
        DATA_TYPE_MAPPING.put("int", "System.Int32");
        DATA_TYPE_MAPPING.put("long", "System.Int64");
        DATA_TYPE_MAPPING.put("float", "System.Single");
        DATA_TYPE_MAPPING.put("double", "System.Double");
        DATA_TYPE_MAPPING.put("java.lang.Object", "System.Object");
        DATA_TYPE_MAPPING.put("java.lang.String", "System.String");
        DATA_TYPE_MAPPING.put("java.lang.Throwable", "System.Exception");
    }
}

