/*
 * Decompiled with CFR 0.152.
 */
package com.ufreedom.uikit.effect;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import com.facebook.rebound.SimpleSpringListener;
import com.facebook.rebound.Spring;
import com.facebook.rebound.SpringListener;
import com.ufreedom.uikit.FloatingTextView;
import com.ufreedom.uikit.effect.ReboundFloatingAnimator;

public class TranslateFloatingAnimator
extends ReboundFloatingAnimator {
    private float translateY;
    private long duration;

    public TranslateFloatingAnimator() {
        this.translateY = -200.0f;
        this.duration = 1500L;
    }

    public TranslateFloatingAnimator(float translateY, long duration) {
        this.translateY = translateY;
        this.duration = duration;
    }

    @Override
    public void applyFloatingAnimation(final FloatingTextView view) {
        view.setTranslationY(0.0f);
        view.setAlpha(1.0f);
        view.setScaleX(0.0f);
        view.setScaleY(0.0f);
        Spring scaleAnim = this.createSpringByBouncinessAndSpeed(10.0, 15.0).addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                float transition = TranslateFloatingAnimator.this.transition((float)spring.getCurrentValue(), 0.0f, 1.0f);
                view.setScaleX(transition);
                view.setScaleY(transition);
            }
        });
        ValueAnimator translateAnimator = ObjectAnimator.ofFloat((float[])new float[]{0.0f, this.translateY});
        translateAnimator.setDuration(this.duration);
        translateAnimator.setStartDelay(50L);
        translateAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                view.setTranslationY(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        translateAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                view.setTranslationY(0.0f);
                view.setAlpha(0.0f);
            }
        });
        ValueAnimator alphaAnimator = ObjectAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        alphaAnimator.setDuration(this.duration);
        alphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                view.setAlpha(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        scaleAnim.setEndValue(1.0);
        alphaAnimator.start();
        translateAnimator.start();
    }
}

