/*
 * Decompiled with CFR 0.152.
 */
package com.ufreedom.uikit.effect;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import com.facebook.rebound.SimpleSpringListener;
import com.facebook.rebound.Spring;
import com.facebook.rebound.SpringListener;
import com.ufreedom.uikit.FloatingTextView;
import com.ufreedom.uikit.effect.ReboundFloatingAnimator;

public class ScaleFloatingAnimator
extends ReboundFloatingAnimator {
    private long duration;

    public ScaleFloatingAnimator() {
        this.duration = 1000L;
    }

    public ScaleFloatingAnimator(long duration) {
        this.duration = duration;
    }

    @Override
    public void applyFloatingAnimation(final FloatingTextView view) {
        Spring scaleAnim = this.createSpringByBouncinessAndSpeed(10.0, 15.0).addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                float transition = ScaleFloatingAnimator.this.transition((float)spring.getCurrentValue(), 0.0f, 1.0f);
                view.setScaleX(transition);
                view.setScaleY(transition);
            }
        });
        ValueAnimator alphaAnimator = ObjectAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        alphaAnimator.setDuration(this.duration);
        alphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                view.setAlpha(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        scaleAnim.setEndValue(1.0);
        alphaAnimator.start();
    }
}

