/*
 * Decompiled with CFR 0.152.
 */
package com.ufreedom.uikit.effect;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import com.facebook.rebound.SimpleSpringListener;
import com.facebook.rebound.Spring;
import com.facebook.rebound.SpringListener;
import com.ufreedom.uikit.BaseFloatingPathAnimator;
import com.ufreedom.uikit.FloatingTextView;

public class CurvePathFloatingAnimator
extends BaseFloatingPathAnimator {
    @Override
    public void applyFloatingPathAnimation(final FloatingTextView view, float start, float end) {
        Spring scaleAnim = this.createSpringByBouncinessAndSpeed(11.0, 15.0).addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringUpdate(Spring spring) {
                float transition = CurvePathFloatingAnimator.this.transition((float)spring.getCurrentValue(), 0.0f, 1.0f);
                view.setScaleX(transition);
                view.setScaleY(transition);
            }
        });
        ValueAnimator translateAnimator = ObjectAnimator.ofFloat((float[])new float[]{start, end});
        translateAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                float[] pos = CurvePathFloatingAnimator.this.getFloatingPosition(value);
                float x = pos[0];
                float y = pos[1];
                view.setTranslationX(x);
                view.setTranslationY(y);
            }
        });
        translateAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                view.setTranslationX(0.0f);
                view.setTranslationY(0.0f);
                view.setAlpha(0.0f);
            }
        });
        ValueAnimator alphaAnimator = ObjectAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        alphaAnimator.setDuration(3000L);
        alphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                view.setAlpha(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        scaleAnim.setEndValue(1.0);
        translateAnimator.setDuration(3000L);
        translateAnimator.setStartDelay(50L);
        translateAnimator.start();
        alphaAnimator.start();
    }
}

