/*
 * Decompiled with CFR 0.152.
 */
package com.ufreedom.uikit;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PathMeasure;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.ufreedom.uikit.FloatingAnimator;
import com.ufreedom.uikit.FloatingPath;
import com.ufreedom.uikit.FloatingPathEffect;
import com.ufreedom.uikit.FloatingText;

public class FloatingTextView
extends TextView {
    private static final String TAG = "FloatingTextView";
    private static final int PATH_WIDTH = 2;
    private FloatingText.FloatingTextBuilder floatingTextBuilder;
    private Paint mTextPaint;
    private Paint mPathPaint;
    private PathMeasure mPathMeasure;
    private View mAttachedView;

    public FloatingTextView(Context context) {
        this(context, null);
    }

    public FloatingTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public FloatingTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setTextSize(100.0f);
        this.mTextPaint.setColor(-65536);
        this.mPathPaint = new Paint(1);
        this.mPathPaint.setStyle(Paint.Style.STROKE);
        this.mPathPaint.setStrokeWidth(2.0f);
        this.mPathPaint.setColor(-65536);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.floatingTextBuilder == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthPaddingOffset = this.getPaddingLeft() + this.getPaddingRight();
        if (widthMode == Integer.MIN_VALUE && heightMode == Integer.MIN_VALUE) {
            float maxWidth = this.getDesireWidth(this.mTextPaint);
            Paint.FontMetricsInt fmi = this.mTextPaint.getFontMetricsInt();
            this.setMeasuredDimension((int)maxWidth + widthPaddingOffset, fmi.bottom - fmi.top);
        } else if (widthMode == Integer.MIN_VALUE) {
            float maxWidth = this.getDesireWidth(this.mTextPaint);
            this.setMeasuredDimension((int)maxWidth + widthPaddingOffset, heightSize);
        } else if (heightMode == Integer.MIN_VALUE) {
            Paint.FontMetricsInt fmi = this.mTextPaint.getFontMetricsInt();
            this.setMeasuredDimension(widthSize + widthPaddingOffset, fmi.bottom - fmi.top);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private float getDesireWidth(Paint mTextPaint) {
        return mTextPaint.measureText(this.floatingTextBuilder.getTextContent());
    }

    public void setFloatingTextBuilder(FloatingText.FloatingTextBuilder floatingTextBuilder) {
        this.floatingTextBuilder = floatingTextBuilder;
        this.initTextStyle();
    }

    public void flyText(View view) {
        this.layout(0, 0, 0, 0);
        this.mAttachedView = view;
        Rect rect = new Rect();
        this.mAttachedView.getGlobalVisibleRect(rect);
        int[] location = new int[2];
        this.getLocationOnScreen(location);
        rect.offset(-location[0], -location[1]);
        int left = rect.left + (rect.width() - this.getMeasuredWidth()) / 2 + this.floatingTextBuilder.getOffsetX();
        int top = rect.top + (rect.height() - this.getMeasuredHeight()) / 2 + this.floatingTextBuilder.getOffsetY();
        int bottom = top + this.getMeasuredHeight();
        int right = left + this.getMeasuredWidth();
        this.layout(left, top, right, bottom);
        this.invalidate();
        FloatingPathEffect floatingPathEffect = this.floatingTextBuilder.getFloatingPathEffect();
        if (floatingPathEffect != null) {
            FloatingPath floatingPath = floatingPathEffect.getFloatingPath(this);
            this.mPathMeasure = floatingPath.getPathMeasure();
        }
        FloatingAnimator floatingAnimator = this.floatingTextBuilder.getFloatingAnimator();
        floatingAnimator.applyFloatingAnimation(this);
    }

    private void initTextStyle() {
        this.mTextPaint.setTextSize((float)this.floatingTextBuilder.getTextSize());
        this.mTextPaint.setColor(this.floatingTextBuilder.getTextColor());
    }

    public View getAttachedView() {
        return this.mAttachedView;
    }

    public PathMeasure getPathMeasure() {
        return this.mPathMeasure;
    }

    public void dettachFromWindow() {
        ViewGroup viewParent = (ViewGroup)this.getParent();
        viewParent.removeView((View)this);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.floatingTextBuilder == null || this.mAttachedView == null) {
            return;
        }
        float x = (float)((double)this.getWidth() / 2.0);
        float y = (float)((double)this.getHeight() / 2.0);
        Paint.FontMetricsInt fmi = this.mTextPaint.getFontMetricsInt();
        float baseline = (float)((double)y - ((double)fmi.bottom / 2.0 + (double)fmi.top / 2.0));
        canvas.drawText(this.floatingTextBuilder.getTextContent(), x, baseline, this.mTextPaint);
    }
}

