/*
 * Decompiled with CFR 0.152.
 */
package com.ufreedom.uikit;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.ufreedom.uikit.FloatingAnimator;
import com.ufreedom.uikit.FloatingPathEffect;
import com.ufreedom.uikit.FloatingTextView;
import com.ufreedom.uikit.effect.TranslateFloatingAnimator;

public class FloatingText {
    private FloatingTextBuilder mFloatingTextBuilder;
    private FloatingTextView mFloatingTextView;

    protected FloatingText(FloatingTextBuilder floatingTextBuilder) {
        this.mFloatingTextBuilder = floatingTextBuilder;
    }

    public void startFloating(View view) {
        this.mFloatingTextView.flyText(view);
    }

    public FloatingTextView attach2Window() {
        ViewGroup rootView = (ViewGroup)this.mFloatingTextBuilder.getActivity().findViewById(0x1020002);
        this.mFloatingTextView = new FloatingTextView((Context)this.mFloatingTextBuilder.getActivity());
        rootView.addView((View)this.mFloatingTextView, new ViewGroup.LayoutParams(-2, -2));
        this.mFloatingTextView.setFloatingTextBuilder(this.mFloatingTextBuilder);
        return this.mFloatingTextView;
    }

    public void dettachFromWidow() {
        if (this.mFloatingTextView == null || this.mFloatingTextBuilder == null) {
            return;
        }
        ViewGroup rootView = (ViewGroup)this.mFloatingTextBuilder.getActivity().findViewById(0x1020002);
        rootView.removeView((View)this.mFloatingTextView);
    }

    public static class FloatingTextBuilder {
        private Activity activity;
        private int textColor;
        private int textSize;
        private FloatingAnimator floatingAnimator;
        private FloatingPathEffect floatingPathEffect;
        private String textContent = "";
        private int offsetX;
        private int offsetY;

        public FloatingTextBuilder(Activity activity) {
            this.activity = activity;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public FloatingTextBuilder offsetX(int offsetX) {
            this.offsetX = offsetX;
            return this;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public FloatingTextBuilder offsetY(int offsetY) {
            this.offsetY = offsetY;
            return this;
        }

        public Activity getActivity() {
            return this.activity;
        }

        public int getTextColor() {
            return this.textColor;
        }

        public int getTextSize() {
            return this.textSize;
        }

        public FloatingAnimator getFloatingAnimator() {
            return this.floatingAnimator;
        }

        public FloatingPathEffect getFloatingPathEffect() {
            return this.floatingPathEffect;
        }

        public String getTextContent() {
            return this.textContent;
        }

        public FloatingTextBuilder textColor(int mTextColor) {
            this.textColor = mTextColor;
            return this;
        }

        public FloatingTextBuilder textSize(int mTextSize) {
            this.textSize = mTextSize;
            return this;
        }

        public FloatingTextBuilder floatingAnimatorEffect(FloatingAnimator floatingAnimator) {
            this.floatingAnimator = floatingAnimator;
            return this;
        }

        public FloatingTextBuilder textContent(String textContent) {
            this.textContent = textContent;
            return this;
        }

        public FloatingTextBuilder floatingPathEffect(FloatingPathEffect floatingPathEffect) {
            this.floatingPathEffect = floatingPathEffect;
            return this;
        }

        public FloatingText build() {
            if (this.activity == null) {
                throw new NullPointerException("activity show not be null");
            }
            if (this.textContent == null) {
                throw new NullPointerException("textContent show not be null");
            }
            if (this.floatingAnimator == null) {
                this.floatingAnimator = new TranslateFloatingAnimator();
            }
            FloatingText floatingText = new FloatingText(this);
            return floatingText;
        }
    }
}

