/*
 * Decompiled with CFR 0.152.
 */
package com.ufreedom;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import com.ufreedom.CountDownHelper;
import com.ufreedom.ElapsedTimeUtil;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;

public class CountDownTextView
extends TextView {
    private static final String TAG = "CountDownTextView";
    public static final int TIME_SHOW_D_H_M_S = 10;
    public static final int TIME_SHOW_H_M_S = 20;
    public static final int TIME_SHOW_M_S = 30;
    public static final int TIME_SHOW_S = 40;
    public long mCountDownInterval = 1000L;
    private static final String TIME_FORMAT_D_H_M_S = "%1$02d:%2$02d:%3$02d:%4$02d";
    private static final String TIME_FORMAT_H_M_S = "%1$02d:%2$02d:%3$02d";
    private static final String TIME_FORMAT_M_S = "%1$02d:%2$02d";
    private static final String TIME_FORMAT_S = "%1$02d";
    private long scheduledTime;
    private boolean isAutoShowText;
    private CountDownCallback countDownCallback;
    private CountDownHelper mCountDownHelper;
    private boolean mVisible;
    private boolean mStarted;
    private boolean mRunning;
    private boolean mLogged;
    private String mFormat;
    private Formatter mFormatter;
    private Locale mFormatterLocale;
    private Object[] mFormatterArgs = new Object[1];
    private StringBuilder mFormatBuilder;
    private int mTimeFlag;
    private StringBuilder mRecycle = new StringBuilder(12);

    public CountDownTextView(Context context) {
        super(context);
        this.init();
    }

    public CountDownTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setTimeFormat(20);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.updateRunning();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.updateRunning();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mVisible = visibility == 0;
        this.updateRunning();
    }

    private void updateRunning() {
        boolean running;
        boolean bl = running = this.mVisible && this.mStarted;
        if (running != this.mRunning) {
            if (running) {
                this.mCountDownHelper.start();
            } else {
                this.mCountDownHelper.cancel();
            }
            this.mRunning = running;
        }
    }

    public void start() {
        this.startCountDown();
        this.mStarted = true;
        this.updateRunning();
    }

    public void cancel() {
        this.mStarted = false;
        this.updateRunning();
    }

    public void setAutoDisplayText(boolean isAutoShowText) {
        this.isAutoShowText = isAutoShowText;
    }

    public void setFormat(String format) {
        this.mFormat = format;
        if (format != null && this.mFormatBuilder == null) {
            this.mFormatBuilder = new StringBuilder(format.length() * 2);
        }
    }

    private String getFormatTime(long now) {
        String text;
        long day = ElapsedTimeUtil.MILLISECONDS.toDays(now);
        long hour = ElapsedTimeUtil.MILLISECONDS.toHours(now);
        long minute = ElapsedTimeUtil.MILLISECONDS.toMinutes(now);
        long seconds = ElapsedTimeUtil.MILLISECONDS.toSeconds(now);
        this.mRecycle.setLength(0);
        Formatter f = new Formatter(this.mRecycle, Locale.getDefault());
        switch (this.mTimeFlag) {
            case 10: {
                text = f.format(TIME_FORMAT_D_H_M_S, day, hour, minute, seconds).toString();
                break;
            }
            case 20: {
                text = f.format(TIME_FORMAT_H_M_S, hour, minute, seconds).toString();
                break;
            }
            case 30: {
                text = f.format(TIME_FORMAT_M_S, minute, seconds).toString();
                break;
            }
            case 40: {
                text = f.format(TIME_FORMAT_S, seconds).toString();
                break;
            }
            default: {
                text = f.format(TIME_FORMAT_H_M_S, seconds).toString();
            }
        }
        return text;
    }

    private synchronized void updateText(long now) {
        String text;
        block4: {
            text = this.getFormatTime(now);
            if (this.mFormat != null) {
                Locale loc = Locale.getDefault();
                if (this.mFormatter == null || !loc.equals(this.mFormatterLocale)) {
                    this.mFormatterLocale = loc;
                    this.mFormatter = new Formatter(this.mFormatBuilder, loc);
                }
                this.mFormatBuilder.setLength(0);
                this.mFormatterArgs[0] = text;
                try {
                    this.mFormatter.format(this.mFormat, this.mFormatterArgs);
                    text = this.mFormatBuilder.toString();
                }
                catch (IllegalFormatException ex) {
                    if (this.mLogged) break block4;
                    Log.w((String)TAG, (String)("Illegal format string: " + this.mFormat));
                    this.mLogged = true;
                }
            }
        }
        this.setText(text);
    }

    public void setTimeInFuture(long millisInFuture) {
        this.scheduledTime = millisInFuture;
    }

    public void addCountDownCallback(CountDownCallback callback) {
        this.countDownCallback = callback;
    }

    public void setTimeFormat(int timeFlag) {
        this.mTimeFlag = timeFlag;
    }

    public long getCountDownInterval() {
        return this.mCountDownInterval;
    }

    public void setCountDownInterval(long mCountDownInterval) {
        this.mCountDownInterval = mCountDownInterval;
    }

    private void startCountDown() {
        this.mCountDownHelper = new CountDownHelper(this.scheduledTime, this.mCountDownInterval){

            @Override
            public void onTick(long millisUntilFinished) {
                if (CountDownTextView.this.isAutoShowText) {
                    CountDownTextView.this.updateText(millisUntilFinished);
                }
                if (CountDownTextView.this.countDownCallback != null) {
                    CountDownTextView.this.countDownCallback.onTick(CountDownTextView.this, millisUntilFinished);
                }
            }

            @Override
            public void onFinish() {
                if (CountDownTextView.this.countDownCallback != null) {
                    CountDownTextView.this.countDownCallback.onFinish(CountDownTextView.this);
                }
            }
        };
        this.mCountDownHelper.start();
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)CountDownTextView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)CountDownTextView.class.getName());
    }

    public static interface CountDownCallback {
        public void onTick(CountDownTextView var1, long var2);

        public void onFinish(CountDownTextView var1);
    }
}

