/*
 * Decompiled with CFR 0.152.
 */
package com.ufreedom;

import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;

public abstract class CountDownHelper {
    private final long mMillisInFuture;
    private final long mCountdownInterval;
    private boolean mCancelled = false;
    public static final int UPDATE_TIME = 0;
    private Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            CountDownHelper countDownHelper = CountDownHelper.this;
            synchronized (countDownHelper) {
                if (CountDownHelper.this.mCancelled) {
                    return;
                }
                long millisLeft = CountDownHelper.this.mMillisInFuture - SystemClock.elapsedRealtime();
                if (millisLeft <= 0L) {
                    CountDownHelper.this.onFinish();
                } else if (millisLeft < CountDownHelper.this.mCountdownInterval) {
                    this.sendMessageDelayed(this.obtainMessage(0), millisLeft);
                } else {
                    long delay;
                    long lastTickStart = SystemClock.elapsedRealtime();
                    CountDownHelper.this.onTick(millisLeft);
                    for (delay = lastTickStart + CountDownHelper.this.mCountdownInterval - SystemClock.elapsedRealtime(); delay < 0L; delay += CountDownHelper.this.mCountdownInterval) {
                    }
                    this.sendMessageDelayed(this.obtainMessage(0), delay);
                }
            }
        }
    };

    public CountDownHelper(long millisInFuture, long countDownInterval) {
        this.mMillisInFuture = millisInFuture;
        this.mCountdownInterval = countDownInterval;
    }

    public abstract void onTick(long var1);

    public abstract void onFinish();

    public final synchronized void cancel() {
        this.mCancelled = true;
        this.mHandler.removeMessages(0);
    }

    public final synchronized void start() {
        this.mCancelled = false;
        if (this.mMillisInFuture <= 0L) {
            this.onFinish();
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(0));
    }
}

