/*
 * Decompiled with CFR 0.152.
 */
package com.ufoscout.coreutils.jwt.kotlin;

import com.ufoscout.coreutils.jwt.TokenExpiredException;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\"\u0010\u000e\u001a\u0002H\u000f\"\n\b\u0000\u0010\u000f\u0018\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\bH\u0087\b\u00a2\u0006\u0002\u0010\u0011J-\u0010\u000e\u001a\u0002H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/ufoscout/coreutils/jwt/kotlin/JwtService;", "", "jwtService", "Lcom/ufoscout/coreutils/jwt/JwtService;", "(Lcom/ufoscout/coreutils/jwt/JwtService;)V", "getJwtService", "()Lcom/ufoscout/coreutils/jwt/JwtService;", "generate", "", "payload", "subject", "createdDate", "Ljava/util/Date;", "expirationDate", "parse", "T", "jwt", "(Ljava/lang/String;)Ljava/lang/Object;", "payloadClass", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "coreutils-jwt-kotlin"})
public final class JwtService {
    @NotNull
    private final com.ufoscout.coreutils.jwt.JwtService jwtService;

    @NotNull
    public final String generate(@NotNull Object payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        String string = this.jwtService.generate(payload);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jwtService.generate(payload)");
        return string;
    }

    @NotNull
    public final String generate(@NotNull String subject, @NotNull Object payload) {
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        String string = this.jwtService.generate(subject, payload);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jwtService.generate(subject, payload)");
        return string;
    }

    @NotNull
    public final String generate(@NotNull String subject, @NotNull Object payload, @NotNull Date createdDate, @NotNull Date expirationDate) {
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)createdDate, (String)"createdDate");
        Intrinsics.checkParameterIsNotNull((Object)expirationDate, (String)"expirationDate");
        String string = this.jwtService.generate(subject, payload, createdDate, expirationDate);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jwtService.generate(subj\u2026atedDate, expirationDate)");
        return string;
    }

    @NotNull
    public final <T> T parse(@NotNull String jwt, @NotNull KClass<T> payloadClass) throws TokenExpiredException {
        Intrinsics.checkParameterIsNotNull((Object)jwt, (String)"jwt");
        Intrinsics.checkParameterIsNotNull(payloadClass, (String)"payloadClass");
        Object object = this.jwtService.parse(jwt, JvmClassMappingKt.getJavaClass(payloadClass));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"jwtService.parse(jwt, payloadClass.java)");
        return (T)object;
    }

    private final <T> T parse(String jwt) throws TokenExpiredException {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.parse(jwt, Reflection.getOrCreateKotlinClass(Object.class));
    }

    @NotNull
    public final com.ufoscout.coreutils.jwt.JwtService getJwtService() {
        return this.jwtService;
    }

    public JwtService(@NotNull com.ufoscout.coreutils.jwt.JwtService jwtService) {
        Intrinsics.checkParameterIsNotNull((Object)jwtService, (String)"jwtService");
        this.jwtService = jwtService;
    }
}

