/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.trigger.Trigger;
import org.elasticsearch.xpack.watcher.trigger.TriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.TriggerEvent;

public class TriggerService
extends AbstractComponent {
    private final Listeners listeners = new Listeners();
    private final Map<String, TriggerEngine> engines;

    @Inject
    public TriggerService(Settings settings, Set<TriggerEngine> engines) {
        super(settings);
        HashMap<String, TriggerEngine> builder = new HashMap<String, TriggerEngine>();
        for (TriggerEngine engine : engines) {
            builder.put(engine.type(), engine);
            engine.register(this.listeners);
        }
        this.engines = Collections.unmodifiableMap(builder);
    }

    public synchronized void start(Collection<? extends TriggerEngine.Job> jobs) throws Exception {
        for (TriggerEngine engine : this.engines.values()) {
            engine.start(jobs);
        }
    }

    public synchronized void stop() {
        for (TriggerEngine engine : this.engines.values()) {
            engine.stop();
        }
    }

    public void add(TriggerEngine.Job job) {
        this.engines.get(job.trigger().type()).add(job);
    }

    public boolean remove(String jobName) {
        for (TriggerEngine engine : this.engines.values()) {
            if (!engine.remove(jobName)) continue;
            return true;
        }
        return false;
    }

    public void register(TriggerEngine.Listener listener) {
        this.listeners.add(listener);
    }

    public TriggerEvent simulateEvent(String type, String jobId, Map<String, Object> data) {
        TriggerEngine engine = this.engines.get(type);
        if (engine == null) {
            throw Exceptions.illegalArgument("could not simulate trigger event. unknown trigger type [{}]", type);
        }
        return engine.simulateEvent(jobId, data, this);
    }

    public Trigger parseTrigger(String jobName, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        assert (token == XContentParser.Token.START_OBJECT);
        token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ElasticsearchParseException("could not parse trigger for [{}]. expected trigger type string field, but found [{}]", new Object[]{jobName, token});
        }
        String type = parser.currentName();
        token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse trigger [{}] for [{}]. expected trigger an object as the trigger body, but found [{}]", new Object[]{type, jobName, token});
        }
        Trigger trigger = this.parseTrigger(jobName, type, parser);
        token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("could not parse trigger [{}] for [{}]. expected [END_OBJECT] token, but found [{}]", new Object[]{type, jobName, token});
        }
        return trigger;
    }

    public Trigger parseTrigger(String jobName, String type, XContentParser parser) throws IOException {
        TriggerEngine engine = this.engines.get(type);
        if (engine == null) {
            throw new ElasticsearchParseException("could not parse trigger [{}] for [{}]. unknown trigger type [{}]", type, jobName, type);
        }
        return engine.parseTrigger(jobName, parser);
    }

    public TriggerEvent parseTriggerEvent(String watchId, String context, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        assert (token == XContentParser.Token.START_OBJECT);
        token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ElasticsearchParseException("could not parse trigger event for [{}] for watch [{}]. expected trigger type string field, but found [{}]", new Object[]{context, watchId, token});
        }
        String type = parser.currentName();
        token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse trigger event for [{}] for watch [{}]. expected trigger an object as the trigger body, but found [{}]", new Object[]{context, watchId, token});
        }
        TriggerEvent trigger = this.parseTriggerEvent(watchId, context, type, parser);
        token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("could not parse trigger [{}] for [{}]. expected [END_OBJECT] token, but found [{}]", new Object[]{type, context, token});
        }
        return trigger;
    }

    public TriggerEvent parseTriggerEvent(String watchId, String context, String type, XContentParser parser) throws IOException {
        TriggerEngine engine = this.engines.get(type);
        if (engine == null) {
            throw new ElasticsearchParseException("Unknown trigger type [{}]", type);
        }
        return engine.parseTriggerEvent(this, watchId, context, parser);
    }

    static class Listeners
    implements TriggerEngine.Listener {
        private List<TriggerEngine.Listener> listeners = new CopyOnWriteArrayList<TriggerEngine.Listener>();

        Listeners() {
        }

        public void add(TriggerEngine.Listener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void triggered(Iterable<TriggerEvent> events) {
            for (TriggerEngine.Listener listener : this.listeners) {
                listener.triggered(events);
            }
        }
    }
}

