/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.execute;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.watcher.support.xcontent.XContentSource;

public class ExecuteWatchResponse
extends ActionResponse {
    private String recordId;
    private XContentSource recordSource;

    public ExecuteWatchResponse() {
    }

    public ExecuteWatchResponse(String recordId, BytesReference recordSource, XContentType contentType) {
        this.recordId = recordId;
        this.recordSource = new XContentSource(recordSource, contentType);
    }

    public String getRecordId() {
        return this.recordId;
    }

    public XContentSource getRecordSource() {
        return this.recordSource;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recordId = in.readString();
        this.recordSource = XContentSource.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.recordId);
        XContentSource.writeTo(this.recordSource, out);
    }
}

