/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform.chain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.watcher.transform.Transform;
import org.elasticsearch.xpack.watcher.transform.chain.ChainTransform;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class ExecutableChainTransform
extends ExecutableTransform<ChainTransform, ChainTransform.Result> {
    private final List<ExecutableTransform> transforms;

    public ExecutableChainTransform(ChainTransform transform, Logger logger, ExecutableTransform ... transforms) {
        this(transform, logger, Arrays.asList(transforms));
    }

    public ExecutableChainTransform(ChainTransform transform, Logger logger, List<ExecutableTransform> transforms) {
        super(transform, logger);
        this.transforms = Collections.unmodifiableList(transforms);
    }

    public List<ExecutableTransform> executableTransforms() {
        return this.transforms;
    }

    @Override
    public ChainTransform.Result execute(WatchExecutionContext ctx, Payload payload) {
        ArrayList<Transform.Result> results = new ArrayList<Transform.Result>();
        try {
            return this.doExecute(ctx, payload, results);
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("failed to execute [{}] transform for [{}]", (Object)"chain", (Object)ctx.id()), (Throwable)e);
            return new ChainTransform.Result(e, results);
        }
    }

    ChainTransform.Result doExecute(WatchExecutionContext ctx, Payload payload, List<Transform.Result> results) throws IOException {
        for (ExecutableTransform transform : this.transforms) {
            Object result = transform.execute(ctx, payload);
            results.add((Transform.Result)result);
            if (((Transform.Result)result).status() == Transform.Result.Status.FAILURE) {
                return new ChainTransform.Result(LoggerMessageFormat.format("failed to execute [{}] transform for [{}]. failed to execute sub-transform [{}]", "chain", ctx.id(), transform.type()), results);
            }
            payload = ((Transform.Result)result).payload();
        }
        return new ChainTransform.Result(payload, results);
    }
}

