/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.xpack.watcher.execution.AsyncTriggerListener;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.execution.InternalWatchExecutor;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatch;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatchStore;
import org.elasticsearch.xpack.watcher.execution.WatchExecutor;
import org.elasticsearch.xpack.watcher.trigger.TriggerEngine;

public class ExecutionModule
extends AbstractModule {
    private final Class<? extends WatchExecutor> executorClass;
    private final Class<? extends TriggerEngine.Listener> triggerEngineListenerClass;

    public ExecutionModule() {
        this(InternalWatchExecutor.class, AsyncTriggerListener.class);
    }

    protected ExecutionModule(Class<? extends WatchExecutor> executorClass, Class<? extends TriggerEngine.Listener> triggerEngineListenerClass) {
        this.executorClass = executorClass;
        this.triggerEngineListenerClass = triggerEngineListenerClass;
    }

    @Override
    protected void configure() {
        this.bind(TriggeredWatch.Parser.class).asEagerSingleton();
        this.bind(TriggeredWatchStore.class).asEagerSingleton();
        this.bind(ExecutionService.class).asEagerSingleton();
        this.bind(this.executorClass).asEagerSingleton();
        this.bind(this.triggerEngineListenerClass).asEagerSingleton();
        this.bind(WatchExecutor.class).to(this.executorClass);
    }
}

