/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.stream.StreamSupport;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.execution.SyncTriggerListener;
import org.elasticsearch.xpack.watcher.trigger.TriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;

public class AsyncTriggerListener
implements TriggerEngine.Listener {
    private final Logger logger;
    private final ExecutionService executionService;

    @Inject
    public AsyncTriggerListener(Settings settings, ExecutionService executionService, TriggerService triggerService) {
        this.logger = Loggers.getLogger(SyncTriggerListener.class, settings, new String[0]);
        this.executionService = executionService;
        triggerService.register(this);
    }

    @Override
    public void triggered(Iterable<TriggerEvent> events) {
        try {
            this.executionService.processEventsAsync(events);
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("failed to process triggered events [{}]", (Object)StreamSupport.stream(events.spliterator(), false).toArray(TriggerEvent[]::new)), (Throwable)e);
        }
    }
}

