/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.condition;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.xcontent.XContentUtils;
import org.elasticsearch.xpack.support.clock.Clock;
import org.elasticsearch.xpack.watcher.condition.AbstractCompareCondition;
import org.elasticsearch.xpack.watcher.condition.Condition;
import org.elasticsearch.xpack.watcher.condition.LenientCompare;
import org.elasticsearch.xpack.watcher.support.xcontent.ObjectPath;

public final class CompareCondition
extends AbstractCompareCondition {
    public static final String TYPE = "compare";
    private final String path;
    private final Op op;
    private final Object value;

    public CompareCondition(String path, Op op, Object value) {
        this(path, op, value, null);
    }

    CompareCondition(String path, Op op, Object value, Clock clock) {
        super(TYPE, clock);
        this.path = path;
        this.op = op;
        this.value = value;
    }

    public String getPath() {
        return this.path;
    }

    public Op getOp() {
        return this.op;
    }

    public Object getValue() {
        return this.value;
    }

    public static Condition parse(Clock clock, String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an object but found [{}] instead", new Object[]{TYPE, watchId, parser.currentToken()});
        }
        String path = null;
        Object value = null;
        Op op = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                path = parser.currentName();
                continue;
            }
            if (path == null) {
                throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected a field indicating the compared path, but found [{}] instead", new Object[]{TYPE, watchId, token});
            }
            if (token == XContentParser.Token.START_OBJECT) {
                token = parser.nextToken();
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected a field indicating the comparison operator, but found [{}] instead", new Object[]{TYPE, watchId, token});
                }
                try {
                    op = Op.resolve(parser.currentName());
                }
                catch (IllegalArgumentException iae) {
                    throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. unknown comparison operator [{}]", TYPE, watchId, parser.currentName());
                }
                token = parser.nextToken();
                if (!op.supportsStructures() && !token.isValue() && token != XContentParser.Token.VALUE_NULL) {
                    throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. compared value for [{}] with operation [{}] must either be a numeric, string, boolean or null value, but found [{}] instead", new Object[]{TYPE, watchId, path, op.name().toLowerCase(Locale.ROOT), token});
                }
                value = XContentUtils.readValue(parser, token);
                token = parser.nextToken();
                if (token == XContentParser.Token.END_OBJECT) continue;
                throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected end of path object, but found [{}] instead", new Object[]{TYPE, watchId, token});
            }
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an object for field [{}] but found [{}] instead", new Object[]{TYPE, watchId, path, token});
        }
        return new CompareCondition(path, op, value, clock);
    }

    @Override
    protected Condition.Result doExecute(Map<String, Object> model, Map<String, Object> resolvedValues) {
        Object configuredValue = this.resolveConfiguredValue(resolvedValues, model, this.value);
        Object resolvedValue = ObjectPath.eval(this.path, model);
        resolvedValues.put(this.path, resolvedValue);
        return new Condition.Result(resolvedValues, TYPE, this.op.eval(resolvedValue, configuredValue));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompareCondition condition = (CompareCondition)o;
        if (!Objects.equals(this.path, condition.path)) {
            return false;
        }
        if (this.op != condition.op) {
            return false;
        }
        return Objects.equals(this.value, condition.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.op, this.value});
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().startObject(this.path).field(this.op.id(), this.value).endObject().endObject();
    }

    public static enum Op {
        EQ{

            @Override
            public boolean eval(Object v1, Object v2) {
                Integer compVal = LenientCompare.compare(v1, v2);
                return compVal != null && compVal == 0;
            }

            @Override
            public boolean supportsStructures() {
                return true;
            }
        }
        ,
        NOT_EQ{

            @Override
            public boolean eval(Object v1, Object v2) {
                Integer compVal = LenientCompare.compare(v1, v2);
                return compVal == null || compVal != 0;
            }

            @Override
            public boolean supportsStructures() {
                return true;
            }
        }
        ,
        LT{

            @Override
            public boolean eval(Object v1, Object v2) {
                Integer compVal = LenientCompare.compare(v1, v2);
                return compVal != null && compVal < 0;
            }
        }
        ,
        LTE{

            @Override
            public boolean eval(Object v1, Object v2) {
                Integer compVal = LenientCompare.compare(v1, v2);
                return compVal != null && compVal <= 0;
            }
        }
        ,
        GT{

            @Override
            public boolean eval(Object v1, Object v2) {
                Integer compVal = LenientCompare.compare(v1, v2);
                return compVal != null && compVal > 0;
            }
        }
        ,
        GTE{

            @Override
            public boolean eval(Object v1, Object v2) {
                Integer compVal = LenientCompare.compare(v1, v2);
                return compVal != null && compVal >= 0;
            }
        };


        public abstract boolean eval(Object var1, Object var2);

        public boolean supportsStructures() {
            return false;
        }

        public String id() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static Op resolve(String id) {
            return Op.valueOf(id.toUpperCase(Locale.ROOT));
        }
    }
}

