/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.logging;

import java.util.Map;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.watcher.actions.logging.LoggingAction;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class ExecutableLoggingAction
extends ExecutableAction<LoggingAction> {
    private final Logger textLogger;
    private final TextTemplateEngine templateEngine;

    ExecutableLoggingAction(LoggingAction action, Logger logger, Settings settings, TextTemplateEngine templateEngine) {
        super(action, logger);
        this.textLogger = action.category != null ? Loggers.getLogger(action.category, settings, new String[0]) : logger;
        this.templateEngine = templateEngine;
    }

    ExecutableLoggingAction(LoggingAction action, Logger logger, Logger textLogger, TextTemplateEngine templateEngine) {
        super(action, logger);
        this.textLogger = textLogger;
        this.templateEngine = templateEngine;
    }

    Logger textLogger() {
        return this.textLogger;
    }

    @Override
    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        String loggedText = this.templateEngine.render(((LoggingAction)this.action).text, model);
        if (ctx.simulateAction(actionId)) {
            return new LoggingAction.Result.Simulated(loggedText);
        }
        ((LoggingAction)this.action).level.log(this.textLogger, loggedText);
        return new LoggingAction.Result.Success(loggedText);
    }
}

