/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.XPackFeatureSet;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.watcher.WatcherService;

public class WatcherFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;
    private final WatcherService watcherService;

    @Inject
    public WatcherFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState, @Nullable WatcherService watcherService) {
        this.watcherService = watcherService;
        this.enabled = XPackSettings.WATCHER_ENABLED.get(settings);
        this.licenseState = licenseState;
    }

    @Override
    public String name() {
        return "watcher";
    }

    @Override
    public String description() {
        return "Alerting, Notification and Automation for the Elastic Stack";
    }

    @Override
    public boolean available() {
        return this.licenseState != null && this.licenseState.isWatcherAllowed();
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        listener.onResponse(new Usage(this.available(), this.enabled(), this.watcherService != null ? this.watcherService.usageStats() : Collections.emptyMap()));
    }

    public static class Usage
    extends XPackFeatureSet.Usage {
        private final Map<String, Object> stats;

        public Usage(StreamInput in) throws IOException {
            super(in);
            this.stats = in.readMap();
        }

        public Usage(boolean available, boolean enabled, Map<String, Object> stats) {
            super("watcher", available, enabled);
            this.stats = stats;
        }

        public Map<String, Object> stats() {
            return this.stats;
        }

        @Override
        protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            super.innerXContent(builder, params);
            if (this.enabled) {
                for (Map.Entry<String, Object> entry : this.stats.entrySet()) {
                    builder.field(entry.getKey(), entry.getValue());
                }
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.stats);
        }
    }
}

