/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.netty3;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLEngine;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.jboss.netty.channel.Channel;
import org.elasticsearch.jboss.netty.channel.ChannelHandler;
import org.elasticsearch.jboss.netty.channel.ChannelHandlerContext;
import org.elasticsearch.jboss.netty.channel.ChannelPipeline;
import org.elasticsearch.jboss.netty.channel.ChannelPipelineFactory;
import org.elasticsearch.jboss.netty.channel.ChannelStateEvent;
import org.elasticsearch.jboss.netty.channel.SimpleChannelHandler;
import org.elasticsearch.jboss.netty.handler.ssl.SslHandler;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty3.Netty3Transport;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.transport.SSLExceptionHelper;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.netty3.IPFilterNetty3UpstreamHandler;
import org.elasticsearch.xpack.security.transport.netty3.Netty3HandshakeWaitingHandler;
import org.elasticsearch.xpack.ssl.SSLService;

public class SecurityNetty3Transport
extends Netty3Transport {
    public static final Setting<Boolean> PROFILE_SSL_SETTING = Setting.boolSetting(Security.setting("ssl.enabled"), false, new Setting.Property[0]);
    private final SSLService sslService;
    @Nullable
    private final IPFilter authenticator;
    private final Settings transportSSLSettings;
    private final boolean ssl;

    @Inject
    public SecurityNetty3Transport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, @Nullable IPFilter authenticator, SSLService sslService, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super(settings, threadPool, networkService, bigArrays, namedWriteableRegistry, circuitBreakerService);
        this.authenticator = authenticator;
        this.ssl = XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        this.sslService = sslService;
        this.transportSSLSettings = settings.getByPrefix(Security.setting("transport.ssl."));
    }

    @Override
    protected String deprecationMessage() {
        return "transport type [security3] is deprecated";
    }

    @Override
    protected void doStart() {
        super.doStart();
        if (this.authenticator != null) {
            this.authenticator.setBoundTransportAddress(this.boundAddress(), this.profileBoundAddresses());
        }
    }

    @Override
    public ChannelPipelineFactory configureClientChannelPipelineFactory() {
        return new SslClientChannelPipelineFactory(this);
    }

    @Override
    public ChannelPipelineFactory configureServerChannelPipelineFactory(String name, Settings profileSettings) {
        return new SslServerChannelPipelineFactory(this, name, this.settings, profileSettings);
    }

    @Override
    protected void onException(Channel channel, Exception e) throws IOException {
        if (SSLExceptionHelper.isNotSslRecordException(e)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("received plaintext traffic on a encrypted channel, closing connection {}", (Object)channel), (Throwable)e);
            } else {
                this.logger.warn("received plaintext traffic on a encrypted channel, closing connection {}", (Object)channel);
            }
            this.disconnectFromNodeChannel(channel, e);
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException(e)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("connection {} closed during handshake", (Object)channel), (Throwable)e);
            } else {
                this.logger.warn("connection {} closed during handshake", (Object)channel);
            }
            this.disconnectFromNodeChannel(channel, e);
        } else {
            super.onException(channel, e);
        }
    }

    public static Settings profileSslSettings(Settings profileSettings) {
        return profileSettings.getByPrefix(Security.setting("ssl."));
    }

    private class SslClientChannelPipelineFactory
    extends Netty3Transport.ClientChannelPipelineFactory {
        private final boolean hostnameVerificationEnabled;

        SslClientChannelPipelineFactory(Netty3Transport transport) {
            super(transport);
            this.hostnameVerificationEnabled = SecurityNetty3Transport.this.sslService.getVerificationMode(SecurityNetty3Transport.this.transportSSLSettings, Settings.EMPTY).isHostnameVerificationEnabled();
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            if (SecurityNetty3Transport.this.ssl) {
                pipeline.addFirst("sslInitializer", new ClientSslHandlerInitializer());
            }
            return pipeline;
        }

        private class ClientSslHandlerInitializer
        extends SimpleChannelHandler {
            private ClientSslHandlerInitializer() {
            }

            @Override
            public void connectRequested(ChannelHandlerContext ctx, ChannelStateEvent e) {
                SSLEngine sslEngine;
                if (SslClientChannelPipelineFactory.this.hostnameVerificationEnabled) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)e.getValue();
                    sslEngine = SecurityNetty3Transport.this.sslService.createSSLEngine(SecurityNetty3Transport.this.transportSSLSettings, Settings.EMPTY, inetSocketAddress.getHostString(), inetSocketAddress.getPort());
                } else {
                    sslEngine = SecurityNetty3Transport.this.sslService.createSSLEngine(SecurityNetty3Transport.this.transportSSLSettings, Settings.EMPTY);
                }
                sslEngine.setUseClientMode(true);
                ctx.getPipeline().replace(this, "ssl", (ChannelHandler)new SslHandler(sslEngine));
                ctx.getPipeline().addAfter("ssl", "handshake", new Netty3HandshakeWaitingHandler(SecurityNetty3Transport.this.logger));
                ctx.sendDownstream(e);
            }
        }
    }

    private class SslServerChannelPipelineFactory
    extends Netty3Transport.ServerChannelPipelineFactory {
        private final boolean profileSsl;
        private final Settings profileSslSettings;

        SslServerChannelPipelineFactory(Netty3Transport nettyTransport, String name, Settings settings, Settings profileSettings) {
            super(nettyTransport, name, settings);
            this.profileSsl = PROFILE_SSL_SETTING.exists(profileSettings) ? PROFILE_SSL_SETTING.get(profileSettings) : SecurityNetty3Transport.this.ssl;
            this.profileSslSettings = SecurityNetty3Transport.profileSslSettings(profileSettings);
            if (this.profileSsl && !SecurityNetty3Transport.this.sslService.isConfigurationValidForServerUsage(this.profileSslSettings, SecurityNetty3Transport.this.transportSSLSettings)) {
                if ("default".equals(name)) {
                    throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [xpack.security.transport.ssl.key] or [xpack.security.transport.ssl.keystore.path] setting");
                }
                throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [transport.profiles." + name + ".xpack.security.ssl.key] or [transport.profiles." + name + ".xpack.security.ssl.keystore.path] setting");
            }
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            if (this.profileSsl) {
                SSLEngine serverEngine = SecurityNetty3Transport.this.sslService.createSSLEngine(this.profileSslSettings, SecurityNetty3Transport.this.transportSSLSettings);
                serverEngine.setUseClientMode(false);
                pipeline.addFirst("ssl", new SslHandler(serverEngine));
            }
            if (SecurityNetty3Transport.this.authenticator != null) {
                pipeline.addFirst("ipfilter", new IPFilterNetty3UpstreamHandler(SecurityNetty3Transport.this.authenticator, this.name));
            }
            return pipeline;
        }
    }
}

