/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.netty3;

import javax.net.ssl.SSLEngine;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.netty3.Netty3HttpServerTransport;
import org.elasticsearch.jboss.netty.channel.ChannelHandlerContext;
import org.elasticsearch.jboss.netty.channel.ChannelPipeline;
import org.elasticsearch.jboss.netty.channel.ChannelPipelineFactory;
import org.elasticsearch.jboss.netty.channel.ExceptionEvent;
import org.elasticsearch.jboss.netty.handler.ssl.SslHandler;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty3.Netty3Utils;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.transport.SSLExceptionHelper;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.netty3.IPFilterNetty3UpstreamHandler;
import org.elasticsearch.xpack.ssl.SSLService;

public class SecurityNetty3HttpServerTransport
extends Netty3HttpServerTransport {
    private final IPFilter ipFilter;
    private final SSLService sslService;
    private final boolean ssl;

    public SecurityNetty3HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, IPFilter ipFilter, SSLService sslService, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher) {
        super(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher);
        this.ipFilter = ipFilter;
        this.sslService = sslService;
        this.ssl = XPackSettings.HTTP_SSL_ENABLED.get(settings);
    }

    @Override
    protected String deprecationMessage() {
        return "http type [security3] is deprecated";
    }

    @Override
    protected void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Netty3Utils.maybeDie(e.getCause());
        if (!this.lifecycle.started()) {
            return;
        }
        Throwable t = e.getCause();
        if (SSLExceptionHelper.isNotSslRecordException(t)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("received plaintext http traffic on a https channel, closing connection {}", (Object)ctx.getChannel()), t);
            } else {
                this.logger.warn("received plaintext http traffic on a https channel, closing connection {}", (Object)ctx.getChannel());
            }
            ctx.getChannel().close();
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException(t)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("connection {} closed during handshake", (Object)ctx.getChannel()), t);
            } else {
                this.logger.warn("connection {} closed during handshake", (Object)ctx.getChannel());
            }
            ctx.getChannel().close();
        } else {
            super.exceptionCaught(ctx, e);
        }
    }

    @Override
    protected void doStart() {
        super.doStart();
        this.ipFilter.setBoundHttpTransportAddress(this.boundAddress());
    }

    @Override
    public ChannelPipelineFactory configureServerChannelPipelineFactory() {
        return new HttpSslChannelPipelineFactory(this);
    }

    public static void overrideSettings(Settings.Builder settingsBuilder, Settings settings) {
        if (XPackSettings.HTTP_SSL_ENABLED.get(settings).booleanValue() && !HttpTransportSettings.SETTING_HTTP_COMPRESSION.exists(settings)) {
            settingsBuilder.put(HttpTransportSettings.SETTING_HTTP_COMPRESSION.getKey(), false);
        }
    }

    private class HttpSslChannelPipelineFactory
    extends Netty3HttpServerTransport.HttpChannelPipelineFactory {
        private final Settings sslSettings;

        HttpSslChannelPipelineFactory(Netty3HttpServerTransport transport) {
            super(transport, SecurityNetty3HttpServerTransport.this.detailedErrorsEnabled, SecurityNetty3HttpServerTransport.this.threadPool.getThreadContext());
            this.sslSettings = SSLService.getHttpTransportSSLSettings(SecurityNetty3HttpServerTransport.this.settings);
            if (SecurityNetty3HttpServerTransport.this.ssl && !SecurityNetty3HttpServerTransport.this.sslService.isConfigurationValidForServerUsage(this.sslSettings, Settings.EMPTY)) {
                throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [xpack.security.http.ssl.key] or [xpack.security.http.ssl.keystore.path] setting");
            }
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            if (SecurityNetty3HttpServerTransport.this.ssl) {
                SSLEngine engine = SecurityNetty3HttpServerTransport.this.sslService.createSSLEngine(this.sslSettings, Settings.EMPTY);
                pipeline.addFirst("ssl", new SslHandler(engine));
            }
            pipeline.addFirst("ipfilter", new IPFilterNetty3UpstreamHandler(SecurityNetty3HttpServerTransport.this.ipFilter, ".http"));
            return pipeline;
        }
    }
}

