/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.filter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.jboss.netty.handler.ipfilter.IpFilterRule;
import org.elasticsearch.jboss.netty.handler.ipfilter.IpSubnetFilterRule;
import org.elasticsearch.jboss.netty.handler.ipfilter.PatternRule;

public class SecurityIpFilterRule
implements IpFilterRule {
    public static final SecurityIpFilterRule ACCEPT_ALL = new SecurityIpFilterRule(true, "accept_all"){

        @Override
        public boolean contains(InetAddress inetAddress) {
            return true;
        }

        @Override
        public boolean isAllowRule() {
            return true;
        }

        @Override
        public boolean isDenyRule() {
            return false;
        }
    };
    public static final SecurityIpFilterRule DENY_ALL = new SecurityIpFilterRule(true, "deny_all"){

        @Override
        public boolean contains(InetAddress inetAddress) {
            return true;
        }

        @Override
        public boolean isAllowRule() {
            return false;
        }

        @Override
        public boolean isDenyRule() {
            return true;
        }
    };
    private final IpFilterRule ipFilterRule;
    private final String ruleSpec;

    public SecurityIpFilterRule(boolean isAllowRule, String ruleSpec) {
        this.ipFilterRule = SecurityIpFilterRule.getRule(isAllowRule, ruleSpec);
        this.ruleSpec = ruleSpec;
    }

    SecurityIpFilterRule(boolean isAllowRule, TransportAddress ... addresses) {
        this.ruleSpec = SecurityIpFilterRule.getRuleSpec(addresses);
        this.ipFilterRule = SecurityIpFilterRule.getRule(isAllowRule, this.ruleSpec);
    }

    @Override
    public boolean contains(InetAddress inetAddress) {
        return this.ipFilterRule.contains(inetAddress);
    }

    @Override
    public boolean isAllowRule() {
        return this.ipFilterRule.isAllowRule();
    }

    @Override
    public boolean isDenyRule() {
        return this.ipFilterRule.isDenyRule();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isAllowRule()) {
            builder.append("allow ");
        } else {
            builder.append("deny ");
        }
        builder.append(this.ruleSpec);
        return builder.toString();
    }

    static IpFilterRule getRule(boolean isAllowRule, String value) {
        Object[] values = value.split(",");
        int allRuleIndex = Arrays.binarySearch(values, 0, values.length, "_all");
        if (allRuleIndex >= 0) {
            if (values.length != 1) {
                throw new IllegalArgumentException("rules that specify _all may not have other values!");
            }
            return isAllowRule ? ACCEPT_ALL : DENY_ALL;
        }
        if (value.contains("/")) {
            if (values.length != 1) {
                throw new IllegalArgumentException("multiple subnet filters cannot be specified in a single rule!");
            }
            try {
                return new IpSubnetFilterRule(isAllowRule, value);
            }
            catch (UnknownHostException e) {
                String ruleType = isAllowRule ? "allow " : "deny ";
                throw new ElasticsearchException("unable to create ip filter for rule [" + ruleType + " " + value + "]", (Throwable)e, new Object[0]);
            }
        }
        boolean firstAdded = false;
        StringBuilder ruleSpec = new StringBuilder();
        for (Object singleValue : values) {
            if (firstAdded) {
                ruleSpec.append(",");
            } else {
                firstAdded = true;
            }
            boolean isInetAddress = InetAddresses.isInetAddress((String)singleValue);
            if (isInetAddress) {
                ruleSpec.append("i:");
            } else {
                ruleSpec.append("n:");
            }
            ruleSpec.append((String)singleValue);
        }
        return new PatternRule(isAllowRule, ruleSpec.toString());
    }

    static String getRuleSpec(TransportAddress ... addresses) {
        StringBuilder ruleSpec = new StringBuilder();
        boolean firstAdded = false;
        for (TransportAddress transportAddress : addresses) {
            if (firstAdded) {
                ruleSpec.append(",");
            } else {
                firstAdded = true;
            }
            assert (transportAddress instanceof InetSocketTransportAddress);
            ruleSpec.append(NetworkAddress.format(((InetSocketTransportAddress)transportAddress).address().getAddress()));
        }
        return ruleSpec.toString();
    }
}

