/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.XPackSettings;

public abstract class AbstractSecurityModule
extends AbstractModule {
    protected final Settings settings;
    protected final boolean clientMode;
    protected final boolean securityEnabled;

    public AbstractSecurityModule(Settings settings) {
        this.settings = settings;
        this.clientMode = "transport".equals(settings.get(Client.CLIENT_TYPE_SETTING_S.getKey()));
        this.securityEnabled = XPackSettings.SECURITY_ENABLED.get(settings);
    }

    @Override
    protected final void configure() {
        this.configure(this.clientMode);
    }

    protected abstract void configure(boolean var1);

    public static abstract class Node
    extends AbstractSecurityModule {
        protected Node(Settings settings) {
            super(settings);
        }

        @Override
        protected final void configure(boolean clientMode) {
            assert (!clientMode) : "[" + this.getClass().getSimpleName() + "] is a node only module";
            this.configureNode();
        }

        protected abstract void configureNode();
    }
}

