/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty3.Netty3HttpRequest;
import org.elasticsearch.http.netty4.Netty4HttpRequest;
import org.elasticsearch.io.netty.handler.ssl.SslHandler;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.rest.RestRequestFilter;
import org.elasticsearch.xpack.ssl.SSLService;

public class SecurityRestFilter
implements RestHandler {
    private static final Logger logger = ESLoggerFactory.getLogger(SecurityRestFilter.class);
    private final RestHandler restHandler;
    private final AuthenticationService service;
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final boolean extractClientCertificate;

    public SecurityRestFilter(Settings settings, XPackLicenseState licenseState, SSLService sslService, ThreadContext threadContext, AuthenticationService service, RestHandler restHandler) {
        this.restHandler = restHandler;
        this.service = service;
        this.licenseState = licenseState;
        this.threadContext = threadContext;
        boolean ssl = XPackSettings.HTTP_SSL_ENABLED.get(settings);
        Settings httpSSLSettings = SSLService.getHttpTransportSSLSettings(settings);
        this.extractClientCertificate = ssl && sslService.isSSLClientAuthEnabled(httpSSLSettings);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        if (this.licenseState.isAuthAllowed() && request.method() != RestRequest.Method.OPTIONS) {
            if (this.extractClientCertificate) {
                SecurityRestFilter.putClientCertificateInContext(request, this.threadContext, logger);
            }
            this.service.authenticate(this.maybeWrapRestRequest(request), ActionListener.wrap(authentication -> {
                RemoteHostHeader.process(request, this.threadContext);
                this.restHandler.handleRequest(request, channel, client);
            }, e -> {
                try {
                    channel.sendResponse(new BytesRestResponse(channel, (Exception)e));
                }
                catch (Exception inner) {
                    inner.addSuppressed((Throwable)e);
                    logger.error(() -> new ParameterizedMessage("failed to send failure response for uri [{}]", (Object)request.uri()), (Throwable)inner);
                }
            }));
        } else {
            this.restHandler.handleRequest(request, channel, client);
        }
    }

    private static void putClientCertificateInContext(RestRequest request, ThreadContext threadContext, Logger logger) throws Exception {
        assert (request instanceof Netty3HttpRequest || request instanceof Netty4HttpRequest);
        if (request instanceof Netty3HttpRequest) {
            Netty3HttpRequest nettyHttpRequest = (Netty3HttpRequest)request;
            org.elasticsearch.jboss.netty.handler.ssl.SslHandler handler = nettyHttpRequest.getChannel().getPipeline().get(org.elasticsearch.jboss.netty.handler.ssl.SslHandler.class);
            assert (handler != null);
            SecurityRestFilter.extractClientCerts(handler.getEngine(), nettyHttpRequest.getChannel(), threadContext, logger);
        } else if (request instanceof Netty4HttpRequest) {
            Netty4HttpRequest nettyHttpRequest = (Netty4HttpRequest)request;
            SslHandler handler = nettyHttpRequest.getChannel().pipeline().get(SslHandler.class);
            assert (handler != null);
            SecurityRestFilter.extractClientCerts(handler.engine(), nettyHttpRequest.getChannel(), threadContext, logger);
        }
    }

    private static void extractClientCerts(SSLEngine sslEngine, Object channel, ThreadContext threadContext, Logger logger) {
        block6: {
            try {
                Certificate[] certs = sslEngine.getSession().getPeerCertificates();
                if (certs instanceof X509Certificate[]) {
                    threadContext.putTransient("__SECURITY_CLIENT_CERTIFICATE", certs);
                }
            }
            catch (SSLPeerUnverifiedException e) {
                assert (!sslEngine.getNeedClientAuth());
                assert (sslEngine.getWantClientAuth());
                if (logger.isTraceEnabled()) {
                    logger.trace(() -> new ParameterizedMessage("SSL Peer did not present a certificate on channel [{}]", channel), (Throwable)e);
                }
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("SSL Peer did not present a certificate on channel [{}]", channel);
            }
        }
    }

    RestRequest maybeWrapRestRequest(RestRequest restRequest) throws IOException {
        if (this.restHandler instanceof RestRequestFilter) {
            return ((RestRequestFilter)((Object)this.restHandler)).getFilteredRequest(restRequest);
        }
        return restRequest;
    }
}

