/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.SecurityTemplateService;
import org.elasticsearch.xpack.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.security.action.role.ClearRolesCacheResponse;
import org.elasticsearch.xpack.security.action.role.DeleteRoleRequest;
import org.elasticsearch.xpack.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.client.SecurityClient;

public class NativeRolesStore
extends AbstractComponent
implements ClusterStateListener {
    private static final Setting<Integer> CACHE_SIZE_SETTING = Setting.intSetting(Security.setting("authz.store.roles.index.cache.max_size"), 10000, Setting.Property.NodeScope, Setting.Property.Deprecated);
    private static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting(Security.setting("authz.store.roles.index.cache.ttl"), TimeValue.timeValueMinutes(20L), Setting.Property.NodeScope, Setting.Property.Deprecated);
    private static final String ROLE_DOC_TYPE = "role";
    private final InternalClient client;
    private final XPackLicenseState licenseState;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIALIZED);
    private final boolean isTribeNode;
    private SecurityClient securityClient;
    private volatile boolean securityIndexExists = false;
    private volatile boolean canWrite = false;

    public NativeRolesStore(Settings settings, InternalClient client, XPackLicenseState licenseState) {
        super(settings);
        this.client = client;
        this.isTribeNode = !settings.getGroups("tribe", true).isEmpty();
        this.securityClient = new SecurityClient(client);
        this.licenseState = licenseState;
    }

    public boolean canStart(ClusterState clusterState, boolean master) {
        if (this.state() != State.INITIALIZED) {
            return false;
        }
        if (clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.logger.debug("native roles store waiting until gateway has recovered from disk");
            return false;
        }
        if (this.isTribeNode) {
            return true;
        }
        if (SecurityTemplateService.securityIndexMappingAndTemplateUpToDate(clusterState, this.logger)) {
            this.canWrite = true;
        } else if (SecurityTemplateService.securityIndexMappingAndTemplateSufficientToRead(clusterState, this.logger)) {
            this.canWrite = false;
        } else {
            this.canWrite = false;
            return false;
        }
        IndexMetaData metaData = clusterState.metaData().index(".security");
        if (metaData == null) {
            this.logger.debug("security index [{}] does not exist, so service can start", (Object)".security");
            return true;
        }
        if (clusterState.routingTable().index(".security").allPrimaryShardsActive()) {
            this.logger.debug("security index [{}] all primary shards started, so service can start", (Object)".security");
            this.securityIndexExists = true;
            return true;
        }
        return false;
    }

    public void start() {
        try {
            if (this.state.compareAndSet(State.INITIALIZED, State.STARTING)) {
                this.state.set(State.STARTED);
            }
        }
        catch (Exception e) {
            this.logger.error("failed to start ESNativeRolesStore", (Throwable)e);
            this.state.set(State.FAILED);
        }
    }

    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            this.state.set(State.STOPPED);
        }
    }

    public void getRoleDescriptors(String[] names, ActionListener<Collection<RoleDescriptor>> listener) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to get roles before service was started");
            listener.onResponse(Collections.emptySet());
            return;
        }
        if (names != null && names.length == 1) {
            this.getRoleDescriptor(Objects.requireNonNull(names[0]), ActionListener.wrap(roleDescriptor -> listener.onResponse(roleDescriptor == null ? Collections.emptyList() : Collections.singletonList(roleDescriptor)), listener::onFailure));
        } else {
            try {
                AbstractQueryBuilder query = names == null || names.length == 0 ? QueryBuilders.matchAllQuery() : QueryBuilders.boolQuery().filter(QueryBuilders.idsQuery(ROLE_DOC_TYPE).addIds(names));
                SearchRequest request = (SearchRequest)this.client.prepareSearch(".security").setTypes(ROLE_DOC_TYPE).setScroll(TimeValue.timeValueSeconds(10L)).setQuery(query).setSize(1000).setFetchSource(true).request();
                request.indicesOptions().ignoreUnavailable();
                InternalClient.fetchAllByEntity(this.client, request, listener, hit -> NativeRolesStore.transformRole(hit.getId(), hit.getSourceRef(), this.logger, this.licenseState));
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("unable to retrieve roles {}", (Object)Arrays.toString(names)), (Throwable)e);
                listener.onFailure(e);
            }
        }
    }

    public void deleteRole(final DeleteRoleRequest deleteRoleRequest, final ActionListener<Boolean> listener) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to delete role [{}] before service was started", (Object)deleteRoleRequest.name());
            listener.onResponse(false);
        } else {
            if (this.isTribeNode) {
                listener.onFailure(new UnsupportedOperationException("roles may not be deleted using a tribe node"));
                return;
            }
            if (!this.canWrite) {
                listener.onFailure(new IllegalStateException("role cannot be deleted as service cannot write until template and mappings are up to date"));
                return;
            }
        }
        try {
            DeleteRequest request = (DeleteRequest)this.client.prepareDelete(".security", ROLE_DOC_TYPE, deleteRoleRequest.name()).request();
            request.setRefreshPolicy(deleteRoleRequest.getRefreshPolicy());
            this.client.delete(request, new ActionListener<DeleteResponse>(){

                @Override
                public void onResponse(DeleteResponse deleteResponse) {
                    NativeRolesStore.this.clearRoleCache(deleteRoleRequest.name(), listener, deleteResponse.getResult() == DocWriteResponse.Result.DELETED);
                }

                @Override
                public void onFailure(Exception e) {
                    NativeRolesStore.this.logger.error("failed to delete role from the index", (Throwable)e);
                    listener.onFailure(e);
                }
            });
        }
        catch (IndexNotFoundException e) {
            this.logger.trace("security index does not exist", (Throwable)e);
            listener.onResponse(false);
        }
        catch (Exception e) {
            this.logger.error("unable to remove role", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void putRole(PutRoleRequest request, RoleDescriptor role, ActionListener<Boolean> listener) {
        if (this.state() != State.STARTED) {
            this.logger.trace("attempted to put role [{}] before service was started", (Object)request.name());
            listener.onResponse(false);
        } else if (this.isTribeNode) {
            listener.onFailure(new UnsupportedOperationException("roles may not be created or modified using a tribe node"));
        } else if (!this.canWrite) {
            listener.onFailure(new IllegalStateException("role cannot be created or modified as service cannot write until template and mappings are up to date"));
        } else if (this.licenseState.isDocumentAndFieldLevelSecurityAllowed()) {
            this.innerPutRole(request, role, listener);
        } else if (role.isUsingDocumentOrFieldLevelSecurity()) {
            listener.onFailure(LicenseUtils.newComplianceException("field and document level security"));
        } else {
            this.innerPutRole(request, role, listener);
        }
    }

    void innerPutRole(final PutRoleRequest request, final RoleDescriptor role, final ActionListener<Boolean> listener) {
        try {
            ((IndexRequestBuilder)this.client.prepareIndex(".security", ROLE_DOC_TYPE, role.getName()).setSource(role.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS, false)).setRefreshPolicy(request.getRefreshPolicy())).execute(new ActionListener<IndexResponse>(){

                @Override
                public void onResponse(IndexResponse indexResponse) {
                    boolean created = indexResponse.getResult() == DocWriteResponse.Result.CREATED;
                    NativeRolesStore.this.clearRoleCache(role.getName(), listener, created);
                }

                @Override
                public void onFailure(Exception e) {
                    NativeRolesStore.this.logger.error(() -> new ParameterizedMessage("failed to put role [{}]", (Object)request.name()), (Throwable)e);
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("unable to put role [{}]", (Object)request.name()), (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void usageStats(final ActionListener<Map<String, Object>> listener) {
        final HashMap<String, Constable> usageStats = new HashMap<String, Constable>();
        if (this.state() != State.STARTED) {
            listener.onResponse(Collections.emptyMap());
        } else if (!this.securityIndexExists) {
            usageStats.put("size", Long.valueOf(0L));
            usageStats.put("fls", Boolean.valueOf(false));
            usageStats.put("dls", Boolean.valueOf(false));
            listener.onResponse(usageStats);
        } else {
            this.client.prepareMultiSearch().add(this.client.prepareSearch(".security").setTypes(ROLE_DOC_TYPE).setQuery(QueryBuilders.matchAllQuery()).setSize(0)).add(this.client.prepareSearch(".security").setTypes(ROLE_DOC_TYPE).setQuery(QueryBuilders.boolQuery().should(QueryBuilders.existsQuery("indices.field_security.grant")).should(QueryBuilders.existsQuery("indices.field_security.except")).should(QueryBuilders.existsQuery("indices.fields"))).setSize(0).setTerminateAfter(1)).add(this.client.prepareSearch(".security").setTypes(ROLE_DOC_TYPE).setQuery(QueryBuilders.existsQuery("indices.query")).setSize(0).setTerminateAfter(1)).execute(new ActionListener<MultiSearchResponse>(){

                @Override
                public void onResponse(MultiSearchResponse items) {
                    MultiSearchResponse.Item[] responses = items.getResponses();
                    if (responses[0].isFailure()) {
                        usageStats.put("size", 0);
                    } else {
                        usageStats.put("size", responses[0].getResponse().getHits().getTotalHits());
                    }
                    if (responses[1].isFailure()) {
                        usageStats.put("fls", false);
                    } else {
                        usageStats.put("fls", responses[1].getResponse().getHits().getTotalHits() > 0L);
                    }
                    if (responses[2].isFailure()) {
                        usageStats.put("dls", false);
                    } else {
                        usageStats.put("dls", responses[2].getResponse().getHits().getTotalHits() > 0L);
                    }
                    listener.onResponse(usageStats);
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    private void getRoleDescriptor(final String roleId, final ActionListener<RoleDescriptor> roleActionListener) {
        if (!this.securityIndexExists) {
            roleActionListener.onResponse(null);
        } else {
            this.executeGetRoleRequest(roleId, new ActionListener<GetResponse>(){

                @Override
                public void onResponse(GetResponse response) {
                    RoleDescriptor descriptor = NativeRolesStore.this.transformRole(response);
                    roleActionListener.onResponse(descriptor);
                }

                @Override
                public void onFailure(Exception e) {
                    if (TransportActions.isShardNotAvailableException(e)) {
                        NativeRolesStore.this.logger.warn(() -> new ParameterizedMessage("failed to load role [{}] index not available", (Object)roleId), (Throwable)e);
                        roleActionListener.onResponse(null);
                    } else {
                        NativeRolesStore.this.logger.error(() -> new ParameterizedMessage("failed to load role [{}]", (Object)roleId), (Throwable)e);
                        roleActionListener.onFailure(e);
                    }
                }
            });
        }
    }

    private void executeGetRoleRequest(String role, ActionListener<GetResponse> listener) {
        try {
            GetRequest request = (GetRequest)this.client.prepareGet(".security", ROLE_DOC_TYPE, role).request();
            this.client.get(request, listener);
        }
        catch (IndexNotFoundException e) {
            this.logger.trace(() -> new ParameterizedMessage("unable to retrieve role [{}] since security index does not exist", (Object)role), (Throwable)e);
            listener.onResponse(new GetResponse(new GetResult(".security", ROLE_DOC_TYPE, role, -1L, false, null, null)));
        }
        catch (Exception e) {
            this.logger.error("unable to retrieve role", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void reset() {
        State state = this.state();
        if (state != State.STOPPED && state != State.FAILED) {
            throw new IllegalStateException("can only reset if stopped!!!");
        }
        this.securityIndexExists = false;
        this.canWrite = false;
        this.state.set(State.INITIALIZED);
    }

    private <Response> void clearRoleCache(final String role, final ActionListener<Response> listener, final Response response) {
        ClearRolesCacheRequest request = new ClearRolesCacheRequest().names(role);
        this.securityClient.clearRolesCache(request, new ActionListener<ClearRolesCacheResponse>(){

            @Override
            public void onResponse(ClearRolesCacheResponse nodes) {
                listener.onResponse(response);
            }

            @Override
            public void onFailure(Exception e) {
                NativeRolesStore.this.logger.error(() -> new ParameterizedMessage("unable to clear cache for role [{}]", (Object)role), (Throwable)e);
                ElasticsearchException exception = new ElasticsearchException("clearing the cache for [" + role + "] failed. please clear the role cache manually", (Throwable)e, new Object[0]);
                listener.onFailure(exception);
            }
        });
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        this.securityIndexExists = event.state().metaData().indices().get(".security") != null;
        this.canWrite = SecurityTemplateService.securityIndexMappingAndTemplateUpToDate(event.state(), this.logger);
    }

    public State state() {
        return this.state.get();
    }

    @Nullable
    private RoleDescriptor transformRole(GetResponse response) {
        if (!response.isExists()) {
            return null;
        }
        return NativeRolesStore.transformRole(response.getId(), response.getSourceAsBytesRef(), this.logger, this.licenseState);
    }

    @Nullable
    static RoleDescriptor transformRole(String name, BytesReference sourceBytes, Logger logger, XPackLicenseState licenseState) {
        try {
            RoleDescriptor roleDescriptor = RoleDescriptor.parse(name, sourceBytes, true, XContentType.JSON);
            if (licenseState.isDocumentAndFieldLevelSecurityAllowed()) {
                return roleDescriptor;
            }
            boolean dlsEnabled = Arrays.stream(roleDescriptor.getIndicesPrivileges()).anyMatch(RoleDescriptor.IndicesPrivileges::isUsingDocumentLevelSecurity);
            boolean flsEnabled = Arrays.stream(roleDescriptor.getIndicesPrivileges()).anyMatch(RoleDescriptor.IndicesPrivileges::isUsingFieldLevelSecurity);
            if (dlsEnabled || flsEnabled) {
                ArrayList<String> unlicensedFeatures = new ArrayList<String>(2);
                if (flsEnabled) {
                    unlicensedFeatures.add("fls");
                }
                if (dlsEnabled) {
                    unlicensedFeatures.add("dls");
                }
                HashMap<String, Object> transientMap = new HashMap<String, Object>(2);
                transientMap.put("unlicensed_features", unlicensedFeatures);
                transientMap.put("enabled", false);
                return new RoleDescriptor(roleDescriptor.getName(), roleDescriptor.getClusterPrivileges(), roleDescriptor.getIndicesPrivileges(), roleDescriptor.getRunAs(), roleDescriptor.getMetadata(), transientMap);
            }
            return roleDescriptor;
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("error in the format of data for role [{}]", (Object)name), (Throwable)e);
            return null;
        }
    }

    public static void addSettings(List<Setting<?>> settings) {
        settings.add(CACHE_SIZE_SETTING);
        settings.add(CACHE_TTL_SETTING);
    }

    public static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        FAILED;

    }
}

