/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.security.support.NoOpLogger;
import org.elasticsearch.xpack.security.support.Validation;

public class FileRolesStore
extends AbstractComponent {
    private static final Pattern IN_SEGMENT_LINE = Pattern.compile("^\\s+.+");
    private static final Pattern SKIP_LINE = Pattern.compile("(^#.*|^\\s*)");
    private final Path file;
    private final XPackLicenseState licenseState;
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private volatile Map<String, RoleDescriptor> permissions;

    public FileRolesStore(Settings settings, Environment env, ResourceWatcherService watcherService, XPackLicenseState licenseState) throws IOException {
        this(settings, env, watcherService, () -> {}, licenseState);
    }

    FileRolesStore(Settings settings, Environment env, ResourceWatcherService watcherService, Runnable listener, XPackLicenseState licenseState) throws IOException {
        super(settings);
        this.file = FileRolesStore.resolveFile(env);
        if (listener != null) {
            this.listeners.add(listener);
        }
        this.licenseState = licenseState;
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener(new FileListener());
        watcherService.add(watcher, ResourceWatcherService.Frequency.HIGH);
        this.permissions = FileRolesStore.parseFile(this.file, this.logger, settings, licenseState);
    }

    Set<RoleDescriptor> roleDescriptors(Set<String> roleNames) {
        HashSet<RoleDescriptor> descriptors = new HashSet<RoleDescriptor>();
        roleNames.forEach(name -> {
            RoleDescriptor descriptor = this.permissions.get(name);
            if (descriptor != null) {
                descriptors.add(descriptor);
            }
        });
        return descriptors;
    }

    public Map<String, Object> usageStats() {
        HashMap<String, Object> usageStats = new HashMap<String, Object>();
        usageStats.put("size", this.permissions.size());
        boolean dls = false;
        boolean fls = false;
        for (RoleDescriptor descriptor : this.permissions.values()) {
            for (RoleDescriptor.IndicesPrivileges indicesPrivileges : descriptor.getIndicesPrivileges()) {
                fls = fls || indicesPrivileges.getGrantedFields() != null || indicesPrivileges.getDeniedFields() != null;
                dls = dls || indicesPrivileges.getQuery() != null;
            }
            if (!fls || !dls) continue;
            break;
        }
        usageStats.put("fls", fls);
        usageStats.put("dls", dls);
        return usageStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(Runnable runnable) {
        Objects.requireNonNull(runnable);
        FileRolesStore fileRolesStore = this;
        synchronized (fileRolesStore) {
            this.listeners.add(runnable);
        }
    }

    public static Path resolveFile(Environment env) {
        return XPackPlugin.resolveConfigFile(env, "roles.yml");
    }

    public static Set<String> parseFileForRoleNames(Path path, Logger logger) {
        return FileRolesStore.parseRoleDescriptors(path, logger, false, Settings.EMPTY).keySet();
    }

    public static Map<String, RoleDescriptor> parseFile(Path path, Logger logger, Settings settings, XPackLicenseState licenseState) {
        return FileRolesStore.parseFile(path, logger, true, settings, licenseState);
    }

    public static Map<String, RoleDescriptor> parseFile(Path path, Logger logger, boolean resolvePermission, Settings settings, XPackLicenseState licenseState) {
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        HashMap<String, RoleDescriptor> roles = new HashMap<String, RoleDescriptor>();
        logger.debug("attempting to read roles file located at [{}]", (Object)path.toAbsolutePath());
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> roleSegments = FileRolesStore.roleSegments(path);
                boolean flsDlsLicensed = licenseState.isDocumentAndFieldLevelSecurityAllowed();
                for (String segment : roleSegments) {
                    RoleDescriptor descriptor = FileRolesStore.parseRoleDescriptor(segment, path, logger, resolvePermission, settings);
                    if (descriptor == null) continue;
                    if (ReservedRolesStore.isReserved(descriptor.getName())) {
                        logger.warn("role [{}] is reserved. the relevant role definition in the mapping file will be ignored", (Object)descriptor.getName());
                        continue;
                    }
                    if (!flsDlsLicensed && descriptor.isUsingDocumentOrFieldLevelSecurity()) {
                        logger.warn("role [{}] uses document and/or field level security, which is not enabled by the current license. this role will be ignored", (Object)descriptor.getName());
                        roles.put(descriptor.getName(), descriptor);
                        continue;
                    }
                    roles.put(descriptor.getName(), descriptor);
                }
            }
            catch (IOException ioe) {
                logger.error(() -> new ParameterizedMessage("failed to read roles file [{}]. skipping all roles...", (Object)path.toAbsolutePath()), (Throwable)ioe);
                return Collections.emptyMap();
            }
        } else {
            logger.debug("roles file does not exist");
            return Collections.emptyMap();
        }
        logger.debug("parsed [{}] roles from file [{}]", (Object)roles.size(), (Object)path.toAbsolutePath());
        return Collections.unmodifiableMap(roles);
    }

    public static Map<String, RoleDescriptor> parseRoleDescriptors(Path path, Logger logger, boolean resolvePermission, Settings settings) {
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        HashMap<String, RoleDescriptor> roles = new HashMap<String, RoleDescriptor>();
        logger.trace("attempting to read roles file located at [{}]", (Object)path.toAbsolutePath());
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<String> roleSegments = FileRolesStore.roleSegments(path);
                for (String segment : roleSegments) {
                    RoleDescriptor rd = FileRolesStore.parseRoleDescriptor(segment, path, logger, resolvePermission, settings);
                    if (rd == null) continue;
                    roles.put(rd.getName(), rd);
                }
            }
            catch (IOException ioe) {
                logger.error(() -> new ParameterizedMessage("failed to read roles file [{}]. skipping all roles...", (Object)path.toAbsolutePath()), (Throwable)ioe);
                return Collections.emptyMap();
            }
        }
        return Collections.unmodifiableMap(roles);
    }

    @Nullable
    static RoleDescriptor parseRoleDescriptor(String segment, Path path, Logger logger, boolean resolvePermissions, Settings settings) {
        String roleName = null;
        try {
            XContentParser parser = YamlXContent.yamlXContent.createParser(NamedXContentRegistry.EMPTY, segment);
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT && (token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                roleName = parser.currentName();
                Validation.Error validationError = Validation.Roles.validateRoleName(roleName);
                if (validationError != null) {
                    logger.error("invalid role definition [{}] in roles file [{}]. invalid role name - {}. skipping role... ", (Object)roleName, (Object)path.toAbsolutePath(), (Object)validationError);
                    return null;
                }
                if (!resolvePermissions) {
                    return new RoleDescriptor(roleName, null, null, null);
                }
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    RoleDescriptor descriptor = RoleDescriptor.parse(roleName, parser, true);
                    return FileRolesStore.checkDescriptor(descriptor, path, logger, settings);
                }
                logger.error("invalid role definition [{}] in roles file [{}]. skipping role...", (Object)roleName, (Object)path.toAbsolutePath());
                return null;
            }
            logger.error("invalid role definition [{}] in roles file [{}]. skipping role...", (Object)roleName, (Object)path.toAbsolutePath());
        }
        catch (ElasticsearchParseException e) {
            assert (roleName != null);
            if (logger.isDebugEnabled()) {
                String finalRoleName = roleName;
                logger.debug(() -> new ParameterizedMessage("parsing exception for role [{}]", (Object)finalRoleName), (Throwable)e);
            } else {
                logger.error(e.getMessage() + ". skipping role...");
            }
        }
        catch (IOException e) {
            if (roleName != null) {
                String finalRoleName = roleName;
                logger.error(() -> new ParameterizedMessage("invalid role definition [{}] in roles file [{}]. skipping role...", (Object)finalRoleName, (Object)path), (Throwable)e);
            }
            logger.error(() -> new ParameterizedMessage("invalid role definition in roles file [{}]. skipping role...", (Object)path), (Throwable)e);
        }
        return null;
    }

    @Nullable
    private static RoleDescriptor checkDescriptor(RoleDescriptor descriptor, Path path, Logger logger, Settings settings) {
        String roleName = descriptor.getName();
        for (RoleDescriptor.IndicesPrivileges privilege : descriptor.getIndicesPrivileges()) {
            if (privilege.getQuery() == null && privilege.getGrantedFields() == null && privilege.getDeniedFields() == null || XPackSettings.DLS_FLS_ENABLED.get(settings).booleanValue()) continue;
            logger.error("invalid role definition [{}] in roles file [{}]. document and field level security is not enabled. set [{}] to [true] in the configuration file. skipping role...", (Object)roleName, (Object)path.toAbsolutePath(), (Object)XPackSettings.DLS_FLS_ENABLED.getKey());
            return null;
        }
        return descriptor;
    }

    private static List<String> roleSegments(Path path) throws IOException {
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder builder = null;
        for (String line : Files.readAllLines(path, StandardCharsets.UTF_8)) {
            if (SKIP_LINE.matcher(line).matches()) continue;
            if (IN_SEGMENT_LINE.matcher(line).matches()) {
                if (builder == null) continue;
                builder.append(line).append("\n");
                continue;
            }
            if (builder != null) {
                segments.add(builder.toString());
            }
            builder = new StringBuilder(line).append("\n");
        }
        if (builder != null) {
            segments.add(builder.toString());
        }
        return segments;
    }

    private class FileListener
    implements FileChangesListener {
        private FileListener() {
        }

        @Override
        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        @Override
        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFileChanged(Path file) {
            if (file.equals(FileRolesStore.this.file)) {
                try {
                    FileRolesStore.this.permissions = FileRolesStore.parseFile(file, FileRolesStore.this.logger, FileRolesStore.this.settings, FileRolesStore.this.licenseState);
                    FileRolesStore.this.logger.info("updated roles (roles file [{}] changed)", (Object)file.toAbsolutePath());
                }
                catch (Exception e) {
                    FileRolesStore.this.logger.error(() -> new ParameterizedMessage("could not reload roles file [{}]. Current roles remain unmodified", (Object)file.toAbsolutePath()), (Throwable)e);
                    return;
                }
                FileRolesStore fileRolesStore = FileRolesStore.this;
                synchronized (fileRolesStore) {
                    FileRolesStore.this.listeners.forEach(Runnable::run);
                }
            }
        }
    }
}

