/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.pki;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.X509TrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.env.Environment;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.security.authc.Realm;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.pki.X509AuthenticationToken;
import org.elasticsearch.xpack.security.authc.support.DnRoleMapper;
import org.elasticsearch.xpack.security.transport.netty3.SecurityNetty3Transport;
import org.elasticsearch.xpack.security.user.User;
import org.elasticsearch.xpack.ssl.CertUtils;
import org.elasticsearch.xpack.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.ssl.SSLService;

public class PkiRealm
extends Realm {
    public static final String PKI_CERT_HEADER_NAME = "__SECURITY_CLIENT_CERTIFICATE";
    public static final String TYPE = "pki";
    static final String DEFAULT_USERNAME_PATTERN = "CN=(.*?)(?:,|$)";
    private static final Setting<Pattern> USERNAME_PATTERN_SETTING = new Setting<Pattern>("username_pattern", "CN=(.*?)(?:,|$)", s -> Pattern.compile(s, 2), Setting.Property.NodeScope);
    private static final SSLConfigurationSettings SSL_SETTINGS = SSLConfigurationSettings.withoutPrefix();
    public static final String AUTH_TYPE = "UNKNOWN";
    private final X509TrustManager trustManager;
    private final Pattern principalPattern;
    private final DnRoleMapper roleMapper;

    public PkiRealm(RealmConfig config, ResourceWatcherService watcherService, SSLService sslService) {
        this(config, new DnRoleMapper(TYPE, config, watcherService), sslService);
    }

    PkiRealm(RealmConfig config, DnRoleMapper roleMapper, SSLService sslService) {
        super(TYPE, config);
        this.trustManager = PkiRealm.trustManagers(config);
        this.principalPattern = USERNAME_PATTERN_SETTING.get(config.settings());
        this.roleMapper = roleMapper;
        PkiRealm.checkSSLEnabled(config, sslService);
    }

    @Override
    public boolean supports(AuthenticationToken token) {
        return token instanceof X509AuthenticationToken;
    }

    @Override
    public X509AuthenticationToken token(ThreadContext context) {
        return PkiRealm.token(context.getTransient(PKI_CERT_HEADER_NAME), this.principalPattern, this.logger);
    }

    @Override
    public User authenticate(AuthenticationToken authToken) {
        throw new UnsupportedOperationException("internal realms do not support blocking calls");
    }

    @Override
    public void authenticate(AuthenticationToken authToken, ActionListener<User> listener) {
        X509AuthenticationToken token = (X509AuthenticationToken)authToken;
        if (!PkiRealm.isCertificateChainTrusted(this.trustManager, token, this.logger)) {
            listener.onResponse(null);
        } else {
            Set<String> roles = this.roleMapper.resolveRoles(token.dn(), Collections.emptyList());
            listener.onResponse(new User(token.principal(), roles.toArray(new String[roles.size()])));
        }
    }

    @Override
    public User lookupUser(String username) {
        return null;
    }

    @Override
    public boolean userLookupSupported() {
        return false;
    }

    static X509AuthenticationToken token(Object pkiHeaderValue, Pattern principalPattern, Logger logger) {
        if (pkiHeaderValue == null) {
            return null;
        }
        assert (pkiHeaderValue instanceof X509Certificate[]);
        X509Certificate[] certificates = (X509Certificate[])pkiHeaderValue;
        if (certificates.length == 0) {
            return null;
        }
        String dn = certificates[0].getSubjectX500Principal().toString();
        Matcher matcher = principalPattern.matcher(dn);
        if (!matcher.find()) {
            if (logger.isDebugEnabled()) {
                logger.debug("certificate authentication succeeded for [{}] but could not extract principal from DN", (Object)dn);
            }
            return null;
        }
        String principal = matcher.group(1);
        if (Strings.isNullOrEmpty(principal)) {
            if (logger.isDebugEnabled()) {
                logger.debug("certificate authentication succeeded for [{}] but extracted principal was empty", (Object)dn);
            }
            return null;
        }
        return new X509AuthenticationToken(certificates, principal, dn);
    }

    static boolean isCertificateChainTrusted(X509TrustManager trustManager, X509AuthenticationToken token, Logger logger) {
        if (trustManager != null) {
            try {
                trustManager.checkClientTrusted(token.credentials(), AUTH_TYPE);
                return true;
            }
            catch (CertificateException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace(() -> new ParameterizedMessage("failed certificate validation for principal [{}]", (Object)token.principal()), (Throwable)e);
                } else if (logger.isDebugEnabled()) {
                    logger.debug("failed certificate validation for principal [{}]", (Object)token.principal());
                }
                return false;
            }
        }
        return true;
    }

    static X509TrustManager trustManagers(RealmConfig realmConfig) {
        Settings settings = realmConfig.settings();
        Environment env = realmConfig.env();
        String[] certificateAuthorities = settings.getAsArray(PkiRealm.SSL_SETTINGS.caPaths.getKey(), null);
        String truststorePath = PkiRealm.SSL_SETTINGS.truststorePath.get(settings).orElse(null);
        if (truststorePath == null && certificateAuthorities == null) {
            return null;
        }
        if (truststorePath != null && certificateAuthorities != null) {
            String pathKey = RealmSettings.getFullSettingKey(realmConfig, PkiRealm.SSL_SETTINGS.truststorePath);
            String caKey = RealmSettings.getFullSettingKey(realmConfig, PkiRealm.SSL_SETTINGS.caPaths);
            throw new IllegalArgumentException("[" + pathKey + "] and [" + caKey + "] cannot be used at the same time");
        }
        if (truststorePath != null) {
            return PkiRealm.trustManagersFromTruststore(truststorePath, realmConfig);
        }
        return PkiRealm.trustManagersFromCAs(settings, env);
    }

    private static X509TrustManager trustManagersFromTruststore(String truststorePath, RealmConfig realmConfig) {
        Settings settings = realmConfig.settings();
        String password = PkiRealm.SSL_SETTINGS.truststorePassword.get(settings).orElseThrow(() -> new IllegalArgumentException("[" + RealmSettings.getFullSettingKey(realmConfig, PkiRealm.SSL_SETTINGS.truststorePassword) + "] is not configured"));
        String trustStoreAlgorithm = PkiRealm.SSL_SETTINGS.truststoreAlgorithm.get(settings);
        try {
            return CertUtils.trustManager(truststorePath, password, trustStoreAlgorithm, realmConfig.env());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to load specified truststore", e);
        }
    }

    private static X509TrustManager trustManagersFromCAs(Settings settings, Environment env) {
        String[] certificateAuthorities = settings.getAsArray(PkiRealm.SSL_SETTINGS.caPaths.getKey(), null);
        assert (certificateAuthorities != null);
        try {
            Certificate[] certificates = CertUtils.readCertificates(Arrays.asList(certificateAuthorities), env);
            return CertUtils.trustManager(certificates);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to load certificate authorities for PKI realm", (Throwable)e, new Object[0]);
        }
    }

    static void checkSSLEnabled(RealmConfig config, SSLService sslService) {
        Settings settings = config.globalSettings();
        boolean httpSsl = XPackSettings.HTTP_SSL_ENABLED.get(settings);
        Settings httpSSLSettings = SSLService.getHttpTransportSSLSettings(settings);
        boolean httpClientAuth = sslService.isSSLClientAuthEnabled(httpSSLSettings);
        if (httpSsl && httpClientAuth) {
            return;
        }
        boolean ssl = XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        Settings transportSSLSettings = settings.getByPrefix(Security.setting("transport.ssl."));
        boolean clientAuthEnabled = sslService.isSSLClientAuthEnabled(transportSSLSettings);
        if (ssl && clientAuthEnabled) {
            return;
        }
        Map<String, Settings> groupedSettings = settings.getGroups("transport.profiles.");
        for (Map.Entry<String, Settings> entry : groupedSettings.entrySet()) {
            Settings profileSettings = entry.getValue().getByPrefix(Security.settingPrefix());
            if (!SecurityNetty3Transport.PROFILE_SSL_SETTING.get(profileSettings).booleanValue() || !sslService.isSSLClientAuthEnabled(SecurityNetty3Transport.profileSslSettings(profileSettings), transportSSLSettings)) continue;
            return;
        }
        throw new IllegalStateException("PKI realm [" + config.name() + "] is enabled but cannot be used as neither HTTP or Transport has SSL with client authentication enabled");
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.add(USERNAME_PATTERN_SETTING);
        settings.add(PkiRealm.SSL_SETTINGS.truststorePath);
        settings.add(PkiRealm.SSL_SETTINGS.truststorePassword);
        settings.add(PkiRealm.SSL_SETTINGS.truststoreAlgorithm);
        settings.add(PkiRealm.SSL_SETTINGS.caPaths);
        DnRoleMapper.getSettings(settings);
        return settings;
    }
}

