/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.security.support.Exceptions;

public class DefaultAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    @Override
    public ElasticsearchSecurityException failedAuthentication(RestRequest request, AuthenticationToken token, ThreadContext context) {
        return Exceptions.authenticationError("unable to authenticate user [{}] for REST request [{}]", token.principal(), request.uri());
    }

    @Override
    public ElasticsearchSecurityException failedAuthentication(TransportMessage message, AuthenticationToken token, String action, ThreadContext context) {
        return Exceptions.authenticationError("unable to authenticate user [{}] for action [{}]", token.principal(), action);
    }

    @Override
    public ElasticsearchSecurityException exceptionProcessingRequest(RestRequest request, Exception e, ThreadContext context) {
        if (e instanceof ElasticsearchSecurityException) {
            assert (((ElasticsearchSecurityException)e).status() == RestStatus.UNAUTHORIZED);
            assert (((ElasticsearchSecurityException)e).getHeader("WWW-Authenticate").size() == 1);
            return (ElasticsearchSecurityException)e;
        }
        return Exceptions.authenticationError("error attempting to authenticate request", e, new Object[0]);
    }

    @Override
    public ElasticsearchSecurityException exceptionProcessingRequest(TransportMessage message, String action, Exception e, ThreadContext context) {
        if (e instanceof ElasticsearchSecurityException) {
            assert (((ElasticsearchSecurityException)e).status() == RestStatus.UNAUTHORIZED);
            assert (((ElasticsearchSecurityException)e).getHeader("WWW-Authenticate").size() == 1);
            return (ElasticsearchSecurityException)e;
        }
        return Exceptions.authenticationError("error attempting to authenticate request", e, new Object[0]);
    }

    @Override
    public ElasticsearchSecurityException missingToken(RestRequest request, ThreadContext context) {
        return Exceptions.authenticationError("missing authentication token for REST request [{}]", request.uri());
    }

    @Override
    public ElasticsearchSecurityException missingToken(TransportMessage message, String action, ThreadContext context) {
        return Exceptions.authenticationError("missing authentication token for action [{}]", action);
    }

    @Override
    public ElasticsearchSecurityException authenticationRequired(String action, ThreadContext context) {
        return Exceptions.authenticationError("action [{}] requires authentication", action);
    }
}

