/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.security.action.user.SetEnabledRequest;
import org.elasticsearch.xpack.security.action.user.SetEnabledResponse;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.user.AnonymousUser;

public class TransportSetEnabledAction
extends HandledTransportAction<SetEnabledRequest, SetEnabledResponse> {
    private final NativeUsersStore usersStore;

    @Inject
    public TransportSetEnabledAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NativeUsersStore usersStore) {
        super(settings, "cluster:admin/xpack/security/user/set_enabled", threadPool, transportService, actionFilters, indexNameExpressionResolver, SetEnabledRequest::new);
        this.usersStore = usersStore;
    }

    @Override
    protected void doExecute(SetEnabledRequest request, final ActionListener<SetEnabledResponse> listener) {
        String username = request.username();
        if (Authentication.getAuthentication(this.threadPool.getThreadContext()).getRunAsUser().principal().equals(request.username())) {
            listener.onFailure(new IllegalArgumentException("users may not update the enabled status of their own account"));
            return;
        }
        if ("_system".equals(username) || "_xpack".equals(username)) {
            listener.onFailure(new IllegalArgumentException("user [" + username + "] is internal"));
            return;
        }
        if (AnonymousUser.isAnonymousUsername(username, this.settings)) {
            listener.onFailure(new IllegalArgumentException("user [" + username + "] is anonymous and cannot be modified using the api"));
            return;
        }
        this.usersStore.setEnabled(username, request.enabled(), request.getRefreshPolicy(), new ActionListener<Void>(){

            @Override
            public void onResponse(Void v) {
                listener.onResponse(new SetEnabledResponse());
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

