/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rest.action;

import java.io.IOException;
import java.util.EnumSet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackInfoResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.XPackClient;
import org.elasticsearch.xpack.action.XPackInfoRequest;
import org.elasticsearch.xpack.rest.XPackRestHandler;

public class RestXPackInfoAction
extends XPackRestHandler {
    public RestXPackInfoAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.HEAD, URI_BASE, this);
        controller.registerHandler(RestRequest.Method.GET, URI_BASE, this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(final RestRequest request, XPackClient client) throws IOException {
        final boolean verbose = request.paramAsBoolean("human", true);
        final EnumSet<XPackInfoRequest.Category> categories = XPackInfoRequest.Category.toSet(request.paramAsStringArray("categories", new String[]{"_all"}));
        return channel -> client.prepareInfo().setVerbose(verbose).setCategories(categories).execute(new RestBuilderListener<XPackInfoResponse>(channel){

            @Override
            public RestResponse buildResponse(XPackInfoResponse infoResponse, XContentBuilder builder) throws Exception {
                builder.startObject();
                if (infoResponse.getBuildInfo() != null) {
                    builder.field("build", infoResponse.getBuildInfo(), request);
                }
                if (infoResponse.getLicenseInfo() != null) {
                    builder.field("license", infoResponse.getLicenseInfo(), request);
                } else if (categories.contains((Object)XPackInfoRequest.Category.LICENSE)) {
                    builder.nullField("license");
                }
                if (infoResponse.getFeatureSetsInfo() != null) {
                    builder.field("features", infoResponse.getFeatureSetsInfo(), request);
                }
                if (verbose) {
                    builder.field("tagline", "You know, for X");
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

