/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.hipchat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.xpack.common.http.HttpClient;
import org.elasticsearch.xpack.common.http.HttpMethod;
import org.elasticsearch.xpack.common.http.HttpProxy;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.HttpResponse;
import org.elasticsearch.xpack.common.http.Scheme;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.hipchat.HipChatAccount;
import org.elasticsearch.xpack.notification.hipchat.HipChatMessage;
import org.elasticsearch.xpack.notification.hipchat.HipChatServer;
import org.elasticsearch.xpack.notification.hipchat.SentMessages;

public class IntegrationAccount
extends HipChatAccount {
    public static final String TYPE = "integration";
    final String room;
    final Defaults defaults;

    public IntegrationAccount(String name, Settings settings, HipChatServer defaultServer, HttpClient httpClient, Logger logger) {
        super(name, HipChatAccount.Profile.INTEGRATION, settings, defaultServer, httpClient, logger);
        String[] rooms = settings.getAsArray(ROOM_SETTING, null);
        if (rooms == null || rooms.length == 0) {
            throw new SettingsException("invalid hipchat account [" + name + "]. missing required [" + ROOM_SETTING + "] setting for [" + TYPE + "] account profile");
        }
        if (rooms.length > 1) {
            throw new SettingsException("invalid hipchat account [" + name + "]. [" + ROOM_SETTING + "] setting for [" + TYPE + "] account must only be set with a single value");
        }
        this.room = rooms[0];
        this.defaults = new Defaults(settings);
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void validateParsedTemplate(String watchId, String actionId, HipChatMessage.Template template) throws SettingsException {
        if (template.rooms != null) {
            throw new ElasticsearchParseException("invalid [hipchat] action for [" + watchId + "/" + actionId + "] action. [" + this.name + "] hipchat account doesn't support custom rooms", new Object[0]);
        }
        if (template.users != null) {
            throw new ElasticsearchParseException("invalid [hipchat] action for [" + watchId + "/" + actionId + "] action. [" + this.name + "] hipchat account doesn't support user private messages", new Object[0]);
        }
        if (template.from != null) {
            throw new ElasticsearchParseException("invalid [hipchat] action for [" + watchId + "/" + actionId + "] action. [" + this.name + "] hipchat account doesn't support custom `from` fields", new Object[0]);
        }
    }

    @Override
    public HipChatMessage render(String watchId, String actionId, TextTemplateEngine engine, HipChatMessage.Template template, Map<String, Object> model) {
        String message = engine.render(template.body, model);
        HipChatMessage.Color color = template.color != null ? HipChatMessage.Color.resolve(engine.render(template.color, model), this.defaults.color) : this.defaults.color;
        Boolean notify = template.notify != null ? template.notify : this.defaults.notify;
        HipChatMessage.Format messageFormat = template.format != null ? template.format : this.defaults.format;
        return new HipChatMessage(message, null, null, null, messageFormat, color, notify);
    }

    @Override
    public SentMessages send(HipChatMessage message, @Nullable HttpProxy proxy) {
        ArrayList<SentMessages.SentMessage> sentMessages = new ArrayList<SentMessages.SentMessage>();
        HttpRequest request = this.buildRoomRequest(this.room, message, proxy);
        try {
            HttpResponse response = this.httpClient.execute(request);
            sentMessages.add(SentMessages.SentMessage.responded(this.room, SentMessages.SentMessage.TargetType.ROOM, message, request, response));
        }
        catch (Exception e) {
            this.logger.error("failed to execute hipchat api http request", (Throwable)e);
            sentMessages.add(SentMessages.SentMessage.error(this.room, SentMessages.SentMessage.TargetType.ROOM, message, ExceptionsHelper.detailedMessage(e)));
        }
        return new SentMessages(this.name, sentMessages);
    }

    public HttpRequest buildRoomRequest(String room, final HipChatMessage message, HttpProxy proxy) {
        HttpRequest.Builder builder = this.server.httpRequest().method(HttpMethod.POST).scheme(Scheme.HTTPS).path("/v2/room/" + room + "/notification").setHeader("Content-Type", "application/json").setHeader("Authorization", "Bearer " + this.authToken).body(XContentHelper.toString(new ToXContent(){

            @Override
            public XContentBuilder toXContent(XContentBuilder xbuilder, ToXContent.Params params) throws IOException {
                xbuilder.field("message", message.body);
                if (message.format != null) {
                    xbuilder.field("message_format", message.format.value());
                }
                if (message.notify != null) {
                    xbuilder.field("notify", message.notify);
                }
                if (message.color != null) {
                    xbuilder.field("color", String.valueOf(message.color.value()));
                }
                return xbuilder;
            }
        }));
        if (proxy != null) {
            builder.proxy(proxy);
        }
        return builder.build();
    }

    static class Defaults {
        @Nullable
        final HipChatMessage.Format format;
        @Nullable
        final HipChatMessage.Color color;
        @Nullable
        final Boolean notify;

        Defaults(Settings settings) {
            this.format = HipChatMessage.Format.resolve(settings, HipChatAccount.DEFAULT_FORMAT_SETTING, null);
            this.color = HipChatMessage.Color.resolve(settings, HipChatAccount.DEFAULT_COLOR_SETTING, null);
            this.notify = settings.getAsBoolean(HipChatAccount.DEFAULT_NOTIFY_SETTING, null);
        }
    }
}

