/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.hipchat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.text.TextTemplate;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;

public class HipChatMessage
implements ToXContentObject {
    final String body;
    @Nullable
    final String[] rooms;
    @Nullable
    final String[] users;
    @Nullable
    final String from;
    @Nullable
    final Format format;
    @Nullable
    final Color color;
    @Nullable
    final Boolean notify;

    public HipChatMessage(String body, String[] rooms, String[] users, String from, Format format, Color color, Boolean notify) {
        this.body = body;
        this.rooms = rooms;
        this.users = users;
        this.from = from;
        this.format = format;
        this.color = color;
        this.notify = notify;
    }

    public String getBody() {
        return this.body;
    }

    public String[] getRooms() {
        return this.rooms;
    }

    @Nullable
    public String[] getUsers() {
        return this.users;
    }

    @Nullable
    public String getFrom() {
        return this.from;
    }

    @Nullable
    public Format getFormat() {
        return this.format;
    }

    @Nullable
    public Color getColor() {
        return this.color;
    }

    @Nullable
    public Boolean getNotify() {
        return this.notify;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HipChatMessage that = (HipChatMessage)o;
        return Objects.equals(this.body, that.body) && Objects.deepEquals(this.rooms, that.rooms) && Objects.deepEquals(this.users, that.users) && Objects.equals(this.from, that.from) && Objects.equals(this.format, that.format) && Objects.equals(this.color, that.color) && Objects.equals(this.notify, that.notify);
    }

    public int hashCode() {
        int result = this.body.hashCode();
        result = 31 * result + (this.rooms != null ? Arrays.hashCode(this.rooms) : 0);
        result = 31 * result + (this.users != null ? Arrays.hashCode(this.users) : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + (this.notify != null ? this.notify.hashCode() : 0);
        return result;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, true);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, boolean includeTargets) throws IOException {
        builder.startObject();
        if (this.from != null) {
            builder.field(Field.FROM.getPreferredName(), this.from);
        }
        if (includeTargets) {
            if (this.rooms != null && this.rooms.length > 0) {
                builder.array(Field.ROOM.getPreferredName(), this.rooms);
            }
            if (this.users != null && this.users.length > 0) {
                builder.array(Field.USER.getPreferredName(), this.users);
            }
        }
        builder.field(Field.BODY.getPreferredName(), this.body);
        if (this.format != null) {
            builder.field(Field.FORMAT.getPreferredName(), this.format, params);
        }
        if (this.color != null) {
            builder.field(Field.COLOR.getPreferredName(), this.color, params);
        }
        if (this.notify != null) {
            builder.field(Field.NOTIFY.getPreferredName(), this.notify);
        }
        return builder.endObject();
    }

    public static interface Field {
        public static final ParseField ROOM = new ParseField("room", new String[0]);
        public static final ParseField USER = new ParseField("user", new String[0]);
        public static final ParseField BODY = new ParseField("body", new String[0]);
        public static final ParseField FROM = new ParseField("from", new String[0]);
        public static final ParseField COLOR = new ParseField("color", new String[0]);
        public static final ParseField NOTIFY = new ParseField("notify", new String[0]);
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
    }

    public static enum Format implements ToXContent
    {
        TEXT,
        HTML;

        private final TextTemplate template = new TextTemplate(this.name());

        public TextTemplate asTemplate() {
            return this.template;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.name().toLowerCase(Locale.ROOT));
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static Format parse(XContentParser parser) throws IOException {
            return Format.valueOf(parser.text().toUpperCase(Locale.ROOT));
        }

        public static Format resolve(String value, Format defaultValue) {
            if (value == null) {
                return defaultValue;
            }
            return Format.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public static Format resolve(Settings settings, String setting, Format defaultValue) {
            return Format.resolve(settings.get(setting), defaultValue);
        }

        public static boolean validate(String value) {
            try {
                Format.valueOf(value.toUpperCase(Locale.ROOT));
                return true;
            }
            catch (IllegalArgumentException ilae) {
                return false;
            }
        }
    }

    public static enum Color implements ToXContent
    {
        YELLOW,
        GREEN,
        RED,
        PURPLE,
        GRAY,
        RANDOM;

        private final TextTemplate template = new TextTemplate(this.name());

        public TextTemplate asTemplate() {
            return this.template;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.name().toLowerCase(Locale.ROOT));
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static Color parse(XContentParser parser) throws IOException {
            return Color.valueOf(parser.text().toUpperCase(Locale.ROOT));
        }

        public static Color resolve(String value, Color defaultValue) {
            if (value == null) {
                return defaultValue;
            }
            return Color.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public static Color resolve(Settings settings, String setting, Color defaultValue) {
            return Color.resolve(settings.get(setting), defaultValue);
        }

        public static boolean validate(String value) {
            try {
                Color.valueOf(value.toUpperCase(Locale.ROOT));
                return true;
            }
            catch (IllegalArgumentException ilae) {
                return false;
            }
        }
    }

    public static class Template
    implements ToXContent {
        final TextTemplate body;
        @Nullable
        final TextTemplate[] rooms;
        @Nullable
        final TextTemplate[] users;
        @Nullable
        final String from;
        @Nullable
        final Format format;
        @Nullable
        final TextTemplate color;
        @Nullable
        final Boolean notify;

        public Template(TextTemplate body, TextTemplate[] rooms, TextTemplate[] users, String from, Format format, TextTemplate color, Boolean notify) {
            this.rooms = rooms;
            this.users = users;
            this.body = body;
            this.from = from;
            this.format = format;
            this.color = color;
            this.notify = notify;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            return Objects.equals(this.body, template.body) && Objects.deepEquals(this.rooms, template.rooms) && Objects.deepEquals(this.users, template.users) && Objects.equals(this.from, template.from) && Objects.equals(this.format, template.format) && Objects.equals(this.color, template.color) && Objects.equals(this.notify, template.notify);
        }

        public int hashCode() {
            return Objects.hash(this.body, this.rooms, this.users, this.from, this.format, this.color, this.notify);
        }

        public HipChatMessage render(TextTemplateEngine engine, Map<String, Object> model) {
            String body = engine.render(this.body, model);
            String[] rooms = null;
            if (this.rooms != null) {
                rooms = new String[this.rooms.length];
                for (int i = 0; i < this.rooms.length; ++i) {
                    rooms[i] = engine.render(this.rooms[i], model);
                }
            }
            String[] users = null;
            if (this.users != null) {
                users = new String[this.users.length];
                for (int i = 0; i < this.users.length; ++i) {
                    users[i] = engine.render(this.users[i], model);
                }
            }
            Color color = this.color == null ? null : Color.resolve(engine.render(this.color, model), null);
            return new HipChatMessage(body, rooms, users, this.from, this.format, color, this.notify);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.from != null) {
                builder.field(Field.FROM.getPreferredName(), this.from);
            }
            if (this.rooms != null && this.rooms.length > 0) {
                builder.startArray(Field.ROOM.getPreferredName());
                for (TextTemplate room : this.rooms) {
                    room.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.users != null && this.users.length > 0) {
                builder.startArray(Field.USER.getPreferredName());
                for (TextTemplate user : this.users) {
                    user.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.field(Field.BODY.getPreferredName(), this.body, params);
            if (this.format != null) {
                builder.field(Field.FORMAT.getPreferredName(), this.format, params);
            }
            if (this.color != null) {
                builder.field(Field.COLOR.getPreferredName(), this.color, params);
            }
            if (this.notify != null) {
                builder.field(Field.NOTIFY.getPreferredName(), this.notify);
            }
            return builder.endObject();
        }

        public static Template parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            TextTemplate body = null;
            TextTemplate[] rooms = null;
            TextTemplate[] users = null;
            String from = null;
            TextTemplate color = null;
            Boolean notify = null;
            Format messageFormat = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                ArrayList<TextTemplate> templates;
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Field.FROM.match(currentFieldName)) {
                    from = parser.text();
                    continue;
                }
                if (Field.ROOM.match(currentFieldName)) {
                    templates = new ArrayList<TextTemplate>();
                    if (token == XContentParser.Token.START_ARRAY) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            try {
                                templates.add(TextTemplate.parse(parser));
                            }
                            catch (ElasticsearchParseException epe) {
                                throw new ElasticsearchParseException("failed to parse hipchat message. failed to parse [{}] field", (Throwable)epe, Field.ROOM.getPreferredName());
                            }
                        }
                    } else {
                        try {
                            templates.add(TextTemplate.parse(parser));
                        }
                        catch (ElasticsearchParseException epe) {
                            throw new ElasticsearchParseException("failed to parse hipchat message. failed to parse [{}] field", (Throwable)epe, Field.ROOM.getPreferredName());
                        }
                    }
                    rooms = templates.toArray(new TextTemplate[templates.size()]);
                    continue;
                }
                if (Field.USER.match(currentFieldName)) {
                    templates = new ArrayList();
                    if (token == XContentParser.Token.START_ARRAY) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            try {
                                templates.add(TextTemplate.parse(parser));
                            }
                            catch (ElasticsearchParseException epe) {
                                throw new ElasticsearchParseException("failed to parse hipchat message. failed to parse [{}] field", (Throwable)epe, Field.USER.getPreferredName());
                            }
                        }
                    } else {
                        try {
                            templates.add(TextTemplate.parse(parser));
                        }
                        catch (ElasticsearchParseException epe) {
                            throw new ElasticsearchParseException("failed to parse hipchat message. failed to parse [{}] field", (Throwable)epe, Field.USER.getPreferredName());
                        }
                    }
                    users = templates.toArray(new TextTemplate[templates.size()]);
                    continue;
                }
                if (Field.COLOR.match(currentFieldName)) {
                    try {
                        color = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (IllegalArgumentException | ElasticsearchParseException e) {
                        throw new ElasticsearchParseException("failed to parse hipchat message. failed to parse [{}] field", (Throwable)e, Field.COLOR.getPreferredName());
                    }
                }
                if (Field.NOTIFY.match(currentFieldName)) {
                    if (token == XContentParser.Token.VALUE_BOOLEAN) {
                        notify = parser.booleanValue();
                        continue;
                    }
                    throw new ElasticsearchParseException("failed to parse hipchat message. failed to parse [{}] field, expected a boolean value but found [{}]", new Object[]{Field.NOTIFY.getPreferredName(), token});
                }
                if (Field.BODY.match(currentFieldName)) {
                    try {
                        body = TextTemplate.parse(parser);
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("failed to parse hipchat message. failed to parse [{}] field", (Throwable)pe, Field.BODY.getPreferredName());
                    }
                }
                if (Field.FORMAT.match(currentFieldName)) {
                    try {
                        messageFormat = Format.parse(parser);
                        continue;
                    }
                    catch (IllegalArgumentException ilae) {
                        throw new ElasticsearchParseException("failed to parse hipchat message. failed to parse [{}] field", (Throwable)ilae, Field.FORMAT.getPreferredName());
                    }
                }
                throw new ElasticsearchParseException("failed to parse hipchat message. unexpected field [{}]", currentFieldName);
            }
            if (body == null) {
                throw new ElasticsearchParseException("failed to parse hipchat message. missing required [{}] field", Field.BODY.getPreferredName());
            }
            return new Template(body, rooms, users, from, messageFormat, color, notify);
        }

        public static class Builder {
            final TextTemplate body;
            final List<TextTemplate> rooms = new ArrayList<TextTemplate>();
            final List<TextTemplate> users = new ArrayList<TextTemplate>();
            @Nullable
            String from;
            @Nullable
            Format format;
            @Nullable
            TextTemplate color;
            @Nullable
            Boolean notify;

            public Builder(TextTemplate body) {
                this.body = body;
            }

            public Builder addRooms(TextTemplate ... rooms) {
                this.rooms.addAll(Arrays.asList(rooms));
                return this;
            }

            public Builder addUsers(TextTemplate ... users) {
                this.users.addAll(Arrays.asList(users));
                return this;
            }

            public Builder setFrom(String from) {
                this.from = from;
                return this;
            }

            public Builder setFormat(Format format) {
                this.format = format;
                return this;
            }

            public Builder setColor(TextTemplate color) {
                this.color = color;
                return this;
            }

            public Builder setNotify(boolean notify) {
                this.notify = notify;
                return this;
            }

            public Template build() {
                return new Template(this.body, this.rooms.isEmpty() ? null : this.rooms.toArray(new TextTemplate[this.rooms.size()]), this.users.isEmpty() ? null : this.users.toArray(new TextTemplate[this.users.size()]), this.from, this.format, this.color, this.notify);
            }
        }
    }
}

