/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.email.attachment;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.common.http.auth.HttpAuth;
import org.elasticsearch.xpack.notification.email.attachment.EmailAttachmentParser;

public class ReportingAttachment
implements EmailAttachmentParser.EmailAttachment {
    private static final ParseField INLINE = new ParseField("inline", new String[0]);
    private static final ParseField AUTH = new ParseField("auth", new String[0]);
    private static final ParseField INTERVAL = new ParseField("interval", new String[0]);
    private static final ParseField RETRIES = new ParseField("retries", new String[0]);
    private static final ParseField URL = new ParseField("url", new String[0]);
    private final boolean inline;
    private final String id;
    private final HttpAuth auth;
    private final String url;
    private final TimeValue interval;
    private final Integer retries;

    public ReportingAttachment(String id, String url, boolean inline) {
        this(id, url, inline, null, null, null);
    }

    public ReportingAttachment(String id, String url, boolean inline, @Nullable TimeValue interval, @Nullable Integer retries, @Nullable HttpAuth auth) {
        this.id = id;
        this.url = url;
        this.retries = retries;
        this.inline = inline;
        this.auth = auth;
        this.interval = interval;
        if (retries != null && retries < 0) {
            throw new IllegalArgumentException("Retries for attachment must be >= 0");
        }
    }

    @Override
    public String type() {
        return "reporting";
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public boolean inline() {
        return this.inline;
    }

    public HttpAuth auth() {
        return this.auth;
    }

    public String url() {
        return this.url;
    }

    public TimeValue interval() {
        return this.interval;
    }

    public Integer retries() {
        return this.retries;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.id).startObject("reporting").field(URL.getPreferredName(), this.url);
        if (this.retries != null) {
            builder.field(RETRIES.getPreferredName(), this.retries);
        }
        if (this.interval != null) {
            builder.field(INTERVAL.getPreferredName(), this.interval);
        }
        if (this.inline) {
            builder.field(INLINE.getPreferredName(), this.inline);
        }
        if (this.auth != null) {
            builder.startObject(AUTH.getPreferredName());
            builder.field(this.auth.type(), this.auth, params);
            builder.endObject();
        }
        return builder.endObject().endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportingAttachment otherAttachment = (ReportingAttachment)o;
        return Objects.equals(this.id, otherAttachment.id) && Objects.equals(this.url, otherAttachment.url) && Objects.equals(this.interval, otherAttachment.interval) && Objects.equals(this.inline, otherAttachment.inline) && Objects.equals(this.retries, otherAttachment.retries) && Objects.equals(this.auth, otherAttachment.auth);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url, this.interval, this.inline, this.retries, this.auth);
    }
}

