/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.XPackPlugin;

public class MonitoringSettings
extends AbstractComponent {
    public static final String LEGACY_DATA_INDEX_NAME = ".marvel-es-data";
    public static final String HISTORY_DURATION_SETTING_NAME = "history.duration";
    public static final TimeValue HISTORY_DURATION_MINIMUM = TimeValue.timeValueHours(24L);
    static final TimeValue MIN_INTERVAL = TimeValue.timeValueSeconds(1L);
    public static final Setting<TimeValue> INTERVAL = new Setting<TimeValue>(MonitoringSettings.collectionKey("interval"), "10s", s -> {
        TimeValue value = TimeValue.parseTimeValue(s, null, MonitoringSettings.collectionKey("interval"));
        if (TimeValue.MINUS_ONE.equals(value) || value.millis() >= MIN_INTERVAL.millis()) {
            return value;
        }
        throw new IllegalArgumentException("Failed to parse monitoring interval [" + s + "], value must be >= " + MIN_INTERVAL);
    }, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDEX_STATS_TIMEOUT = Setting.timeSetting(MonitoringSettings.collectionKey("index.stats.timeout"), TimeValue.timeValueSeconds(10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_STATS_TIMEOUT = Setting.timeSetting(MonitoringSettings.collectionKey("indices.stats.timeout"), TimeValue.timeValueSeconds(10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<List<String>> INDICES = Setting.listSetting(MonitoringSettings.collectionKey("indices"), Collections.emptyList(), Function.identity(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> CLUSTER_STATE_TIMEOUT = Setting.timeSetting(MonitoringSettings.collectionKey("cluster.state.timeout"), TimeValue.timeValueSeconds(10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> CLUSTER_STATS_TIMEOUT = Setting.timeSetting(MonitoringSettings.collectionKey("cluster.stats.timeout"), TimeValue.timeValueSeconds(10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDEX_RECOVERY_TIMEOUT = Setting.timeSetting(MonitoringSettings.collectionKey("index.recovery.timeout"), TimeValue.timeValueSeconds(10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> INDEX_RECOVERY_ACTIVE_ONLY = Setting.boolSetting(MonitoringSettings.collectionKey("index.recovery.active_only"), false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<List<String>> COLLECTORS = Setting.listSetting(MonitoringSettings.collectionKey("collectors"), Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final Setting<TimeValue> HISTORY_DURATION = Setting.timeSetting(MonitoringSettings.key("history.duration"), TimeValue.timeValueHours(168L), HISTORY_DURATION_MINIMUM, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Settings> EXPORTERS_SETTINGS = Setting.groupSetting(MonitoringSettings.key("exporters."), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile TimeValue indexStatsTimeout;
    private volatile TimeValue indicesStatsTimeout;
    private volatile TimeValue clusterStateTimeout;
    private volatile TimeValue clusterStatsTimeout;
    private volatile TimeValue recoveryTimeout;
    private volatile boolean recoveryActiveOnly;
    private volatile String[] indices;

    public static List<Setting<?>> getSettings() {
        return Arrays.asList(INDICES, INTERVAL, INDEX_RECOVERY_TIMEOUT, INDEX_STATS_TIMEOUT, INDICES_STATS_TIMEOUT, INDEX_RECOVERY_ACTIVE_ONLY, COLLECTORS, CLUSTER_STATE_TIMEOUT, CLUSTER_STATS_TIMEOUT, HISTORY_DURATION, EXPORTERS_SETTINGS);
    }

    public static List<String> getSettingsFilter() {
        return Arrays.asList(MonitoringSettings.key("exporters.*.auth.*"), MonitoringSettings.key("exporters.*.ssl.*"));
    }

    public MonitoringSettings(Settings settings, ClusterSettings clusterSettings) {
        super(settings);
        this.setIndexStatsTimeout(INDEX_STATS_TIMEOUT.get(settings));
        clusterSettings.addSettingsUpdateConsumer(INDEX_STATS_TIMEOUT, this::setIndexStatsTimeout);
        this.setIndicesStatsTimeout(INDICES_STATS_TIMEOUT.get(settings));
        clusterSettings.addSettingsUpdateConsumer(INDICES_STATS_TIMEOUT, this::setIndicesStatsTimeout);
        this.setIndices(INDICES.get(settings));
        clusterSettings.addSettingsUpdateConsumer(INDICES, this::setIndices);
        this.setClusterStateTimeout(CLUSTER_STATE_TIMEOUT.get(settings));
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_STATE_TIMEOUT, this::setClusterStateTimeout);
        this.setClusterStatsTimeout(CLUSTER_STATS_TIMEOUT.get(settings));
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_STATS_TIMEOUT, this::setClusterStatsTimeout);
        this.setRecoveryTimeout(INDEX_RECOVERY_TIMEOUT.get(settings));
        clusterSettings.addSettingsUpdateConsumer(INDEX_RECOVERY_TIMEOUT, this::setRecoveryTimeout);
        this.setRecoveryActiveOnly(INDEX_RECOVERY_ACTIVE_ONLY.get(settings));
        clusterSettings.addSettingsUpdateConsumer(INDEX_RECOVERY_ACTIVE_ONLY, this::setRecoveryActiveOnly);
    }

    public TimeValue indexStatsTimeout() {
        return this.indexStatsTimeout;
    }

    public TimeValue indicesStatsTimeout() {
        return this.indicesStatsTimeout;
    }

    public String[] indices() {
        return this.indices;
    }

    public TimeValue clusterStateTimeout() {
        return this.clusterStateTimeout;
    }

    public TimeValue clusterStatsTimeout() {
        return this.clusterStatsTimeout;
    }

    public TimeValue recoveryTimeout() {
        return this.recoveryTimeout;
    }

    public boolean recoveryActiveOnly() {
        return this.recoveryActiveOnly;
    }

    private void setIndexStatsTimeout(TimeValue indexStatsTimeout) {
        this.indexStatsTimeout = indexStatsTimeout;
    }

    private void setIndicesStatsTimeout(TimeValue indicesStatsTimeout) {
        this.indicesStatsTimeout = indicesStatsTimeout;
    }

    private void setClusterStateTimeout(TimeValue clusterStateTimeout) {
        this.clusterStateTimeout = clusterStateTimeout;
    }

    private void setClusterStatsTimeout(TimeValue clusterStatsTimeout) {
        this.clusterStatsTimeout = clusterStatsTimeout;
    }

    private void setRecoveryTimeout(TimeValue recoveryTimeout) {
        this.recoveryTimeout = recoveryTimeout;
    }

    private void setRecoveryActiveOnly(boolean recoveryActiveOnly) {
        this.recoveryActiveOnly = recoveryActiveOnly;
    }

    private void setIndices(List<String> indices) {
        this.indices = indices.toArray(new String[0]);
    }

    static String collectionKey(String key) {
        return MonitoringSettings.key("collection." + key);
    }

    static String key(String key) {
        return XPackPlugin.featureSettingPrefix("monitoring") + "." + key;
    }
}

