/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.extensions;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.XPackPlugin;

class RemoveXPackExtensionCommand
extends EnvironmentAwareCommand {
    private final OptionSpec<String> arguments;

    RemoveXPackExtensionCommand() {
        super("Removes an extension from x-pack");
        this.arguments = this.parser.nonOptions("extension name");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        List<String> args = this.arguments.values(options);
        if (args.size() != 1) {
            throw new UserException(64, "Must supply a single extension id argument");
        }
        this.execute(terminal, args.get(0), env);
    }

    void execute(Terminal terminal, String extensionName, Environment env) throws Exception {
        terminal.println("-> Removing " + Strings.coalesceToEmpty(extensionName) + "...");
        Path extensionDir = XPackPlugin.resolveXPackExtensionsFile(env).resolve(extensionName);
        if (!Files.exists(extensionDir, new LinkOption[0])) {
            throw new UserException(64, "Extension " + extensionName + " not found. Run 'bin/x-pack/extension list' to get list of installed extensions.");
        }
        ArrayList<Path> extensionPaths = new ArrayList<Path>();
        terminal.println(Terminal.Verbosity.VERBOSE, "Removing: " + extensionDir);
        Path tmpExtensionDir = XPackPlugin.resolveXPackExtensionsFile(env).resolve(".removing-" + extensionName);
        Files.move(extensionDir, tmpExtensionDir, StandardCopyOption.ATOMIC_MOVE);
        extensionPaths.add(tmpExtensionDir);
        IOUtils.rm(extensionPaths.toArray(new Path[extensionPaths.size()]));
    }
}

