/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public enum Scheme implements ToXContent
{
    HTTP("http", 80),
    HTTPS("https", 443);

    private final String scheme;
    private final int defaultPort;

    private Scheme(String scheme, int defaultPort) {
        this.scheme = scheme;
        this.defaultPort = defaultPort;
    }

    public String scheme() {
        return this.scheme;
    }

    public int defaultPort() {
        return this.defaultPort;
    }

    public static Scheme parse(String value) {
        switch (value = value.toLowerCase(Locale.ROOT)) {
            case "http": {
                return HTTP;
            }
            case "https": {
                return HTTPS;
            }
        }
        throw new IllegalArgumentException("unsupported http scheme [" + value + "]");
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.name().toLowerCase(Locale.ROOT));
    }
}

